/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codescene.Domain;

import java.util.ArrayList;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.jenkinsci.plugins.codescene.Domain.CodeHealthDeltaDescription;
import org.jenkinsci.plugins.codescene.Domain.Commits;
import org.jenkinsci.plugins.codescene.Domain.Configuration;
import org.jenkinsci.plugins.codescene.Domain.Improvements;
import org.jenkinsci.plugins.codescene.Domain.NewFiles;
import org.jenkinsci.plugins.codescene.Domain.QualityGates;
import org.jenkinsci.plugins.codescene.Domain.RiskClassification;
import org.jenkinsci.plugins.codescene.Domain.RiskDescription;
import org.jenkinsci.plugins.codescene.Domain.Warning;
import org.jenkinsci.plugins.codescene.Domain.WarningCategory;
import org.jenkinsci.plugins.codescene.Domain.Warnings;

public class DeltaAnalysisResult {
    private final String viewUrl;
    private final Commits commits;
    private final RiskClassification risk;
    private final Improvements improvements;
    private final Warnings warnings;
    private final RiskDescription description;
    private final QualityGates gates;
    private final CodeHealthDeltaDescription codeHealthDeltaDescription;
    private final NewFiles newFiles;

    public DeltaAnalysisResult(Commits commits, Configuration userConfig, JsonObject result) {
        this.ensureTheVersionIsSupported(result);
        JsonObject deltaResult = result.getJsonObject("result");
        this.viewUrl = result.getString("view");
        this.risk = this.riskFrom(deltaResult);
        this.improvements = Improvements.in(deltaResult);
        this.warnings = DeltaAnalysisResult.warningsFrom(deltaResult);
        this.description = this.descriptionOfRiskFrom(deltaResult, DeltaAnalysisResult.versionOf(result));
        this.commits = commits;
        this.gates = this.triggeredQualityGatesFrom(deltaResult, userConfig);
        this.codeHealthDeltaDescription = new CodeHealthDeltaDescription(deltaResult);
        this.newFiles = new NewFiles(deltaResult);
    }

    private QualityGates triggeredQualityGatesFrom(JsonObject deltaResult, Configuration userConfig) {
        if (deltaResult.containsKey((Object)"quality-gates")) {
            return new QualityGates(deltaResult, userConfig);
        }
        return QualityGates.none();
    }

    private RiskClassification riskFrom(JsonObject deltaResult) {
        return new RiskClassification(deltaResult.getJsonNumber("risk").intValue());
    }

    private static Warnings warningsFrom(JsonObject deltaResult) {
        Warnings ws = new Warnings();
        JsonArray jsonWarnings = deltaResult.getJsonArray("warnings");
        for (int i = 0; i < jsonWarnings.size(); ++i) {
            JsonObject w = jsonWarnings.getJsonObject(i);
            WarningCategory category = new WarningCategory(w.getString("category"));
            JsonArray jsonDetails = w.getJsonArray("details");
            ArrayList<String> ds = new ArrayList<String>();
            for (int j = 0; j < jsonDetails.size(); ++j) {
                ds.add(jsonDetails.getString(j));
            }
            ArrayList<String> details = new ArrayList<String>(ds);
            ws.add(new Warning(category, details));
        }
        return ws;
    }

    private RiskDescription descriptionOfRiskFrom(JsonObject deltaResult, String version) {
        if (version.equals("1")) {
            return new RiskDescription("No risk description available: upgrade CodeScene");
        }
        return new RiskDescription(deltaResult.getString("description"));
    }

    private void ensureTheVersionIsSupported(JsonObject result) {
        String version = DeltaAnalysisResult.versionOf(result);
        if (!version.equals("1") && !version.equals("2")) {
            throw new RuntimeException("The CodeScene API reports version " + version + ", which we don't support. You need to upgrade CodeScene.");
        }
    }

    private static String versionOf(JsonObject result) {
        return result.getString("version");
    }

    public String getViewUrl() {
        return this.viewUrl;
    }

    public Commits getCommits() {
        return this.commits;
    }

    public RiskClassification getRisk() {
        return this.risk;
    }

    public Improvements improvements() {
        return this.improvements;
    }

    public RiskDescription getRiskDescription() {
        return this.description;
    }

    public Warnings getWarnings() {
        return this.warnings;
    }

    public QualityGates qualityGatesState() {
        return this.gates;
    }

    public CodeHealthDeltaDescription describeCodeHealthDelta() {
        return this.codeHealthDeltaDescription;
    }

    public NewFiles getNewFilesFeedback() {
        return this.newFiles;
    }
}

