/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codescene.Domain;

import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.jenkinsci.plugins.codescene.Domain.Commit;
import org.jenkinsci.plugins.codescene.Domain.Commits;
import org.jenkinsci.plugins.codescene.Domain.Configuration;

public class DeltaAnalysisRequest {
    private final JsonObject value;

    public DeltaAnalysisRequest(Commits commits, Configuration userConfig) {
        JsonArray cs = DeltaAnalysisRequest.serialize(commits);
        JsonObjectBuilder b = Json.createObjectBuilder();
        b.add("commits", (JsonValue)cs);
        b.add("repository", userConfig.gitRepositoryToAnalyze().value());
        b.add("coupling_threshold_percent", userConfig.couplingThresholdPercent());
        if (userConfig.originUrl() != null && userConfig.changeRef() != null) {
            b.add("origin_url", userConfig.originUrl());
            b.add("change_ref", userConfig.changeRef());
        }
        if (userConfig.currentCommit() != null) {
            b.add("delta_branch_head", userConfig.currentCommit().toString());
        }
        if (userConfig.baseRevision() != null) {
            b.add("target_ref", userConfig.baseRevision());
        }
        this.value = b.build();
    }

    private static JsonArray serialize(Commits commits) {
        JsonArrayBuilder b = Json.createArrayBuilder();
        for (Commit c : commits.value()) {
            b.add(c.value());
        }
        return b.build();
    }

    public JsonObject asJson() {
        return this.value;
    }
}

