/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codescene.Domain;

import java.util.Collection;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import org.apache.commons.lang.StringUtils;

public class CodeHealthDelta {
    private String improvements;
    private String degradations;
    private String name;

    public CodeHealthDelta(JsonObject deltaTrendPart) {
        if (null == deltaTrendPart) {
            throw new IllegalArgumentException("The code health delta trend cannot be null. This should be checked in the calling context");
        }
        this.name = deltaTrendPart.getString("name", "Missing Name");
        this.improvements = CodeHealthDelta.formatDeltaIn(deltaTrendPart.getJsonArray("improved"));
        this.degradations = CodeHealthDelta.formatDeltaIn(deltaTrendPart.getJsonArray("degraded"));
    }

    private static String formatDeltaIn(JsonArray delta) {
        String formattedDelta = StringUtils.join((Collection)delta.getValuesAs(JsonString.class), (String)", ");
        return StringUtils.isEmpty((String)formattedDelta) ? "-" : formattedDelta;
    }

    public String getName() {
        return this.name;
    }

    public String getImprovements() {
        return this.improvements;
    }

    public String getDegradations() {
        return this.degradations;
    }

    public String toString() {
        return "CodeHealthDelta{improvements='" + this.improvements + '\'' + ", degradations='" + this.degradations + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

