/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codescene;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.plugins.codescene.Domain.CodeSceneUser;
import org.jenkinsci.plugins.codescene.Domain.Commits;
import org.jenkinsci.plugins.codescene.Domain.Configuration;
import org.jenkinsci.plugins.codescene.Domain.DeltaAnalysisRequest;
import org.jenkinsci.plugins.codescene.Domain.DeltaAnalysisResult;
import org.jenkinsci.plugins.codescene.Domain.RemoteAnalysisException;

public class DeltaAnalysis {
    private final Configuration config;

    public DeltaAnalysis(Configuration config) {
        this.config = config;
    }

    public DeltaAnalysisResult runOn(Commits commits) throws RemoteAnalysisException, IOException {
        DeltaAnalysisRequest payload = new DeltaAnalysisRequest(commits, this.config);
        try {
            return this.synchronousRequestWith(payload, commits);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The configured CodeScene URL isn't valid", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeltaAnalysisResult synchronousRequestWith(DeltaAnalysisRequest payload, Commits commits) throws RemoteAnalysisException, URISyntaxException, IOException {
        HttpPost codeSceneRequest = this.createRequestFor(payload);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            CloseableHttpResponse rawResponse = httpclient.execute((HttpUriRequest)codeSceneRequest);
            StatusLine status = rawResponse.getStatusLine();
            if (201 == status.getStatusCode()) {
                DeltaAnalysisResult deltaAnalysisResult = this.parseSuccessfulAnalysisResults((HttpResponse)rawResponse, commits);
                return deltaAnalysisResult;
            }
            this.reportFailureAsException((HttpResponse)rawResponse);
        }
        throw new RuntimeException("Internal error: we failed to deal properly with the request.");
    }

    private void reportFailureAsException(HttpResponse rawResponse) throws IOException, RemoteAnalysisException {
        HttpEntity responseBody = rawResponse.getEntity();
        String errorMessage = EntityUtils.toString((HttpEntity)responseBody);
        throw new RemoteAnalysisException(String.format("Failed to execute delta analysis. Status: %s, Reason: %s", rawResponse.getStatusLine(), errorMessage));
    }

    private DeltaAnalysisResult parseSuccessfulAnalysisResults(HttpResponse rawResponse, Commits commits) throws IOException, RemoteAnalysisException {
        HttpEntity responseBody = rawResponse.getEntity();
        if (responseBody == null) {
            throw new RemoteAnalysisException("Internal error: The delta analysis was a success but failed to parse the returned results");
        }
        JsonReader reader = Json.createReader((InputStream)responseBody.getContent());
        JsonObject delta = reader.readObject();
        return new DeltaAnalysisResult(commits, this.config, delta);
    }

    private HttpPost createRequestFor(DeltaAnalysisRequest payload) throws URISyntaxException {
        CodeSceneUser user = this.config.user();
        BasicHeader authorization = new BasicHeader("Authorization", "Basic " + user.asBase64Encoded());
        HttpPost codeSceneRequest = new HttpPost(this.config.codeSceneUrl().toURI());
        codeSceneRequest.addHeader((Header)authorization);
        StringEntity requestEntity = new StringEntity(payload.asJson().toString(), ContentType.APPLICATION_JSON);
        codeSceneRequest.setEntity((HttpEntity)requestEntity);
        return codeSceneRequest;
    }
}

