/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codescene;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.google.common.util.concurrent.ListenableFuture;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.HyperlinkNote;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.codescene.CodeSceneBuildAction;
import org.jenkinsci.plugins.codescene.CodeSceneBuildActionEntry;
import org.jenkinsci.plugins.codescene.DeltaAnalysis;
import org.jenkinsci.plugins.codescene.Domain.Branch;
import org.jenkinsci.plugins.codescene.Domain.CodeSceneUser;
import org.jenkinsci.plugins.codescene.Domain.Commit;
import org.jenkinsci.plugins.codescene.Domain.CommitRange;
import org.jenkinsci.plugins.codescene.Domain.Commits;
import org.jenkinsci.plugins.codescene.Domain.Configuration;
import org.jenkinsci.plugins.codescene.Domain.ConfigurationBuilder;
import org.jenkinsci.plugins.codescene.Domain.DeltaAnalysisResult;
import org.jenkinsci.plugins.codescene.Domain.QualityGates;
import org.jenkinsci.plugins.codescene.Domain.RemoteAnalysisException;
import org.jenkinsci.plugins.codescene.Domain.Repository;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class CodeSceneBuilder
extends Builder
implements SimpleBuildStep {
    private static final Logger logger = Logger.getLogger(CodeSceneBuilder.class.getName());
    private static final int DEFAULT_RISK_THRESHOLD = 7;
    private static final int DEFAULT_COUPLING_THRESHOLD_PERCENT = 80;
    private final String credentialsId;
    private final String deltaAnalysisUrl;
    private final String repository;
    private boolean analyzeLatestIndividually;
    private boolean analyzeBranchDiff;
    private String baseRevision;
    private boolean markBuildAsUnstable;
    private int riskThreshold = 7;
    private int couplingThresholdPercent = 80;
    private boolean letBuildPassOnFailedAnalysis = false;
    private boolean failOnFailedGoal = true;
    private boolean failOnDecliningCodeHealth = true;
    private String originUrl;
    @Deprecated
    private transient String username;
    @Deprecated
    private transient String password;

    @DataBoundConstructor
    public CodeSceneBuilder(String credentialsId, String deltaAnalysisUrl, String repository) {
        this.credentialsId = credentialsId;
        this.deltaAnalysisUrl = deltaAnalysisUrl;
        this.repository = repository;
    }

    public boolean isAnalyzeLatestIndividually() {
        return this.analyzeLatestIndividually;
    }

    public boolean isAnalyzeBranchDiff() {
        return this.analyzeBranchDiff;
    }

    public String getBaseRevision() {
        return this.baseRevision;
    }

    public boolean isMarkBuildAsUnstable() {
        return this.markBuildAsUnstable;
    }

    public int getRiskThreshold() {
        return this.riskThreshold;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getDeltaAnalysisUrl() {
        return this.deltaAnalysisUrl;
    }

    public String getRepository() {
        return this.repository;
    }

    public int getCouplingThresholdPercent() {
        return this.couplingThresholdPercent;
    }

    public boolean isLetBuildPassOnFailedAnalysis() {
        return this.letBuildPassOnFailedAnalysis;
    }

    public boolean isFailOnFailedGoal() {
        return this.failOnFailedGoal;
    }

    public boolean isFailOnDecliningCodeHealth() {
        return this.failOnDecliningCodeHealth;
    }

    public String getOriginUrl() {
        return this.originUrl;
    }

    @DataBoundSetter
    public void setAnalyzeLatestIndividually(boolean analyzeLatestIndividually) {
        this.analyzeLatestIndividually = analyzeLatestIndividually;
    }

    @DataBoundSetter
    public void setAnalyzeBranchDiff(boolean analyzeBranchDiff) {
        this.analyzeBranchDiff = analyzeBranchDiff;
    }

    @DataBoundSetter
    public void setBaseRevision(String baseRevision) {
        this.baseRevision = baseRevision;
    }

    @DataBoundSetter
    public void setMarkBuildAsUnstable(boolean markBuildAsUnstable) {
        this.markBuildAsUnstable = markBuildAsUnstable;
    }

    @DataBoundSetter
    public void setRiskThreshold(int riskThreshold) {
        this.riskThreshold = riskThreshold < 1 || riskThreshold > 10 ? 7 : riskThreshold;
    }

    @DataBoundSetter
    public void setCouplingThresholdPercent(int couplingThresholdPercent) {
        this.couplingThresholdPercent = couplingThresholdPercent < 1 || couplingThresholdPercent > 100 ? 80 : couplingThresholdPercent;
    }

    @DataBoundSetter
    public void setLetBuildPassOnFailedAnalysis(boolean letBuildPassOnFailedAnalysis) {
        this.letBuildPassOnFailedAnalysis = letBuildPassOnFailedAnalysis;
    }

    @DataBoundSetter
    public void setFailOnFailedGoal(boolean failOnFailedGoal) {
        this.failOnFailedGoal = failOnFailedGoal;
    }

    @DataBoundSetter
    public void setFailOnDecliningCodeHealth(boolean failOnDecliningCodeHealth) {
        this.failOnDecliningCodeHealth = failOnDecliningCodeHealth;
    }

    @DataBoundSetter
    public void setOriginUrl(String originUrl) {
        this.originUrl = originUrl;
    }

    protected Object readResolve() {
        if (this.couplingThresholdPercent == 0) {
            this.couplingThresholdPercent = 80;
        }
        return this;
    }

    private Commits revisionsAsCommitSet(List<String> revisions) {
        ArrayList<Commit> commits = new ArrayList<Commit>();
        for (String revision : revisions) {
            commits.add(new Commit(revision));
        }
        return new Commits(commits);
    }

    private ArrayList<Commits> revisionsAsIndividualCommitSets(List<String> revisions) {
        ArrayList<Commits> commitSets = new ArrayList<Commits>();
        for (String revision : revisions) {
            commitSets.add(Commits.from(new Commit(revision)));
        }
        return commitSets;
    }

    private ArrayList<CodeSceneBuildActionEntry> runDeltaAnalysesOnIndividualCommits(Configuration config, List<String> revisions, TaskListener listener) throws RemoteAnalysisException, IOException {
        ArrayList<Commits> commitSets = this.revisionsAsIndividualCommitSets(revisions);
        ArrayList<CodeSceneBuildActionEntry> entries = new ArrayList<CodeSceneBuildActionEntry>(commitSets.size());
        if (!commitSets.isEmpty()) {
            listener.getLogger().format("Starting delta analysis on %d commit(s)...%n", commitSets.size());
            for (Commits commits : commitSets) {
                DeltaAnalysis deltaAnalysis = new DeltaAnalysis(config);
                listener.getLogger().format("Running delta analysis on commits (%s) in repository %s.%n", commits.value(), config.gitRepositoryToAnalyze().value());
                DeltaAnalysisResult result = deltaAnalysis.runOn(commits);
                URL detailsUrl = new URL(config.codeSceneUrl().getProtocol(), config.codeSceneUrl().getHost(), config.codeSceneUrl().getPort(), result.getViewUrl());
                entries.add(new CodeSceneBuildActionEntry(commits.value().get(0).value(), false, commits.value(), result.getRisk(), result.getWarnings().value(), detailsUrl, this.riskThreshold, result.getRiskDescription(), result.qualityGatesState(), result.improvements(), result.describeCodeHealthDelta(), result.getNewFilesFeedback()));
            }
        } else {
            listener.getLogger().format("No commits to run delta analysis on.%n", new Object[0]);
        }
        return entries;
    }

    private CodeSceneBuildActionEntry runDeltaAnalysisOnBranchDiff(Configuration config, List<String> revisions, String branchName, TaskListener listener) throws RemoteAnalysisException, IOException {
        Commits commitSet = this.revisionsAsCommitSet(revisions);
        DeltaAnalysis deltaAnalysis = new DeltaAnalysis(config);
        listener.getLogger().format("Running delta analysis on branch %s in repository %s.%n", branchName, config.gitRepositoryToAnalyze().value());
        DeltaAnalysisResult result = deltaAnalysis.runOn(commitSet);
        URL detailsUrl = new URL(config.codeSceneUrl().getProtocol(), config.codeSceneUrl().getHost(), config.codeSceneUrl().getPort(), result.getViewUrl());
        return new CodeSceneBuildActionEntry(branchName, true, commitSet.value(), result.getRisk(), result.getWarnings().value(), detailsUrl, this.riskThreshold, result.getRiskDescription(), result.qualityGatesState(), result.improvements(), result.describeCodeHealthDelta(), result.getNewFilesFeedback());
    }

    private CommitRange getRangeFromPreviousSuccessfulCommit(EnvVars env, Commit currentCommit) {
        String previousCommitFromEnv = (String)env.get((Object)"GIT_PREVIOUS_SUCCESSFUL_COMMIT");
        if (previousCommitFromEnv != null) {
            return new CommitRange(new Commit(previousCommitFromEnv), currentCommit);
        }
        return new CommitRange(new Branch(this.getBaseRevision()), currentCommit);
    }

    private EnvVars getWorkFlowEnvVars(FlowExecution execution) throws ExecutionException, InterruptedException, IOException {
        EnvVars envVars = new EnvVars();
        if (execution != null) {
            ListenableFuture executions = execution.getCurrentExecutions(true);
            List stepExecutions = (List)executions.get();
            for (StepExecution stepExecution : stepExecutions) {
                EnvVars stepEnvVars = (EnvVars)stepExecution.getContext().get(EnvVars.class);
                if (stepEnvVars == null) continue;
                envVars.putAll((Map)stepEnvVars);
            }
        }
        return envVars;
    }

    private boolean isPipelineRun(Run<?, ?> build) {
        return build instanceof WorkflowRun;
    }

    private void onErrorBuildResult(Run<?, ?> build, TaskListener listener, Result result, String message) {
        listener.error(message);
        build.setResult(result);
        if (this.isPipelineRun(build) && Result.FAILURE.equals(result)) {
            throw new RuntimeException(message);
        }
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) {
        if (this.isDeltaAnalysisConfigured()) {
            return;
        }
        try {
            URL url = new URL(this.deltaAnalysisUrl);
            EnvVars env = build.getEnvironment(listener);
            if (this.isPipelineRun(build)) {
                env.putAll((Map)this.getWorkFlowEnvVars(((WorkflowRun)build).getExecution()));
            }
            Commit currentCommit = new Commit((String)env.get((Object)"GIT_COMMIT"));
            Configuration codesceneConfig = new ConfigurationBuilder().codeSceneUrl(url).user(this.userConfig()).gitRepositoryToAnalyze(new Repository(this.repository)).couplingThresholdPercent(this.couplingThresholdPercent).letBuildPassOnFailedAnalysis(this.letBuildPassOnFailedAnalysis).failOnFailedGoal(this.failOnFailedGoal).failOnDecliningCodeHealth(this.failOnDecliningCodeHealth).originUrl(StringUtils.isNotBlank((String)this.originUrl) ? this.originUrl : (String)env.get((Object)"GIT_URL")).changeRef((String)env.get((Object)"GERRIT_REFSPEC")).baseRevision(this.getBaseRevision()).currentCommit(currentCommit).build();
            if (this.isAnalyzeLatestIndividually()) {
                this.analyzeLatestIndividualCommitFor(build, workspace, launcher, listener, codesceneConfig, this.getRangeFromPreviousSuccessfulCommit(env, currentCommit));
            }
            String branch = (String)env.get((Object)"GIT_BRANCH");
            if (this.isAnalyzeBranchDiff() && this.getBaseRevision() != null) {
                this.analyzeWorkOnBranchFor(build, workspace, launcher, listener, codesceneConfig, currentCommit, branch);
            }
        }
        catch (RemoteAnalysisException e) {
            String message = String.format("Remote failure as CodeScene couldn't perform the delta analysis: %s", e);
            logger.log(Level.WARNING, message);
            this.onErrorBuildResult(build, listener, CodeSceneBuilder.buildResultForFailedAnalysisDependsOn(this.letBuildPassOnFailedAnalysis), message);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            this.onErrorBuildResult(build, listener, Result.FAILURE, String.format("Failed to run delta analysis: %s", e));
        }
    }

    private void analyzeWorkOnBranchFor(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, Configuration codesceneConfig, Commit currentCommit, String branch) throws IOException, InterruptedException, RemoteAnalysisException {
        Branch branchBase = new Branch(this.getBaseRevision());
        CommitRange rangeToAnalyse = new CommitRange(branchBase, currentCommit);
        List<String> revisions = this.getCommitRange(build, workspace, launcher, listener, rangeToAnalyse);
        if (revisions.isEmpty()) {
            listener.getLogger().println(String.format("No new commits to analyze between the branch '%s' and base revision '%s'.", branch, this.baseRevision));
        } else {
            CodeSceneBuildActionEntry entry = this.runDeltaAnalysisOnBranchDiff(codesceneConfig, revisions, branch, listener);
            CodeSceneBuilder.markAsUnstableWhenFailedGoal(entry, build, listener);
            CodeSceneBuilder.markAsUnstableWhenCodeHealthDeclines(entry, build, listener);
            this.markAsUnstableWhenAtRiskThreshold(this.riskThreshold, entry, build, listener);
            build.addAction((Action)new CodeSceneBuildAction("Delta - By Branch", Collections.singletonList(entry)));
        }
    }

    private void analyzeLatestIndividualCommitFor(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, Configuration codesceneConfig, CommitRange rangeToAnalyse) throws IOException, InterruptedException, RemoteAnalysisException {
        List<String> revisions = this.getCommitRange(build, workspace, launcher, listener, rangeToAnalyse);
        if (revisions.isEmpty()) {
            listener.getLogger().println("No new commits to analyze individually for this build.");
        } else {
            ArrayList<CodeSceneBuildActionEntry> entries = this.runDeltaAnalysesOnIndividualCommits(codesceneConfig, revisions, listener);
            for (CodeSceneBuildActionEntry entry : entries) {
                CodeSceneBuilder.markAsUnstableWhenFailedGoal(entry, build, listener);
                CodeSceneBuilder.markAsUnstableWhenCodeHealthDeclines(entry, build, listener);
                this.markAsUnstableWhenAtRiskThreshold(this.riskThreshold, entry, build, listener);
            }
            build.addAction((Action)new CodeSceneBuildAction("Delta - Individual Commits", entries));
        }
    }

    private boolean isDeltaAnalysisConfigured() {
        return !this.isAnalyzeLatestIndividually() && !this.isAnalyzeBranchDiff();
    }

    private static Result buildResultForFailedAnalysisDependsOn(boolean passOnFailedAnalysis) {
        if (passOnFailedAnalysis) {
            return Result.SUCCESS;
        }
        return Result.FAILURE;
    }

    private CodeSceneUser userConfig() {
        if (this.credentialsId == null) {
            return new CodeSceneUser(this.username, this.password);
        }
        UsernamePasswordCredentials credentials = this.lookupCredentials(this.credentialsId);
        if (credentials == null) {
            throw new IllegalStateException("No CodeScene credentials found for id=" + this.credentialsId);
        }
        return new CodeSceneUser(credentials.getUsername(), credentials.getPassword().getPlainText());
    }

    private UsernamePasswordCredentials lookupCredentials(String credentialId) {
        List credentials = CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList());
        CredentialsMatcher matcher = CredentialsMatchers.withId((String)credentialId);
        return (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)credentials, (CredentialsMatcher)matcher);
    }

    private static void marktBuildAsUnstable(Run<?, ?> build) {
        Result newResult = Result.UNSTABLE;
        Result result = build.getResult();
        if (result != null) {
            build.setResult(result.combine(newResult));
        } else {
            build.setResult(newResult);
        }
    }

    private static void markAsUnstableWhenFailedGoal(CodeSceneBuildActionEntry entry, Run<?, ?> build, TaskListener listener) {
        QualityGates gates = entry.gates();
        if (gates.goalHasFailed()) {
            String link = HyperlinkNote.encodeTo((String)entry.getViewUrl().toExternalForm(), (String)"Failed Quality Gate");
            listener.error("%s : the analysis detects a failed goal. Marking build as unstable.", new Object[]{link});
            CodeSceneBuilder.marktBuildAsUnstable(build);
        }
    }

    private static void markAsUnstableWhenCodeHealthDeclines(CodeSceneBuildActionEntry entry, Run<?, ?> build, TaskListener listener) {
        QualityGates gates = entry.gates();
        if (gates.codeHealthDeclined()) {
            String link = HyperlinkNote.encodeTo((String)entry.getViewUrl().toExternalForm(), (String)"Failed Quality Gate");
            listener.error("%s : the analysis detects a decline in Code Health. Marking build as unstable.", new Object[]{link});
            CodeSceneBuilder.marktBuildAsUnstable(build);
        }
    }

    private void markAsUnstableWhenAtRiskThreshold(int threshold, CodeSceneBuildActionEntry entry, Run<?, ?> build, TaskListener listener) {
        if (this.isMarkBuildAsUnstable() && entry.getHitsRiskThreshold()) {
            String link = HyperlinkNote.encodeTo((String)entry.getViewUrl().toExternalForm(), (String)String.format("Delta analysis result with risk %d", entry.getRisk().getValue()));
            listener.error("%s hits the risk threshold (%d). Marking build as unstable.", new Object[]{link, threshold});
            CodeSceneBuilder.marktBuildAsUnstable(build);
        }
    }

    private List<String> getCommitRange(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, CommitRange revisionSpan) throws IOException, InterruptedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        launcher.launch().cmdAsSingleString(String.format("git log --pretty='%%H' %s..%s", revisionSpan.from(), revisionSpan.to())).pwd(workspace).envs((Map)build.getEnvironment(listener)).stdout((OutputStream)out).join();
        ArrayList<String> revisions = new ArrayList<String>();
        for (String line : out.toString("UTF8").split("\n")) {
            String trimmed = line.trim();
            if (trimmed.isEmpty()) continue;
            revisions.add(trimmed);
        }
        return revisions;
    }

    @Symbol(value={"codescene"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Run CodeScene Delta Analysis";
        }

        public boolean isApplicable(Class type) {
            return true;
        }

        public boolean configure(StaplerRequest staplerRequest, JSONObject json) {
            this.save();
            return true;
        }

        public FormValidation doCheckBaseRevision(@QueryParameter boolean analyzeBranchDiff, @QueryParameter String baseRevision) {
            if (analyzeBranchDiff && (baseRevision == null || baseRevision.isEmpty())) {
                return FormValidation.error((String)"Base revision cannot be empty.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRiskThreshold(@QueryParameter int riskThreshold, @QueryParameter boolean markBuildAsUnstable) {
            if (markBuildAsUnstable && (riskThreshold < 1 || riskThreshold > 10)) {
                return FormValidation.error((String)"Risk threshold must be a number between 1 and 10. The value %d is invalid.", (Object[])new Object[]{riskThreshold});
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCredentialsId(@QueryParameter String credentialsId) {
            if (credentialsId == null || credentialsId.isEmpty()) {
                return FormValidation.error((String)"CodeScene API credentials must be set.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDeltaAnalysisUrl(@QueryParameter String deltaAnalysisUrl) {
            if (deltaAnalysisUrl == null || deltaAnalysisUrl.isEmpty()) {
                return FormValidation.error((String)"CodeScene delta analysis URL cannot be blank.");
            }
            try {
                new URL(deltaAnalysisUrl);
                return FormValidation.ok();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"Invalid URL");
            }
        }

        public FormValidation doCheckRepository(@QueryParameter String repository) {
            if (repository == null || repository.isEmpty()) {
                return FormValidation.error((String)"CodeScene repository cannot be blank.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCouplingThresholdPercent(@QueryParameter int couplingThresholdPercent) {
            if (couplingThresholdPercent < 1 || couplingThresholdPercent > 100) {
                return FormValidation.error((String)"Temporal coupling threshold is percentage and must be a number between 1 and 100.The value %d is invalid.", (Object[])new Object[]{couplingThresholdPercent});
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Jenkins context, @QueryParameter String credentialsId) {
            if (context == null || !context.hasPermission(Item.CONFIGURE)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(context instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM, (ItemGroup)context, StandardUsernameCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
        }
    }
}

