/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codescene;

import java.net.URL;
import java.util.List;
import org.jenkinsci.plugins.codescene.Domain.CodeHealthDelta;
import org.jenkinsci.plugins.codescene.Domain.CodeHealthDeltaDescription;
import org.jenkinsci.plugins.codescene.Domain.Commit;
import org.jenkinsci.plugins.codescene.Domain.Improvements;
import org.jenkinsci.plugins.codescene.Domain.NewFiles;
import org.jenkinsci.plugins.codescene.Domain.QualityGates;
import org.jenkinsci.plugins.codescene.Domain.ReviewOfNewFile;
import org.jenkinsci.plugins.codescene.Domain.RiskClassification;
import org.jenkinsci.plugins.codescene.Domain.RiskDescription;
import org.jenkinsci.plugins.codescene.Domain.Warning;

public class CodeSceneBuildActionEntry {
    private final String title;
    private final boolean showCommits;
    private final List<Commit> commits;
    private final RiskClassification risk;
    private final List<Warning> warnings;
    private final URL viewUrl;
    private final int riskThreshold;
    private final RiskDescription description;
    private final QualityGates qualityGatesState;
    private final Improvements improvements;
    private final CodeHealthDeltaDescription codeHealthDeltaDescription;
    private final NewFiles newFiles;

    public CodeSceneBuildActionEntry(String title, boolean showCommits, List<Commit> commits, RiskClassification risk, List<Warning> warnings, URL viewUrl, int riskThreshold, RiskDescription description, QualityGates qualityGatesState, Improvements improvements, CodeHealthDeltaDescription codeHealthDeltaDescription, NewFiles newFiles) {
        this.title = title;
        this.showCommits = showCommits;
        this.commits = commits;
        this.risk = risk;
        this.improvements = improvements;
        this.warnings = warnings;
        this.viewUrl = viewUrl;
        this.riskThreshold = riskThreshold;
        this.description = description;
        this.qualityGatesState = qualityGatesState;
        this.codeHealthDeltaDescription = codeHealthDeltaDescription;
        this.newFiles = newFiles;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean getShowCommits() {
        return this.showCommits;
    }

    public List<Commit> getCommits() {
        return this.commits;
    }

    public RiskClassification getRisk() {
        return this.risk;
    }

    public RiskDescription getDescription() {
        return this.description;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public boolean getHasWarnings() {
        return this.warnings != null && !this.warnings.isEmpty();
    }

    public URL getViewUrl() {
        return this.viewUrl;
    }

    public int getRiskThreshold() {
        return this.riskThreshold;
    }

    public boolean getHitsRiskThreshold() {
        return this.risk != null && this.risk.getValue() >= this.riskThreshold;
    }

    public QualityGates gates() {
        return this.qualityGatesState;
    }

    public boolean getGoalHasFailed() {
        return this.qualityGatesState != null && this.qualityGatesState.goalHasFailed();
    }

    public boolean getHasImprovements() {
        return this.improvements != null && !this.improvements.value().isEmpty();
    }

    public List<String> getImprovements() {
        return this.improvements.value();
    }

    public boolean getCodeHealthDeclined() {
        return this.qualityGatesState != null && this.qualityGatesState.codeHealthDeclined();
    }

    public boolean getQualityGatesEnabled() {
        return this.qualityGatesState != null && this.qualityGatesState.enabled();
    }

    public String getCodeOwners() {
        if (this.qualityGatesState != null) {
            return this.qualityGatesState.codeOwners();
        }
        return "-";
    }

    public boolean getHasCodeOwners() {
        return this.qualityGatesState != null && this.qualityGatesState.hasCodeOwners();
    }

    public boolean getHasCodeHealthDeltaDescriptions() {
        return !this.codeHealthDeltaDescription.deltaDescriptions().isEmpty();
    }

    public List<CodeHealthDelta> getCodeHealthDeltaDescriptions() {
        return this.codeHealthDeltaDescription.deltaDescriptions();
    }

    public boolean getHasNewFilesInfo() {
        return this.newFiles.hasNewFileInfo();
    }

    public String getNewFilesSummary() {
        return this.newFiles.getSummary();
    }

    public List<ReviewOfNewFile> getReviewOfNewFiles() {
        return this.newFiles.getReviews();
    }
}

