// CHECKSTYLE:OFF

package hudson.plugins.clover;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * OpenClover summary report
     * 
     */
    public static String CloverBuildAction_DisplayName() {
        return holder.format("CloverBuildAction.DisplayName");
    }

    /**
     * OpenClover summary report
     * 
     */
    public static Localizable _CloverBuildAction_DisplayName() {
        return new Localizable(holder, "CloverBuildAction.DisplayName");
    }

    /**
     * OpenClover PDF coverage report
     * 
     */
    public static String CloverProjectAction_PDF_DisplayName() {
        return holder.format("CloverProjectAction.PDF.DisplayName");
    }

    /**
     * OpenClover PDF coverage report
     * 
     */
    public static Localizable _CloverProjectAction_PDF_DisplayName() {
        return new Localizable(holder, "CloverProjectAction.PDF.DisplayName");
    }

    /**
     * OpenClover HTML coverage report
     * 
     */
    public static String CloverProjectAction_HTML_DisplayName() {
        return holder.format("CloverProjectAction.HTML.DisplayName");
    }

    /**
     * OpenClover HTML coverage report
     * 
     */
    public static Localizable _CloverProjectAction_HTML_DisplayName() {
        return new Localizable(holder, "CloverProjectAction.HTML.DisplayName");
    }

    /**
     * Coverage report
     * 
     */
    public static String CloverProjectAction_XML_DisplayName() {
        return holder.format("CloverProjectAction.XML.DisplayName");
    }

    /**
     * Coverage report
     * 
     */
    public static Localizable _CloverProjectAction_XML_DisplayName() {
        return new Localizable(holder, "CloverProjectAction.XML.DisplayName");
    }

    /**
     * Publish OpenClover coverage report
     * 
     */
    public static String CloverPublisher_DisplayName() {
        return holder.format("CloverPublisher.DisplayName");
    }

    /**
     * Publish OpenClover coverage report
     * 
     */
    public static Localizable _CloverPublisher_DisplayName() {
        return new Localizable(holder, "CloverPublisher.DisplayName");
    }

    /**
     * OpenClover Coverage: Conditionals {0}% ({1})
     * 
     */
    public static String CloverBuildAction_ConditionalCoverage(Object arg1, Object arg2) {
        return holder.format("CloverBuildAction.ConditionalCoverage", arg1, arg2);
    }

    /**
     * OpenClover Coverage: Conditionals {0}% ({1})
     * 
     */
    public static Localizable _CloverBuildAction_ConditionalCoverage(Object arg1, Object arg2) {
        return new Localizable(holder, "CloverBuildAction.ConditionalCoverage", arg1, arg2);
    }

    /**
     * OpenClover Coverage: Elements {0}% ({1})
     * 
     */
    public static String CloverBuildAction_ElementCoverage(Object arg1, Object arg2) {
        return holder.format("CloverBuildAction.ElementCoverage", arg1, arg2);
    }

    /**
     * OpenClover Coverage: Elements {0}% ({1})
     * 
     */
    public static Localizable _CloverBuildAction_ElementCoverage(Object arg1, Object arg2) {
        return new Localizable(holder, "CloverBuildAction.ElementCoverage", arg1, arg2);
    }

    /**
     * OpenClover Coverage: Methods {0}% ({1})
     * 
     */
    public static String CloverBuildAction_MethodCoverage(Object arg1, Object arg2) {
        return holder.format("CloverBuildAction.MethodCoverage", arg1, arg2);
    }

    /**
     * OpenClover Coverage: Methods {0}% ({1})
     * 
     */
    public static Localizable _CloverBuildAction_MethodCoverage(Object arg1, Object arg2) {
        return new Localizable(holder, "CloverBuildAction.MethodCoverage", arg1, arg2);
    }

    /**
     * Automatically record and report code coverage using OpenClover. Currently for Ant builds only.
     * 
     */
    public static String CloverBuildWrapper_DisplayName() {
        return holder.format("CloverBuildWrapper.DisplayName");
    }

    /**
     * Automatically record and report code coverage using OpenClover. Currently for Ant builds only.
     * 
     */
    public static Localizable _CloverBuildWrapper_DisplayName() {
        return new Localizable(holder, "CloverBuildWrapper.DisplayName");
    }

    /**
     * OpenClover Coverage: Statements {0}% ({1})
     * 
     */
    public static String CloverBuildAction_StatementCoverage(Object arg1, Object arg2) {
        return holder.format("CloverBuildAction.StatementCoverage", arg1, arg2);
    }

    /**
     * OpenClover Coverage: Statements {0}% ({1})
     * 
     */
    public static Localizable _CloverBuildAction_StatementCoverage(Object arg1, Object arg2) {
        return new Localizable(holder, "CloverBuildAction.StatementCoverage", arg1, arg2);
    }

    /**
     * OpenClover HTML Report
     * 
     */
    public static String CloverHtmlBuildAction_DisplayName() {
        return holder.format("CloverHtmlBuildAction.DisplayName");
    }

    /**
     * OpenClover HTML Report
     * 
     */
    public static Localizable _CloverHtmlBuildAction_DisplayName() {
        return new Localizable(holder, "CloverHtmlBuildAction.DisplayName");
    }

}
