/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.config.AbstractFolderConfiguration;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetricDescriptor;
import hudson.util.DescribableList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class FolderSystemPropertyTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();
    private static String HEALTH_METRIC_PROPERTY;

    @BeforeClass
    public static void enableHealthMetrics() {
        HEALTH_METRIC_PROPERTY = System.getProperty(AbstractFolderConfiguration.class.getName() + ".ADD_HEALTH_METRICS");
        System.setProperty(AbstractFolderConfiguration.class.getName() + ".ADD_HEALTH_METRICS", "true");
    }

    @AfterClass
    public static void disableHealthMetrics() {
        if (HEALTH_METRIC_PROPERTY != null) {
            System.setProperty(AbstractFolderConfiguration.class.getName() + ".ADD_HEALTH_METRICS", HEALTH_METRIC_PROPERTY);
        } else {
            System.clearProperty(AbstractFolderConfiguration.class.getName() + ".ADD_HEALTH_METRICS");
        }
    }

    @Test
    public void shouldHaveHealthMetricConfiguredGloballyOnSystemProperty() throws Exception {
        MatcherAssert.assertThat((String)"if used .ADD_HEALTH_METRICS system property, global configuration should have all folder health metrics", (Object)AbstractFolderConfiguration.get().getHealthMetrics(), (Matcher)Matchers.hasSize((int)((int)FolderHealthMetricDescriptor.all().stream().filter(d -> d.createDefault() != null).count())));
        Folder folder = (Folder)this.j.jenkins.createProject(Folder.class, "myFolder");
        DescribableList healthMetrics = folder.getHealthMetrics();
        MatcherAssert.assertThat((String)"a new created folder should have all the folder health metrics configured globally", (Object)healthMetrics.toList(), (Matcher)Matchers.containsInAnyOrder((Object[])AbstractFolderConfiguration.get().getHealthMetrics().toArray()));
        AbstractFolderConfiguration.get().setHealthMetrics(null);
        folder = (Folder)this.j.jenkins.createProject(Folder.class, "myFolder2");
        healthMetrics = folder.getHealthMetrics();
        MatcherAssert.assertThat((String)"a new created folder should have all the folder health metrics configured globally", (Object)healthMetrics, (Matcher)Matchers.iterableWithSize((int)0));
    }
}

