/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.unittesting;

import hudson.plugins.cigame.GameDescriptor;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.unittesting.AbstractPassedTestsRule;
import hudson.plugins.cigame.rules.unittesting.Messages;
import jenkins.model.Jenkins;

public class IncreasingPassedTestsRule
extends AbstractPassedTestsRule {
    private static final int DEFAULT_POINTS = 1;

    private int getPoints() {
        GameDescriptor gameDescriptor = (GameDescriptor)Jenkins.getInstance().getDescriptorByType(GameDescriptor.class);
        return gameDescriptor != null ? gameDescriptor.getPassedTestIncreasingPoints() : 1;
    }

    @Override
    public String getName() {
        return Messages.UnitTestingRuleSet_IncreasingPassedRule_Name();
    }

    @Override
    protected String getResultDescription(Integer testDiff) {
        return Messages.UnitTestingRuleSet_IncreasingPassedRule_Count(testDiff);
    }

    @Override
    protected RuleResult<Integer> evaluate(int passedTestDiff) {
        if (passedTestDiff > 0) {
            return new RuleResult<Integer>(passedTestDiff * this.getPoints(), Messages.UnitTestingRuleSet_IncreasingPassedRule_Count(passedTestDiff), passedTestDiff);
        }
        return null;
    }
}

