/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.unittesting;

import hudson.plugins.cigame.GameDescriptor;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.unittesting.AbstractFailedTestsRule;
import hudson.plugins.cigame.rules.unittesting.Messages;
import jenkins.model.Jenkins;

public class IncreasingFailedTestsRule
extends AbstractFailedTestsRule {
    private static final int DEFAULT_POINTS = -1;

    private int getPoints() {
        GameDescriptor gameDescriptor = (GameDescriptor)Jenkins.getInstance().getDescriptorByType(GameDescriptor.class);
        return gameDescriptor != null ? gameDescriptor.getFailedTestIncreasingPoints() : -1;
    }

    @Override
    public String getName() {
        return Messages.UnitTestingRuleSet_IncreasingFailedRule_Name();
    }

    @Override
    protected String getResultDescription(Integer testDiff) {
        return Messages.UnitTestingRuleSet_IncreasingFailedRule_Count(testDiff);
    }

    @Override
    protected RuleResult<Integer> evaluate(int failingTestDiff) {
        if (failingTestDiff > 0) {
            return new RuleResult<Integer>(failingTestDiff * this.getPoints(), Messages.UnitTestingRuleSet_IncreasingFailedRule_Count(failingTestDiff), failingTestDiff);
        }
        return null;
    }
}

