/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.unittesting;

import hudson.plugins.cigame.GameDescriptor;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.unittesting.AbstractSkippedTestsRule;
import hudson.plugins.cigame.rules.unittesting.Messages;
import jenkins.model.Jenkins;

public class DecreasingSkippedTestsRule
extends AbstractSkippedTestsRule {
    private static final int DEFAULT_POINTS = 0;

    private int getPoints() {
        GameDescriptor gameDescriptor = (GameDescriptor)Jenkins.getInstance().getDescriptorByType(GameDescriptor.class);
        return gameDescriptor != null ? gameDescriptor.getSkippedTestDecreasingPoints() : 0;
    }

    @Override
    public String getName() {
        return Messages.UnitTestingRuleSet_DecreasingSkippedRule_Name();
    }

    @Override
    protected String getResultDescription(Integer testDiff) {
        return Messages.UnitTestingRuleSet_DecreasingSkippedRule_Count(testDiff);
    }

    @Override
    protected RuleResult<Integer> evaluate(int skippedTestDiff) {
        if (skippedTestDiff < 0) {
            skippedTestDiff = -skippedTestDiff;
            return new RuleResult<Integer>(skippedTestDiff * this.getPoints(), Messages.UnitTestingRuleSet_DecreasingSkippedRule_Count(skippedTestDiff), skippedTestDiff);
        }
        return null;
    }
}

