/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.unittesting;

import hudson.plugins.cigame.GameDescriptor;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.unittesting.AbstractFailedTestsRule;
import hudson.plugins.cigame.rules.unittesting.Messages;
import jenkins.model.Jenkins;

public class DecreasingFailedTestsRule
extends AbstractFailedTestsRule {
    private static final int DEFAULT_POINTS = 0;

    private int getPoints() {
        GameDescriptor gameDescriptor = (GameDescriptor)Jenkins.getInstance().getDescriptorByType(GameDescriptor.class);
        return gameDescriptor != null ? gameDescriptor.getFailedTestDecreasingPoints() : 0;
    }

    @Override
    public String getName() {
        return Messages.UnitTestingRuleSet_DecreasingFailedRule_Name();
    }

    @Override
    protected String getResultDescription(Integer testDiff) {
        return Messages.UnitTestingRuleSet_DecreasingFailedRule_Count(testDiff);
    }

    @Override
    protected RuleResult<Integer> evaluate(int failedTestDiff) {
        if (failedTestDiff < 0) {
            failedTestDiff = -failedTestDiff;
            return new RuleResult<Integer>(failedTestDiff * this.getPoints(), Messages.UnitTestingRuleSet_DecreasingFailedRule_Count(failedTestDiff), failedTestDiff);
        }
        return null;
    }
}

