/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.unittesting;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.AggregatableRule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.tasks.test.AbstractTestResultAction;
import java.util.Collection;

public abstract class AbstractUnitTestsRule
implements AggregatableRule<Integer> {
    static final AbstractTestResultAction ZERO_RESULT = new AbstractTestResultAction(null){

        public int getFailCount() {
            return 0;
        }

        public Object getResult() {
            return null;
        }

        public int getTotalCount() {
            return 0;
        }

        public int getSkipCount() {
            return 0;
        }
    };

    private AbstractBuild<?, ?> getPreviousBuildWithResults(AbstractBuild<?, ?> previousBuild) {
        while (previousBuild != null) {
            if (previousBuild.getResult() != null) {
                if (previousBuild.getResult().isBetterThan(Result.FAILURE)) {
                    AbstractTestResultAction action = (AbstractTestResultAction)previousBuild.getAction(AbstractTestResultAction.class);
                    if (action != null) {
                        return previousBuild;
                    }
                } else if (!previousBuild.getResult().isWorseOrEqualTo(Result.NOT_BUILT)) {
                    return previousBuild;
                }
            }
            previousBuild = previousBuild.getPreviousBuild();
        }
        return null;
    }

    @Override
    public final RuleResult<Integer> evaluate(AbstractBuild<?, ?> previousBuild, AbstractBuild<?, ?> build) {
        Result prevResult;
        AbstractTestResultAction prevAction;
        Result result;
        AbstractTestResultAction action;
        if ((previousBuild = this.getPreviousBuildWithResults(previousBuild)) == null && build == null) {
            return null;
        }
        if (build == null) {
            action = null;
            result = Result.SUCCESS;
        } else {
            action = (AbstractTestResultAction)build.getAction(AbstractTestResultAction.class);
            result = build.getResult();
        }
        if (previousBuild == null) {
            prevAction = ZERO_RESULT;
            prevResult = Result.SUCCESS;
        } else {
            prevAction = (AbstractTestResultAction)previousBuild.getAction(AbstractTestResultAction.class);
            prevResult = previousBuild.getResult();
        }
        prevAction = prevAction != null ? prevAction : ZERO_RESULT;
        prevResult = prevResult != null ? prevResult : Result.ABORTED;
        result = result != null ? result : Result.ABORTED;
        AbstractTestResultAction abstractTestResultAction = action = action != null ? action : ZERO_RESULT;
        if (prevResult.isBetterThan(Result.FAILURE) && result.isBetterThan(Result.FAILURE)) {
            return this.evaluate(action, prevAction);
        }
        return null;
    }

    @Override
    public final RuleResult<?> aggregate(Collection<RuleResult<Integer>> results) {
        double score = 0.0;
        int testDiff = 0;
        for (RuleResult<Integer> result : results) {
            if (result == null) continue;
            score += result.getPoints();
            testDiff += result.getAdditionalData().intValue();
        }
        if (score != 0.0) {
            return new RuleResult(score, this.getResultDescription(testDiff));
        }
        return null;
    }

    @Override
    public final RuleResult<Integer> evaluate(AbstractBuild<?, ?> build) {
        throw new UnsupportedOperationException();
    }

    protected abstract String getResultDescription(Integer var1);

    protected abstract RuleResult<Integer> evaluate(AbstractTestResultAction<?> var1, AbstractTestResultAction<?> var2);
}

