/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.warnings;

import hudson.maven.MavenBuild;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.AggregatableRule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.plugins.warnings.Messages;
import hudson.plugins.cigame.util.ActionRetriever;
import hudson.plugins.warnings.WarningsResult;
import hudson.plugins.warnings.WarningsResultAction;
import java.util.Collection;
import java.util.List;

public class DefaultWarningsRule
implements AggregatableRule<Integer> {
    private int pointsForAddingAWarning;
    private int pointsForRemovingAWarning;

    public DefaultWarningsRule(int pointsForAddingAWarning, int pointsForRemovingAWarning) {
        this.pointsForAddingAWarning = pointsForAddingAWarning;
        this.pointsForRemovingAWarning = pointsForRemovingAWarning;
    }

    @Override
    public RuleResult<?> aggregate(Collection<RuleResult<Integer>> results) {
        double score = 0.0;
        int newWarnings = 0;
        for (RuleResult<Integer> result : results) {
            if (result == null) continue;
            score += result.getPoints();
            newWarnings += result.getAdditionalData().intValue();
        }
        if (newWarnings > 0) {
            return new RuleResult(score, Messages.WarningsRuleSet_DefaultRule_NewWarningsCount(newWarnings));
        }
        if (newWarnings < 0) {
            return new RuleResult(score, Messages.WarningsRuleSet_DefaultRule_FixedWarningsCount(newWarnings * -1));
        }
        return RuleResult.EMPTY_INT_RESULT;
    }

    @Override
    public RuleResult<Integer> evaluate(AbstractBuild<?, ?> previousBuild, AbstractBuild<?, ?> build) {
        if (build != null && build.getResult() != null && build.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return RuleResult.EMPTY_INT_RESULT;
        }
        if (previousBuild == null ? !(build instanceof MavenBuild) : previousBuild.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return RuleResult.EMPTY_INT_RESULT;
        }
        List<WarningsResultAction> currentActions = ActionRetriever.getResult(build, Result.UNSTABLE, WarningsResultAction.class);
        if (!this.hasNoErrors(currentActions)) {
            return RuleResult.EMPTY_INT_RESULT;
        }
        int currentAnnotations = this.getNumberOfAnnotations(currentActions);
        List<WarningsResultAction> previousActions = ActionRetriever.getResult(previousBuild, Result.UNSTABLE, WarningsResultAction.class);
        if (!this.hasNoErrors(previousActions)) {
            return RuleResult.EMPTY_INT_RESULT;
        }
        int previousAnnotations = this.getNumberOfAnnotations(previousActions);
        int numberOfNewWarnings = currentAnnotations - previousAnnotations;
        if (numberOfNewWarnings > 0) {
            return new RuleResult<Integer>(numberOfNewWarnings * this.pointsForAddingAWarning, Messages.WarningsRuleSet_DefaultRule_NewWarningsCount(numberOfNewWarnings), numberOfNewWarnings);
        }
        if (numberOfNewWarnings < 0) {
            return new RuleResult<Integer>(numberOfNewWarnings * -1 * this.pointsForRemovingAWarning, Messages.WarningsRuleSet_DefaultRule_FixedWarningsCount(numberOfNewWarnings * -1), numberOfNewWarnings);
        }
        return RuleResult.EMPTY_INT_RESULT;
    }

    @Override
    public RuleResult<Integer> evaluate(AbstractBuild<?, ?> build) {
        throw new UnsupportedOperationException();
    }

    private boolean hasNoErrors(List<WarningsResultAction> actions) {
        for (WarningsResultAction action : actions) {
            if (!((WarningsResult)action.getResult()).hasError()) continue;
            return false;
        }
        return true;
    }

    private int getNumberOfAnnotations(List<WarningsResultAction> actions) {
        int numberOfAnnotations = 0;
        for (WarningsResultAction action : actions) {
            numberOfAnnotations += ((WarningsResult)action.getResult()).getNumberOfAnnotations();
        }
        return numberOfAnnotations;
    }

    @Override
    public String getName() {
        return Messages.WarningsRuleSet_DefaultRule_Name();
    }
}

