/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.violation;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.plugins.violation.Messages;
import hudson.plugins.cigame.util.ActionSequenceRetriever;
import hudson.plugins.cigame.util.ResultSequenceValidator;
import hudson.plugins.violations.ViolationsBuildAction;
import java.util.List;

public class DefaultViolationRule
implements Rule {
    private int pointsForAddingViolation;
    private int pointsForRemovingViolation;
    private String typeName;
    private String violationName;

    public DefaultViolationRule(String typeName, String violationName, int pointsForAddingViolation, int pointsForRemovingViolation) {
        this.typeName = typeName;
        this.violationName = violationName;
        this.pointsForAddingViolation = pointsForAddingViolation;
        this.pointsForRemovingViolation = pointsForRemovingViolation;
    }

    @Override
    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        List<List<ViolationsBuildAction>> actionList;
        if (new ResultSequenceValidator(Result.UNSTABLE, 2).isValid(build) && (actionList = new ActionSequenceRetriever<ViolationsBuildAction>(ViolationsBuildAction.class, 2).getSequence(build)) != null && this.containsTypeReport(actionList.get(0)) && this.containsTypeReport(actionList.get(1))) {
            int diff = this.getTypeReportCount(actionList.get(0)) - this.getTypeReportCount(actionList.get(1));
            if (diff > 0) {
                return new RuleResult(diff * this.pointsForAddingViolation, Messages.ViolationRuleSet_DefaultRule_NewViolationsCount(diff, this.violationName));
            }
            if (diff < 0) {
                return new RuleResult(diff * -1 * this.pointsForRemovingViolation, Messages.ViolationRuleSet_DefaultRule_FixedViolationsCount(diff * -1, this.violationName));
            }
        }
        return RuleResult.EMPTY_RESULT;
    }

    private boolean containsTypeReport(List<ViolationsBuildAction> actions) {
        for (ViolationsBuildAction action : actions) {
            if (action.getReport().getTypeReports().get(this.typeName) == null || action.getReport().getTypeSummary(this.typeName).getErrorMessage() != null) continue;
            return true;
        }
        return false;
    }

    private int getTypeReportCount(List<ViolationsBuildAction> actions) {
        int numberOfReports = 0;
        for (ViolationsBuildAction action : actions) {
            numberOfReports += action.getReport().typeCount(this.typeName);
        }
        return numberOfReports;
    }

    @Override
    public String getName() {
        return this.violationName;
    }
}

