/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.pmd;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.plugins.pmd.Messages;
import hudson.plugins.cigame.util.ActionSequenceRetriever;
import hudson.plugins.cigame.util.ResultSequenceValidator;
import hudson.plugins.pmd.PmdResult;
import hudson.plugins.pmd.PmdResultAction;
import java.util.List;

public class DefaultPmdRule
implements Rule {
    private int pointsForAddingAnAnnotation;
    private int pointsForRemovingAnAnnotation;
    private Priority tasksPriority;

    public DefaultPmdRule(Priority tasksPriority, int pointsForAddingAnAnnotation, int pointsForRemovingAnAnnotation) {
        this.tasksPriority = tasksPriority;
        this.pointsForAddingAnAnnotation = pointsForAddingAnAnnotation;
        this.pointsForRemovingAnAnnotation = pointsForRemovingAnAnnotation;
    }

    @Override
    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        List<List<PmdResultAction>> sequence;
        if (new ResultSequenceValidator(Result.UNSTABLE, 2).isValid(build) && (sequence = new ActionSequenceRetriever<PmdResultAction>(PmdResultAction.class, 2).getSequence(build)) != null && this.hasNoErrors(sequence.get(0)) && this.hasNoErrors(sequence.get(1))) {
            int delta = this.getNumberOfAnnotations(sequence.get(0)) - this.getNumberOfAnnotations(sequence.get(1));
            if (delta < 0) {
                return new RuleResult(Math.abs(delta) * this.pointsForRemovingAnAnnotation, Messages.PmdRuleSet_DefaultRule_FixedWarningsCount(Math.abs(delta), this.tasksPriority.name()));
            }
            if (delta > 0) {
                return new RuleResult(Math.abs(delta) * this.pointsForAddingAnAnnotation, Messages.PmdRuleSet_DefaultRule_NewWarningsCount(Math.abs(delta), this.tasksPriority.name()));
            }
        }
        return RuleResult.EMPTY_RESULT;
    }

    private boolean hasNoErrors(List<PmdResultAction> actions) {
        for (PmdResultAction action : actions) {
            if (!((PmdResult)action.getResult()).hasError()) continue;
            return false;
        }
        return true;
    }

    private int getNumberOfAnnotations(List<PmdResultAction> actions) {
        int numberOfAnnotations = 0;
        for (PmdResultAction action : actions) {
            numberOfAnnotations += ((PmdResult)action.getResult()).getNumberOfAnnotations(this.tasksPriority);
        }
        return numberOfAnnotations;
    }

    @Override
    public String getName() {
        return Messages.PmdRuleSet_DefaultRule_Name(this.tasksPriority.name());
    }
}

