/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.findbugs;

import hudson.model.AbstractBuild;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.plugins.findbugs.AbstractFindBugsWarningsRule;
import hudson.plugins.cigame.rules.plugins.findbugs.Messages;
import java.util.Collection;

public class NewFindBugsWarningsRule
extends AbstractFindBugsWarningsRule {
    private int pointsForEachNewWarning;

    public NewFindBugsWarningsRule(Priority priority, int pointsForEachNewWarning) {
        super(priority);
        this.pointsForEachNewWarning = pointsForEachNewWarning;
    }

    @Override
    public RuleResult<?> aggregate(Collection<RuleResult<Integer>> results) {
        double score = 0.0;
        int newWarnings = 0;
        for (RuleResult<Integer> result : results) {
            if (result == null) continue;
            score += result.getPoints();
            newWarnings += result.getAdditionalData().intValue();
        }
        if (score != 0.0) {
            return new RuleResult(score, Messages.FindBugsRuleSet_NewWarningsRule_Count(Math.abs(newWarnings), this.priority.name()));
        }
        return EMPTY_RESULT;
    }

    @Override
    protected RuleResult<Integer> evaluate(int previousAnnotations, int currentAnnotations) {
        if (currentAnnotations > previousAnnotations) {
            int newWarnings = currentAnnotations - previousAnnotations;
            return new RuleResult<Integer>(newWarnings * this.pointsForEachNewWarning, Messages.FindBugsRuleSet_NewWarningsRule_Count(Math.abs(newWarnings), this.priority.name()), newWarnings);
        }
        return EMPTY_RESULT;
    }

    @Override
    public RuleResult<Integer> evaluate(AbstractBuild<?, ?> build) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return Messages.FindBugsRuleSet_NewWarningsRule_Title(this.priority.name());
    }
}

