/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.findbugs;

import hudson.model.AbstractBuild;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.plugins.findbugs.AbstractFindBugsWarningsRule;
import hudson.plugins.cigame.rules.plugins.findbugs.Messages;
import java.util.Collection;

public class FixedFindBugsWarningsRule
extends AbstractFindBugsWarningsRule {
    private int pointsForEachFixedWarning;

    public FixedFindBugsWarningsRule(Priority priority, int pointsForEachFixedWarning) {
        super(priority);
        this.pointsForEachFixedWarning = pointsForEachFixedWarning;
    }

    @Override
    protected RuleResult<Integer> evaluate(int previousAnnotations, int currentAnnotations) {
        if (currentAnnotations < previousAnnotations) {
            int fixedWarnings = previousAnnotations - currentAnnotations;
            return new RuleResult<Integer>(fixedWarnings * this.pointsForEachFixedWarning, Messages.FindBugsRuleSet_FixedWarningsRule_Count(Math.abs(fixedWarnings), this.priority.name()), fixedWarnings);
        }
        return EMPTY_RESULT;
    }

    @Override
    public RuleResult<?> aggregate(Collection<RuleResult<Integer>> results) {
        double score = 0.0;
        int fixedWarnings = 0;
        for (RuleResult<Integer> result : results) {
            if (result == null) continue;
            score += result.getPoints();
            fixedWarnings += result.getAdditionalData().intValue();
        }
        if (score != 0.0) {
            return new RuleResult(score, Messages.FindBugsRuleSet_FixedWarningsRule_Count(Math.abs(fixedWarnings), this.priority.name()));
        }
        return EMPTY_RESULT;
    }

    @Override
    public RuleResult<Integer> evaluate(AbstractBuild<?, ?> build) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return Messages.FindBugsRuleSet_FixedWarningsRule_Title(this.priority.name());
    }
}

