/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.checkstyle;

import hudson.maven.MavenBuild;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.checkstyle.CheckStyleResult;
import hudson.plugins.checkstyle.CheckStyleResultAction;
import hudson.plugins.cigame.model.AggregatableRule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.plugins.checkstyle.Messages;
import hudson.plugins.cigame.util.ActionRetriever;
import java.util.Collection;
import java.util.List;

public class DefaultCheckstyleRule
implements AggregatableRule<Integer> {
    private int pointsForAddingAWarning;
    private int pointsForRemovingAWarning;

    public DefaultCheckstyleRule(int pointsForAddingAWarning, int pointsForRemovingAWarning) {
        this.pointsForAddingAWarning = pointsForAddingAWarning;
        this.pointsForRemovingAWarning = pointsForRemovingAWarning;
    }

    @Override
    public RuleResult<?> aggregate(Collection<RuleResult<Integer>> results) {
        double score = 0.0;
        int newWarnings = 0;
        for (RuleResult<Integer> result : results) {
            if (result == null) continue;
            score += result.getPoints();
            newWarnings += result.getAdditionalData().intValue();
        }
        if (newWarnings > 0) {
            return new RuleResult(score, Messages.CheckstyleRuleSet_DefaultRule_NewWarningsCount(newWarnings));
        }
        if (newWarnings < 0) {
            return new RuleResult(score, Messages.CheckstyleRuleSet_DefaultRule_FixedWarningsCount(newWarnings * -1));
        }
        return RuleResult.EMPTY_INT_RESULT;
    }

    @Override
    public RuleResult<Integer> evaluate(AbstractBuild<?, ?> previousBuild, AbstractBuild<?, ?> build) {
        if (build != null && build.getResult() != null && build.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return RuleResult.EMPTY_INT_RESULT;
        }
        if (previousBuild == null ? !(build instanceof MavenBuild) : previousBuild.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return RuleResult.EMPTY_INT_RESULT;
        }
        List<CheckStyleResultAction> currentActions = ActionRetriever.getResult(build, Result.UNSTABLE, CheckStyleResultAction.class);
        if (!this.hasNoErrors(currentActions)) {
            return RuleResult.EMPTY_INT_RESULT;
        }
        int currentAnnotations = this.getNumberOfAnnotations(currentActions);
        List<CheckStyleResultAction> previousActions = ActionRetriever.getResult(previousBuild, Result.UNSTABLE, CheckStyleResultAction.class);
        if (!this.hasNoErrors(previousActions)) {
            return RuleResult.EMPTY_INT_RESULT;
        }
        int previousAnnotations = this.getNumberOfAnnotations(previousActions);
        int numberOfNewWarnings = currentAnnotations - previousAnnotations;
        if (numberOfNewWarnings > 0) {
            return new RuleResult<Integer>(numberOfNewWarnings * this.pointsForAddingAWarning, Messages.CheckstyleRuleSet_DefaultRule_NewWarningsCount(numberOfNewWarnings), numberOfNewWarnings);
        }
        if (numberOfNewWarnings < 0) {
            return new RuleResult<Integer>(numberOfNewWarnings * -1 * this.pointsForRemovingAWarning, Messages.CheckstyleRuleSet_DefaultRule_FixedWarningsCount(numberOfNewWarnings * -1), numberOfNewWarnings);
        }
        return RuleResult.EMPTY_INT_RESULT;
    }

    @Override
    public RuleResult<Integer> evaluate(AbstractBuild<?, ?> build) {
        throw new UnsupportedOperationException();
    }

    private boolean hasNoErrors(List<CheckStyleResultAction> actions) {
        for (CheckStyleResultAction action : actions) {
            if (!((CheckStyleResult)action.getResult()).hasError()) continue;
            return false;
        }
        return true;
    }

    private int getNumberOfAnnotations(List<CheckStyleResultAction> actions) {
        int numberOfAnnotations = 0;
        for (CheckStyleResultAction action : actions) {
            numberOfAnnotations += ((CheckStyleResult)action.getResult()).getNumberOfAnnotations();
        }
        return numberOfAnnotations;
    }

    @Override
    public String getName() {
        return Messages.CheckstyleRuleSet_DefaultRule_Name();
    }
}

