/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.build;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.build.Messages;

public class BuildResultRule
implements Rule {
    private int failurePoints;
    private int successPoints;

    public BuildResultRule() {
        this(1, -10);
    }

    public BuildResultRule(int successPoints, int failurePoints) {
        this.successPoints = successPoints;
        this.failurePoints = failurePoints;
    }

    @Override
    public String getName() {
        return Messages.BuildRuleSet_BuildResult();
    }

    @Override
    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        Result result = build.getResult();
        Result lastResult = null;
        if (build.getPreviousBuild() != null) {
            lastResult = build.getPreviousBuild().getResult();
        }
        return this.evaluate(result, lastResult);
    }

    RuleResult evaluate(Result result, Result lastResult) {
        if (result == Result.SUCCESS) {
            return new RuleResult(this.successPoints, Messages.BuildRuleSet_BuildSuccess());
        }
        if (result == Result.FAILURE && (lastResult == null || lastResult.isBetterThan(Result.FAILURE))) {
            return new RuleResult(this.failurePoints, Messages.BuildRuleSet_BuildFailed());
        }
        return null;
    }
}

