/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.export.Exported;

public class ScoreHistoryEntry {
    private SortedSet<Run<?, ?>> awardingRuns;
    private double awardedScore;

    public ScoreHistoryEntry() {
    }

    public ScoreHistoryEntry(Collection<? extends Run<?, ?>> awardingRuns, double awardedScore) {
        this.setAwardingRuns(awardingRuns);
        this.awardedScore = awardedScore;
    }

    public Set<Run<?, ?>> getAwardingRuns() {
        return this.awardingRuns;
    }

    public void setAwardingRuns(Collection<? extends Run<?, ?>> awardingRuns) {
        this.awardingRuns = Sets.newTreeSet((Comparator)Ordering.natural().reverse());
        this.awardingRuns.addAll(Collections2.filter(awardingRuns, (Predicate)Predicates.notNull()));
    }

    public double getAwardedScore() {
        return this.awardedScore;
    }

    @Exported
    public String getAwardedScoreString() {
        if (this.awardedScore > 0.0) {
            return "+" + String.valueOf(this.awardedScore);
        }
        return String.valueOf(this.awardedScore);
    }

    public void setAwardedScore(double awardedScore) {
        this.awardedScore = awardedScore;
    }

    public static ScoreHistoryEntry fromScoreAward(@Nonnull List<? extends Run<?, ?>> accountableBuilds, double accountedScore) {
        return new ScoreHistoryEntry(accountableBuilds, accountedScore);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScoreHistoryEntry that = (ScoreHistoryEntry)o;
        if (Double.compare(that.awardedScore, this.awardedScore) != 0) {
            return false;
        }
        return Objects.equal(this.awardingRuns, that.awardingRuns);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.awardedScore, this.awardingRuns});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("awardedScore", (Object)this.getAwardedScoreString()).add("awardingRuns", this.awardingRuns).toString();
    }

    @VisibleForTesting
    protected Run<?, ?> runFromExternalId(String externalId) {
        return Run.fromExternalizableId((String)externalId);
    }

    public static class DefaultRunCreationStrategy
    implements RunCreationStrategy {
        @Override
        public Run<?, ?> createRunFromExternalId(String externalId) {
            return Run.fromExternalizableId((String)externalId);
        }
    }

    public static interface RunCreationStrategy {
        public Run<?, ?> createRunFromExternalId(String var1);
    }

    public static final class ConverterImpl
    implements Converter {
        private RunCreationStrategy runCreationStrategy;

        public ConverterImpl() {
            this(new DefaultRunCreationStrategy());
        }

        public ConverterImpl(RunCreationStrategy runCreationStrategy) {
            this.runCreationStrategy = runCreationStrategy;
        }

        public boolean canConvert(Class type) {
            return type == ScoreHistoryEntry.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            ScoreHistoryEntry entry = (ScoreHistoryEntry)source;
            writer.startNode("score");
            writer.setValue(String.valueOf(entry.getAwardedScore()));
            writer.endNode();
            writer.startNode("accountableRuns");
            for (Run run : entry.awardingRuns) {
                writer.startNode("run");
                writer.setValue(run.getExternalizableId());
                writer.endNode();
            }
            writer.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            reader.moveDown();
            double score = Double.valueOf(reader.getValue());
            reader.moveUp();
            reader.moveDown();
            ArrayList awardingRuns = Lists.newArrayList();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String externalId = reader.getValue();
                awardingRuns.add(this.runCreationStrategy.createRunFromExternalId(externalId));
                reader.moveUp();
            }
            reader.moveUp();
            return ScoreHistoryEntry.fromScoreAward(awardingRuns, score);
        }
    }
}

