/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.model;

import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.cigame.model.AggregatableRule;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleBook;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.model.RuleSet;
import hudson.plugins.cigame.model.Score;
import hudson.plugins.cigame.util.BuildUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class ScoreCard {
    private List<Score> scores;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(AbstractBuild<?, ?> build, RuleSet ruleset, BuildListener listener) {
        LinkedList<Score> scoresForBuild = new LinkedList<Score>();
        for (Rule rule : ruleset.getRules()) {
            if (null != rule) {
                RuleResult<?> result;
                if (listener != null) {
                    listener.getLogger().append("[ci-game] evaluating rule: " + rule.getName() + "\n");
                }
                if ((result = this.evaluate(build, rule)) == null || result.getPoints() == 0.0) continue;
                Score score = new Score(ruleset.getName(), rule.getName(), result.getPoints(), result.getDescription());
                scoresForBuild.add(score);
                if (listener == null) continue;
                listener.getLogger().append("[ci-game] scored: " + score.getValue() + "\n");
                continue;
            }
            if (listener == null) continue;
            listener.getLogger().append("[ci-game] null rule encountered\n");
        }
        ScoreCard scoreCard = this;
        synchronized (scoreCard) {
            if (this.scores == null) {
                this.scores = new LinkedList<Score>();
            }
            this.scores.addAll(scoresForBuild);
            Collections.sort(this.scores);
        }
    }

    RuleResult<?> evaluate(AbstractBuild<?, ?> build, Rule rule) {
        if (rule instanceof AggregatableRule && build instanceof MavenModuleSetBuild) {
            AggregatableRule aRule = (AggregatableRule)rule;
            MavenModuleSetBuild mavenModuleSetBuild = (MavenModuleSetBuild)build;
            ArrayList results = new ArrayList();
            for (Map.Entry e : mavenModuleSetBuild.getModuleLastBuilds().entrySet()) {
                MavenBuild moduleBuild = (MavenBuild)e.getValue();
                if (moduleBuild != null) {
                    AbstractBuild<?, ?> previousBuild = BuildUtil.getPreviousBuiltBuild(moduleBuild);
                    results.add(aRule.evaluate(previousBuild, (AbstractBuild<?, ?>)moduleBuild));
                    continue;
                }
                if (mavenModuleSetBuild.getPreviousBuild() != null) {
                    MavenModuleSetBuild prevBuild = (MavenModuleSetBuild)mavenModuleSetBuild.getPreviousBuild();
                    AbstractBuild<?, ?> prevModuleBuild = (AbstractBuild<?, ?>)prevBuild.getModuleLastBuilds().get(e.getKey());
                    if (prevModuleBuild.getResult() == null) {
                        prevModuleBuild = BuildUtil.getPreviousBuiltBuild(prevModuleBuild);
                    }
                    results.add(aRule.evaluate(prevModuleBuild, null));
                    continue;
                }
                return RuleResult.EMPTY_RESULT;
            }
            return aRule.aggregate(results);
        }
        if (rule instanceof AggregatableRule) {
            AggregatableRule aRule = (AggregatableRule)rule;
            return aRule.evaluate(build.getPreviousBuild(), build);
        }
        return rule.evaluate(build);
    }

    public void record(AbstractBuild<?, ?> build, RuleBook ruleBook, BuildListener listener) {
        if (this.scores == null) {
            this.scores = new LinkedList<Score>();
        }
        for (RuleSet set : ruleBook.getRuleSets()) {
            this.record(build, set, listener);
        }
    }

    @Exported
    public Collection<Score> getScores() throws IllegalStateException {
        if (this.scores == null) {
            throw new IllegalStateException("No scores are available");
        }
        return this.scores;
    }

    @Exported
    public double getTotalPoints() throws IllegalStateException {
        if (this.scores == null) {
            throw new IllegalStateException("No scores are available");
        }
        double value = 0.0;
        for (Score score : this.scores) {
            value += score.getValue();
        }
        return value;
    }
}

