/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.model;

import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class Score
implements Comparable<Score> {
    private final String rulesetName;
    private final String ruleName;
    private final double value;
    private final String description;

    public Score(String rulesetName, String ruleName, double points, String pointDescription) {
        this.rulesetName = rulesetName;
        this.ruleName = ruleName;
        this.value = points;
        this.description = pointDescription;
    }

    @Exported
    public String getDescription() {
        if (this.description == null) {
            return this.rulesetName + " - " + this.ruleName;
        }
        return this.description;
    }

    @Exported
    public String getRulesetName() {
        return this.rulesetName;
    }

    @Exported
    public String getRuleName() {
        return this.ruleName;
    }

    @Exported
    public double getValue() {
        return this.value;
    }

    @Override
    public int compareTo(Score o) {
        if (this.value == o.value) {
            return this.description.compareToIgnoreCase(o.description);
        }
        return (int)Math.round(o.value - this.value);
    }
}

