/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.model;

public class RuleResult<T> {
    public static final RuleResult<?> EMPTY_RESULT = new EmptyRuleResult();
    public static final RuleResult<Integer> EMPTY_INT_RESULT = new RuleResult<Integer>(0.0, "", 0);
    private final double points;
    private final String description;
    private T additionalData;

    public RuleResult(double points, String description) {
        this(points, description, null);
    }

    public RuleResult(double points, String description, T additionalData) {
        this.points = points;
        this.description = description;
        this.additionalData = additionalData;
    }

    public double getPoints() {
        return this.points;
    }

    public String getDescription() {
        return this.description;
    }

    public T getAdditionalData() {
        return this.additionalData;
    }

    public String toString() {
        return "[RuleSet description='" + this.description + "', points=" + this.points + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        long temp = Double.doubleToLongBits(this.points);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleResult other = (RuleResult)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return Double.doubleToLongBits(this.points) == Double.doubleToLongBits(other.points);
    }

    private static class EmptyRuleResult
    extends RuleResult<Void> {
        private EmptyRuleResult() {
            super(0.0, "");
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException("Empty rule result should not be used.");
        }
    }
}

