/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.plugins.cigame.Messages;
import hudson.plugins.cigame.UserScoreProperty;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class UserScorePropertyDescriptor
extends UserPropertyDescriptor {
    public UserScorePropertyDescriptor() {
        super(UserScoreProperty.class);
    }

    public String getDisplayName() {
        return Messages.User_Property_Title();
    }

    private UserScoreProperty newInstanceIfJSONIsNull(StaplerRequest req) throws Descriptor.FormException {
        String scoreStr = Util.fixEmpty((String)req.getParameter("game.score"));
        if (scoreStr != null && this.checkUserScoreChange(scoreStr)) {
            return new UserScoreProperty(Double.parseDouble(scoreStr), req.getParameter("game.participatingInGame") != null, null);
        }
        return new UserScoreProperty();
    }

    public UserScoreProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        if (formData == null) {
            return this.newInstanceIfJSONIsNull(req);
        }
        if (formData.has("score") && this.checkUserScoreChange(formData.get("score").toString())) {
            return (UserScoreProperty)((Object)req.bindJSON(UserScoreProperty.class, formData));
        }
        return new UserScoreProperty();
    }

    public UserProperty newInstance(User arg0) {
        return null;
    }

    private double getCurrentUserScore() {
        if (User.current() == null) {
            return 0.0;
        }
        UserScoreProperty property = (UserScoreProperty)User.current().getProperty(UserScoreProperty.class);
        return property != null ? property.getScore() : 0.0;
    }

    private double getRequestScore(String strNumber) {
        if (strNumber != null && strNumber.length() > 0) {
            try {
                return Double.parseDouble(strNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0.0;
    }

    private boolean checkUserScoreChange(String score) throws Descriptor.FormException {
        if (this.getCurrentUserScore() != this.getRequestScore(score) && !Hudson.getInstance().getACL().hasPermission(Hudson.ADMINISTER)) {
            throw new Descriptor.FormException(Messages.UserScore_Cheating_Message(), "score");
        }
        return true;
    }
}

