/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.cigame.model.ScoreHistoryEntry;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class UserScoreProperty
extends UserProperty {
    @VisibleForTesting
    protected static final int MAX_HISTORY_LENGTH = 10;
    private double score;
    private boolean isNotParticipatingInGame;
    private List<ScoreHistoryEntry> scoreHistoryEntries;

    public UserScoreProperty() {
        this.score = 0.0;
        this.isNotParticipatingInGame = false;
    }

    @DataBoundConstructor
    public UserScoreProperty(double score, boolean participatingInGame, List<ScoreHistoryEntry> scoreHistoryEntries) {
        this.score = score;
        this.isNotParticipatingInGame = !participatingInGame;
        this.scoreHistoryEntries = scoreHistoryEntries != null ? Lists.newLinkedList(scoreHistoryEntries) : null;
    }

    @Exported
    public User getUser() {
        return this.user;
    }

    @Exported
    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    @Exported
    public boolean isParticipatingInGame() {
        return !this.isNotParticipatingInGame;
    }

    public void rememberAccountableBuilds(List<AbstractBuild<?, ?>> accountableBuilds, double score) {
        this.addScoreHistoryEntry(ScoreHistoryEntry.fromScoreAward(accountableBuilds, score));
    }

    @VisibleForTesting
    protected void addScoreHistoryEntry(ScoreHistoryEntry scoreHistoryEntry) {
        if (this.scoreHistoryEntries == null) {
            this.scoreHistoryEntries = Lists.newLinkedList();
        }
        this.makeSpaceForNewEntryInHistory();
        this.scoreHistoryEntries.add(0, scoreHistoryEntry);
    }

    private void makeSpaceForNewEntryInHistory() {
        while (this.historyReachesOrIsAboveCapacityLimit()) {
            this.removeOldestHistoryEntry();
        }
    }

    private void removeOldestHistoryEntry() {
        this.scoreHistoryEntries.remove(this.scoreHistoryEntries.size() - 1);
    }

    private boolean historyReachesOrIsAboveCapacityLimit() {
        return this.scoreHistoryEntries.size() >= 10;
    }

    @Exported
    public List<ScoreHistoryEntry> getMostRecentScores() {
        if (this.scoreHistoryEntries == null) {
            return Collections.emptyList();
        }
        return Lists.newLinkedList(this.scoreHistoryEntries);
    }

    public String toString() {
        return String.format("UserScoreProperty [isNotParticipatingInGame=%s, score=%s, user=%s, scoreHistory=%s]", this.isNotParticipatingInGame, this.score, this.user, this.scoreHistoryEntries);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isNotParticipatingInGame ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this.score);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.scoreHistoryEntries.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserScoreProperty)) {
            return false;
        }
        UserScoreProperty other = (UserScoreProperty)((Object)obj);
        if (this.isNotParticipatingInGame != other.isNotParticipatingInGame) {
            return false;
        }
        if (Double.doubleToLongBits(this.score) != Double.doubleToLongBits(other.score)) {
            return false;
        }
        return Objects.equal(this.scoreHistoryEntries, other.scoreHistoryEntries);
    }
}

