/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame;

import hudson.Extension;
import hudson.model.Api;
import hudson.model.Hudson;
import hudson.model.RootAction;
import hudson.model.User;
import hudson.plugins.cigame.CaseInsensitiveUserIdComparator;
import hudson.plugins.cigame.GameDescriptor;
import hudson.plugins.cigame.Messages;
import hudson.plugins.cigame.UserScoreProperty;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
@Extension
public class LeaderBoardAction
implements RootAction,
AccessControlled {
    private static final long serialVersionUID = 1L;

    public String getDisplayName() {
        return Messages.Leaderboard_Title();
    }

    public String getIconFileName() {
        return "/plugin/ci-game/icons/game-22x22.png";
    }

    public String getUrlName() {
        return "/cigame";
    }

    @Exported
    public List<UserScore> getUserScores() {
        return this.getUserScores(User.getAll(), ((GameDescriptor)Hudson.getInstance().getDescriptorByType(GameDescriptor.class)).getNamesAreCaseSensitive());
    }

    @Exported
    public boolean isUserAvatarSupported() {
        return new VersionNumber(Hudson.VERSION).isNewerThan(new VersionNumber("1.433"));
    }

    List<UserScore> getUserScores(Collection<User> users, boolean usernameIsCasesensitive) {
        Collection<User> players;
        ArrayList<UserScore> list = new ArrayList<UserScore>();
        if (usernameIsCasesensitive) {
            players = users;
        } else {
            ArrayList<User> playerList = new ArrayList<User>();
            CaseInsensitiveUserIdComparator caseInsensitiveUserIdComparator = new CaseInsensitiveUserIdComparator();
            for (User user : users) {
                if (Collections.binarySearch(playerList, user, caseInsensitiveUserIdComparator) >= 0) continue;
                playerList.add(user);
            }
            players = playerList;
        }
        for (User user : players) {
            UserScoreProperty property = (UserScoreProperty)user.getProperty(UserScoreProperty.class);
            if (property == null || !property.isParticipatingInGame()) continue;
            list.add(new UserScore(user, property.getScore(), user.getDescription()));
        }
        Collections.sort(list, new Comparator<UserScore>(){

            @Override
            public int compare(UserScore o1, UserScore o2) {
                if (o1.score < o2.score) {
                    return 1;
                }
                if (o1.score > o2.score) {
                    return -1;
                }
                return 0;
            }
        });
        return list;
    }

    public void doResetScores(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (Hudson.getInstance().getACL().hasPermission(Hudson.ADMINISTER)) {
            this.doResetScores(User.getAll());
        }
        rsp.sendRedirect2(req.getContextPath());
    }

    void doResetScores(Collection<User> users) throws IOException {
        for (User user : users) {
            UserScoreProperty property = (UserScoreProperty)user.getProperty(UserScoreProperty.class);
            if (property == null) continue;
            property.setScore(0.0);
            user.save();
        }
    }

    public ACL getACL() {
        return Hudson.getInstance().getACL();
    }

    public void checkPermission(Permission p) {
        this.getACL().checkPermission(p);
    }

    public boolean hasPermission(Permission p) {
        return this.getACL().hasPermission(p);
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    @ExportedBean(defaultVisibility=999)
    public class UserScore {
        private User user;
        private double score;
        private String description;

        public UserScore(User user, double score, String description) {
            this.user = user;
            this.score = score;
            this.description = description;
        }

        @Exported
        public User getUser() {
            return this.user;
        }

        @Exported
        public double getScore() {
            return this.score;
        }

        @Exported
        public String getDescription() {
            return this.description;
        }
    }
}

