/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.cigame.GameDescriptor;
import hudson.plugins.cigame.ScoreCardAction;
import hudson.plugins.cigame.UserScoreProperty;
import hudson.plugins.cigame.model.RuleBook;
import hudson.plugins.cigame.model.ScoreCard;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class GamePublisher
extends Notifier {
    public GameDescriptor getDescriptor() {
        return (GameDescriptor)super.getDescriptor();
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.perform(build, this.getDescriptor().getRuleBook(), this.getDescriptor().getNamesAreCaseSensitive(), listener);
        return true;
    }

    boolean perform(AbstractBuild<?, ?> build, RuleBook ruleBook, boolean usernameIsCasesensitive, BuildListener listener) throws IOException {
        ScoreCard sc = new ScoreCard();
        sc.record(build, ruleBook, listener);
        ScoreCardAction action = new ScoreCardAction(sc, build);
        build.getActions().add(action);
        ArrayList accountableBuilds = new ArrayList();
        accountableBuilds.add(build);
        AbstractBuild upstreamBuild = this.getBuildByUpstreamCause(build.getCauses(), listener);
        if (upstreamBuild != null) {
            accountableBuilds.add(upstreamBuild);
            ChangeLogSet changeSet = upstreamBuild.getChangeSet();
            if (listener != null) {
                listener.getLogger().append("[ci-game] UpStream Build ID: " + upstreamBuild.getId() + "\n");
            }
            if (listener != null) {
                listener.getLogger().append("[ci-game] UpStream Display Name: " + upstreamBuild.getFullDisplayName() + "\n");
            }
            if (listener != null) {
                listener.getLogger().append("[ci-game] Is UpStream Change Set Empty: " + changeSet.isEmptySet() + "\n");
            }
        }
        for (AbstractBuild previousBuild = build.getPreviousBuild(); previousBuild != null && previousBuild.getResult() == Result.ABORTED; previousBuild = previousBuild.getPreviousBuild()) {
            accountableBuilds.add(previousBuild);
        }
        TreeSet<User> players = new TreeSet<User>(usernameIsCasesensitive ? null : new UsernameCaseinsensitiveComparator());
        for (AbstractBuild abstractBuild : accountableBuilds) {
            ChangeLogSet changeSet = abstractBuild.getChangeSet();
            if (changeSet == null) continue;
            for (ChangeLogSet.Entry e : changeSet) {
                players.add(e.getAuthor());
            }
        }
        return this.updateUserScores(players, sc.getTotalPoints(), accountableBuilds);
    }

    private AbstractBuild getBuildByUpstreamCause(List<Cause> causes, BuildListener listener) {
        for (Cause cause : causes) {
            TopLevelItem upstreamProject;
            if (!(cause instanceof Cause.UpstreamCause) || !((upstreamProject = (TopLevelItem)Hudson.getInstance().getItemByFullName(((Cause.UpstreamCause)cause).getUpstreamProject(), TopLevelItem.class)) instanceof AbstractProject)) continue;
            int buildId = ((Cause.UpstreamCause)cause).getUpstreamBuild();
            AbstractBuild run = ((AbstractProject)upstreamProject).getBuildByNumber(buildId);
            System.out.println();
            AbstractBuild upstreamRun = this.getBuildByUpstreamCause(run.getCauses(), listener);
            if (upstreamRun == null) {
                return run;
            }
            return upstreamRun;
        }
        return null;
    }

    private boolean updateUserScores(Set<User> players, double score, List<AbstractBuild<?, ?>> accountableBuilds) throws IOException {
        if (score != 0.0) {
            for (User user : players) {
                UserScoreProperty property = (UserScoreProperty)user.getProperty(UserScoreProperty.class);
                if (property == null) {
                    property = new UserScoreProperty();
                    user.addProperty((UserProperty)property);
                }
                if (property.isParticipatingInGame()) {
                    property.setScore(property.getScore() + score);
                    property.rememberAccountableBuilds(accountableBuilds, score);
                }
                user.save();
            }
        }
        return !players.isEmpty();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public static class UsernameCaseinsensitiveComparator
    implements Comparator<User> {
        @Override
        public int compare(User arg0, User arg1) {
            return arg0.getId().compareToIgnoreCase(arg1.getId());
        }
    }
}

