/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout.global;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Project;
import hudson.plugins.build_timeout.BuildStepWithTimeout;
import hudson.plugins.build_timeout.BuildTimeOutOperation;
import hudson.plugins.build_timeout.BuildTimeOutOperationDescriptor;
import hudson.plugins.build_timeout.BuildTimeOutStrategy;
import hudson.plugins.build_timeout.BuildTimeOutStrategyDescriptor;
import hudson.plugins.build_timeout.global.TimeOutProvider;
import hudson.plugins.build_timeout.operations.AbortOperation;
import hudson.tasks.Builder;
import jakarta.inject.Inject;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class GlobalTimeOutConfiguration
extends GlobalConfiguration
implements TimeOutProvider {
    private static final Logger log = Logger.getLogger(GlobalTimeOutConfiguration.class.getName());
    private transient Jenkins jenkins;
    private BuildTimeOutStrategy strategy;
    private List<BuildTimeOutOperation> operations;
    private boolean overwriteable;

    public GlobalTimeOutConfiguration() {
        this.load();
    }

    @Inject
    public void setJenkins(Jenkins jenkins) {
        this.jenkins = jenkins;
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) {
        JSONObject settings = json.getJSONObject("timeout").getJSONObject("global");
        this.overwriteable = false;
        if (settings.isNullObject()) {
            this.strategy = null;
            this.operations = null;
            log.info("global timeout has been cleared");
        } else {
            req.bindJSON((Object)this, settings);
            log.info(() -> String.format("global timeout updated to %s with operations: %s", this.strategy, this.describeOperations()));
        }
        this.save();
        return true;
    }

    public synchronized void load() {
        super.load();
        log.info(() -> {
            if (this.strategy == null) {
                return "global timeout not set";
            }
            return String.format("global timeout loaded as %s with operations: %s", this.strategy, this.describeOperations());
        });
    }

    @Override
    public Optional<Duration> timeOutFor(AbstractBuild<?, ?> build, BuildListener listener) {
        try {
            List builders = ((Project)build.getProject()).getBuilders();
            Optional<Builder> timeoutBuildStep = builders.stream().filter(builder -> builder instanceof BuildStepWithTimeout).findAny();
            if (this.strategy == null || timeoutBuildStep.isPresent() && this.getOverwriteable()) {
                return Optional.empty();
            }
            return Optional.of(Duration.ofMillis(this.strategy.getTimeOut(build, listener)));
        }
        catch (ClassCastException e) {
            if (this.strategy == null) {
                return Optional.empty();
            }
            try {
                return Optional.of(Duration.ofMillis(this.strategy.getTimeOut(build, listener)));
            }
            catch (IOException | InterruptedException | MacroEvaluationException ex) {
                log.log(Level.WARNING, ex, () -> String.format("%s failed to determine time out", build.getExternalizableId()));
                return Optional.empty();
            }
        }
        catch (IOException | InterruptedException | MacroEvaluationException e) {
            log.log(Level.WARNING, e, () -> String.format("%s failed to determine time out", build.getExternalizableId()));
            return Optional.empty();
        }
    }

    public boolean isEnabled() {
        return this.strategy != null;
    }

    public boolean getOverwriteable() {
        return this.overwriteable;
    }

    public void setOverwriteable(boolean overwriteable) {
        this.overwriteable = overwriteable;
    }

    @Override
    public List<BuildTimeOutOperation> getOperations() {
        List<Object> nullSafe;
        List<Object> list = nullSafe = this.operations == null ? new LinkedList() : this.operations;
        if (nullSafe.isEmpty()) {
            nullSafe.add(new AbortOperation());
        }
        return nullSafe;
    }

    public void setOperations(List<BuildTimeOutOperation> operations) {
        this.operations = operations;
    }

    public BuildTimeOutStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(BuildTimeOutStrategy strategy) {
        this.strategy = strategy;
    }

    public List<BuildTimeOutStrategyDescriptor> getAllStrategies() {
        return this.jenkins.getDescriptorList(BuildTimeOutStrategy.class);
    }

    public List<BuildTimeOutOperationDescriptor> getAllOperations() {
        return this.jenkins.getDescriptorList(BuildTimeOutOperation.class);
    }

    private String describeOperations() {
        List<Object> nullSafe;
        List<Object> list = nullSafe = this.operations == null ? Collections.emptyList() : this.operations;
        if (nullSafe.isEmpty()) {
            return "(none)";
        }
        return nullSafe.stream().map(Object::getClass).map(Class::getSimpleName).sorted().collect(Collectors.joining(", "));
    }
}

