/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline;

import au.com.centrumsystems.hudson.plugin.buildpipeline.PipelineBuild;
import au.com.centrumsystems.hudson.plugin.buildpipeline.ProjectJSONBuilder;
import au.com.centrumsystems.hudson.plugin.buildpipeline.extension.PipelineHeaderExtension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.plugins.parameterizedtrigger.BlockableBuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.SubProjectsAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ProjectForm {
    private final String name;
    private final String result;
    private final String health;
    private final String url;
    private final List<ProjectForm> dependencies;
    private Boolean displayTrigger;
    private final String lastSuccessfulBuildNumber;
    private final Map<String, String> lastSuccessfulBuildParams;
    private final AbstractProject<?, ?> project;

    public ProjectForm(String name) {
        this.name = name;
        this.result = "";
        this.health = "";
        this.url = "";
        this.lastSuccessfulBuildNumber = "";
        this.lastSuccessfulBuildParams = new HashMap<String, String>();
        this.dependencies = new ArrayList<ProjectForm>();
        this.displayTrigger = true;
        this.project = null;
    }

    public ProjectForm(AbstractProject<?, ?> project, PipelineHeaderExtension columnHeaders) {
        this(project, columnHeaders, new LinkedHashSet(Arrays.asList(project)));
    }

    private ProjectForm(AbstractProject<?, ?> project, PipelineHeaderExtension columnHeaders, Collection<AbstractProject<?, ?>> parentPath) {
        PipelineBuild pipelineBuild = new PipelineBuild(project.getLastBuild(), project, null);
        this.name = pipelineBuild.getProject().getFullName();
        this.result = pipelineBuild.getCurrentBuildResult();
        this.health = pipelineBuild.getProject().getBuildHealth().getIconUrl().replaceAll("\\.gif", "\\.png");
        this.url = pipelineBuild.getProjectURL();
        this.dependencies = new ArrayList<ProjectForm>();
        Iterator iterator = project.getDownstreamProjects().iterator();
        while (iterator.hasNext()) {
            LinkedHashSet forkedPath = new LinkedHashSet(parentPath);
            AbstractProject dependency = (AbstractProject)iterator.next();
            if (!forkedPath.add(dependency)) continue;
            this.dependencies.add(new ProjectForm(dependency, columnHeaders, forkedPath));
        }
        if (Hudson.getInstance().getPlugin("parameterized-trigger") != null) {
            for (SubProjectsAction action : Util.filter((List)project.getActions(), SubProjectsAction.class)) {
                for (BlockableBuildTriggerConfig config : action.getConfigs()) {
                    Iterator iterator2 = config.getProjectList(project.getParent(), null).iterator();
                    while (iterator2.hasNext()) {
                        ProjectForm candidate;
                        LinkedHashSet forkedPath = new LinkedHashSet(parentPath);
                        AbstractProject dependency = (AbstractProject)iterator2.next();
                        if (!forkedPath.add(dependency) || this.dependencies.contains(candidate = new ProjectForm(dependency, columnHeaders, forkedPath))) continue;
                        this.dependencies.add(candidate);
                    }
                }
            }
        }
        this.displayTrigger = true;
        AbstractBuild lastSuccessfulBuild = (AbstractBuild)pipelineBuild.getProject().getLastSuccessfulBuild();
        this.lastSuccessfulBuildNumber = null == lastSuccessfulBuild ? "" : "" + lastSuccessfulBuild.getNumber();
        this.lastSuccessfulBuildParams = columnHeaders.getParameters(lastSuccessfulBuild);
        this.project = project;
    }

    public static ProjectForm as(AbstractProject<?, ?> p, PipelineHeaderExtension columnHeaders) {
        return p != null ? new ProjectForm(p, columnHeaders) : null;
    }

    public String getName() {
        return this.name;
    }

    public String getHealth() {
        return this.health;
    }

    public String getResult() {
        return this.result;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLastSuccessfulBuildNumber() {
        return this.lastSuccessfulBuildNumber;
    }

    public Map<String, String> getLastSuccessfulBuildParams() {
        return this.lastSuccessfulBuildParams;
    }

    public List<ProjectForm> getDependencies() {
        return this.dependencies;
    }

    public Boolean getDisplayTrigger() {
        return this.displayTrigger;
    }

    public void setDisplayTrigger(Boolean display) {
        this.displayTrigger = display;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectForm other = (ProjectForm)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int getId() {
        return this.name.hashCode() & Integer.MAX_VALUE;
    }

    @JavaScriptMethod
    public String asJSON() {
        return ProjectJSONBuilder.asJSON(this);
    }
}

