/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline;

import au.com.centrumsystems.hudson.plugin.buildpipeline.BuildJSONBuilder;
import au.com.centrumsystems.hudson.plugin.buildpipeline.PipelineBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import hudson.model.ParametersDefinitionProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class BuildForm {
    private static final Logger LOGGER = Logger.getLogger(BuildForm.class.getName());
    private String status = "";
    private PipelineBuild pipelineBuild;
    private final Integer id;
    private final Integer projectId;
    private List<BuildForm> dependencies = new ArrayList<BuildForm>();
    private final ArrayList<String> parameters;
    private final ItemGroup context;

    public BuildForm(ItemGroup context, PipelineBuild pipelineBuild) {
        this(context, pipelineBuild, new LinkedHashSet(Arrays.asList(pipelineBuild.getProject())));
    }

    private BuildForm(ItemGroup context, PipelineBuild pipelineBuild, Collection<AbstractProject<?, ?>> parentPath) {
        this.context = context;
        this.pipelineBuild = pipelineBuild;
        this.status = pipelineBuild.getCurrentBuildResult();
        this.dependencies = new ArrayList<BuildForm>();
        Iterator<PipelineBuild> iterator = pipelineBuild.getDownstreamPipeline().iterator();
        while (iterator.hasNext()) {
            LinkedHashSet forkedPath = new LinkedHashSet(parentPath);
            PipelineBuild downstream = iterator.next();
            if (!forkedPath.add(downstream.getProject())) continue;
            this.dependencies.add(new BuildForm(context, downstream, forkedPath));
        }
        this.id = this.hashCode();
        AbstractProject<?, ?> project = pipelineBuild.getProject();
        this.projectId = project.getFullName().hashCode() & Integer.MAX_VALUE;
        ParametersDefinitionProperty params = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        ArrayList<String> paramList = new ArrayList<String>();
        if (params != null && params.getParameterDefinitionNames() != null) {
            for (String p : params.getParameterDefinitionNames()) {
                paramList.add(p);
            }
        }
        this.parameters = paramList;
    }

    public String getStatus() {
        return this.status;
    }

    public List<BuildForm> getDependencies() {
        return this.dependencies;
    }

    public List<Integer> getDependencyIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (BuildForm dependency : this.dependencies) {
            ids.add(dependency.getId());
        }
        return ids;
    }

    @JavaScriptMethod
    public String asJSON() {
        return BuildJSONBuilder.asJSON(this.context, this.pipelineBuild, this.id, this.projectId, this.getDependencyIds(), this.getParameterList());
    }

    public int getId() {
        return this.id;
    }

    @JavaScriptMethod
    public boolean updatePipelineBuild(int nextBuildNumber) {
        boolean updated = false;
        AbstractBuild newBuild = this.pipelineBuild.getProject().getBuildByNumber(nextBuildNumber);
        if (newBuild != null) {
            updated = true;
            this.pipelineBuild = new PipelineBuild(newBuild, newBuild.getProject(), this.pipelineBuild.getUpstreamBuild());
        }
        return updated;
    }

    public int getNextBuildNumber() {
        return this.pipelineBuild.getProject().getNextBuildNumber();
    }

    public String getRevision() {
        return this.pipelineBuild.getPipelineVersion();
    }

    @JavaScriptMethod
    public boolean isManualTrigger() {
        return this.pipelineBuild.isManualTrigger();
    }

    public ArrayList<String> getParameterList() {
        return this.parameters;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public AbstractBuild<?, ?> getCurrentBuild() {
        return this.pipelineBuild.getCurrentBuild();
    }
}

