/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.buildblocker;

import hudson.matrix.MatrixConfiguration;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.WorkUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;

public class BlockingJobsMonitor {
    private List<String> blockingJobs = Collections.emptyList();
    private static final Logger LOG = Logger.getLogger(BlockingJobsMonitor.class.getName());

    public BlockingJobsMonitor(String blockingJobs) {
        if (StringUtils.isNotBlank((CharSequence)blockingJobs)) {
            this.blockingJobs = Arrays.asList(blockingJobs.split("\n"));
        }
    }

    public Job checkForBuildableQueueEntries(Queue.Item item) {
        List buildableItems = Jenkins.get().getQueue().getBuildableItems();
        Job buildableItem = this.checkForPlannedBuilds(item, buildableItems);
        if (buildableItem != null) {
            LOG.logp(Level.FINE, this.getClass().getName(), "checkForBuildableQueueEntries", "build " + String.valueOf(item) + " blocked by queued build " + String.valueOf(buildableItem));
            return buildableItem;
        }
        return null;
    }

    public Job checkForQueueEntries(Queue.Item item) {
        List<Queue.Item> buildableItems = Arrays.asList(Jenkins.get().getQueue().getItems());
        Job buildableItem = this.checkForPlannedBuilds(item, buildableItems);
        if (buildableItem != null) {
            LOG.logp(Level.FINE, this.getClass().getName(), "checkForQueueEntries", "build " + String.valueOf(item) + " blocked by queued build " + String.valueOf(buildableItem));
            return buildableItem;
        }
        return null;
    }

    public Job checkNodeForBuildableQueueEntries(Queue.Item item, Node node) {
        List buildableItems = Jenkins.get().getQueue().getBuildableItems(node.toComputer());
        Job buildableItem = this.checkForPlannedBuilds(item, buildableItems);
        if (buildableItem != null) {
            LOG.logp(Level.FINE, this.getClass().getName(), "checkNodeForBuildableQueueEntries", "build " + String.valueOf(item) + " blocked by queued build " + String.valueOf(buildableItem));
            return buildableItem;
        }
        return null;
    }

    public Job checkNodeForQueueEntries(Queue.Item item, Node node) {
        ArrayList<Queue.Item> buildableItemsOnNode = new ArrayList<Queue.Item>();
        for (Queue.Item buildableItem : Jenkins.get().getQueue().getItems()) {
            Label assignedLabel = buildableItem.getAssignedLabel();
            if (assignedLabel != null && !assignedLabel.contains(node)) continue;
            buildableItemsOnNode.add(buildableItem);
        }
        Job buildableItem = this.checkForPlannedBuilds(item, buildableItemsOnNode);
        if (buildableItem != null) {
            LOG.logp(Level.FINE, this.getClass().getName(), "checkNodeForQueueEntries", "build " + String.valueOf(item) + " blocked by queued build " + String.valueOf(buildableItem));
            return buildableItem;
        }
        return null;
    }

    public Job checkAllNodesForRunningBuilds() {
        Computer[] computers;
        for (Computer computer : computers = Jenkins.get().getComputers()) {
            Job task = this.checkComputerForRunningBuilds(computer);
            if (task == null) continue;
            return task;
        }
        return null;
    }

    private Job checkComputerForRunningBuilds(Computer computer) {
        List executors = computer.getExecutors();
        executors.addAll(computer.getOneOffExecutors());
        for (Executor executor : executors) {
            Job task = this.checkForRunningBuilds(executor);
            if (task == null) continue;
            LOG.logp(Level.FINE, this.getClass().getName(), "checkComputerForRunningBuilds", "build blocked by running build " + String.valueOf(task));
            return task;
        }
        return null;
    }

    public Job checkNodeForRunningBuilds(Node node) {
        if (node == null) {
            return null;
        }
        return this.checkComputerForRunningBuilds(node.toComputer());
    }

    private Job checkForPlannedBuilds(Queue.Item item, List<? extends Queue.Item> buildableItems) {
        for (Queue.Item item2 : buildableItems) {
            if (item == item2) continue;
            for (String blockingJob : this.blockingJobs) {
                Job project;
                if (!(item2.task instanceof Job) || !(project = (Job)item2.task).getFullName().matches(blockingJob)) continue;
                return project;
            }
        }
        return null;
    }

    private Job checkForRunningBuilds(Executor executor) {
        if (executor.isBusy()) {
            WorkUnit unit = executor.getCurrentWorkUnit();
            if (unit == null) {
                return null;
            }
            Queue.Task task = unit.work.getOwnerTask();
            if (task instanceof MatrixConfiguration) {
                task = ((MatrixConfiguration)task).getParent();
            }
            if (task instanceof Job) {
                Job job = (Job)task;
                for (String blockingJob : this.blockingJobs) {
                    try {
                        if (!job.getFullName().matches(blockingJob)) continue;
                        return job;
                    }
                    catch (PatternSyntaxException pse) {
                    }
                }
            }
        }
        return null;
    }
}

