/*
 * Decompiled with CFR 0.152.
 */
package jenkins.bouncycastle.api;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.ChannelProperty;
import hudson.remoting.Future;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jenkins.bouncycastle.api.BcProviderRegistration;
import jenkins.bouncycastle.api.BouncyCastlePlugin;
import jenkins.bouncycastle.api.PEMEncodable;
import jenkins.security.MasterToSlaveCallable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class InstallBouncyCastleJCAProvider
extends MasterToSlaveCallable<Boolean, Exception> {
    private static final long serialVersionUID = 1L;
    private static final ChannelProperty<Future> BOUNCYCASTLE_REGISTERED = new ChannelProperty(Future.class, "Bouncy Castle Registered");
    private final boolean prioritize;

    private InstallBouncyCastleJCAProvider(boolean prioritize) {
        this.prioritize = prioritize;
    }

    @NonNull
    public Boolean call() throws Exception {
        BcProviderRegistration.register(this.prioritize);
        return Boolean.TRUE;
    }

    public static void on(@NonNull SlaveComputer c) throws IOException, InterruptedException {
        Channel channel = c.getChannel();
        if (channel == null) {
            throw new IOException("Remote agent is off-line");
        }
        InstallBouncyCastleJCAProvider.on(channel);
    }

    public static void on(@NonNull Channel channel) throws IOException, InterruptedException {
        if (!BouncyCastlePlugin.isActive()) {
            return;
        }
        Future future = (Future)channel.getProperty(BOUNCYCASTLE_REGISTERED);
        try {
            if (future != null) {
                future.get(1L, TimeUnit.MINUTES);
            } else {
                channel.preloadJar(PEMEncodable.class.getClassLoader(), new Class[]{BouncyCastleProvider.class});
                future = (Future)channel.getProperty(BOUNCYCASTLE_REGISTERED);
                if (future == null) {
                    future = channel.callAsync((Callable)new InstallBouncyCastleJCAProvider(BcProviderRegistration.PRIORITIZE));
                    channel.setProperty(BOUNCYCASTLE_REGISTERED, (Object)future);
                }
                future.get(1L, TimeUnit.MINUTES);
            }
        }
        catch (TimeoutException e) {
            throw new IOException("Remote operation timed out", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw new IOException(e);
            }
            if (e.getCause() instanceof SecurityException) {
                throw new SecurityException(e);
            }
            if (e.getCause() instanceof LinkageError) {
                throw new LinkageError("Could not register bouncy castle", e);
            }
            throw new IOException("Could not register bouncy castle", e);
        }
    }
}

