/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.bearychat;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.plugins.bearychat.ActiveNotifier;
import jenkins.plugins.bearychat.BearyChatService;
import jenkins.plugins.bearychat.StandardBearyChatService;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class BearyChatNotifier
extends Notifier {
    private static final Logger logger = Logger.getLogger(BearyChatNotifier.class.getName());
    private String webhook;
    private String buildServerUrl;
    private String channel;
    private String customStartMessage;
    private String customEndMessage;
    private boolean isNotifyOnStarting;
    private boolean isNotifyOnSuccess;
    private boolean isNotifyOnAborted;
    private boolean isNotifyOnNotBuilt;
    private boolean isNotifyOnUnstable;
    private boolean isNotifyOnFailure;
    private boolean isNotifyOnBackToNormal;
    private boolean isNotifyRepeatedFailure;
    private boolean isIncludeCustomMessage;

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getWebhook() {
        return this.webhook;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getBuildServerUrl() {
        if (StringUtils.isEmpty((String)this.buildServerUrl)) {
            JenkinsLocationConfiguration jenkinsConfig = new JenkinsLocationConfiguration();
            return jenkinsConfig.getUrl();
        }
        return this.buildServerUrl;
    }

    public boolean isNotifyOnStarting() {
        return this.isNotifyOnStarting;
    }

    public boolean isNotifyOnSuccess() {
        return this.isNotifyOnSuccess;
    }

    public boolean isNotifyOnAborted() {
        return this.isNotifyOnAborted;
    }

    public boolean isNotifyOnFailure() {
        return this.isNotifyOnFailure;
    }

    public boolean isNotifyOnNotBuilt() {
        return this.isNotifyOnNotBuilt;
    }

    public boolean isNotifyOnUnstable() {
        return this.isNotifyOnUnstable;
    }

    public boolean isNotifyOnBackToNormal() {
        return this.isNotifyOnBackToNormal;
    }

    public boolean isIncludeCustomMessage() {
        return this.isIncludeCustomMessage;
    }

    public String getCustomStartMessage() {
        return this.customStartMessage;
    }

    public String getCustomEndMessage() {
        return this.customEndMessage;
    }

    @DataBoundConstructor
    public BearyChatNotifier(String webhook, String channel, String buildServerUrl, boolean isNotifyOnStarting, boolean isNotifyOnAborted, boolean isNotifyOnFailure, boolean isNotifyOnNotBuilt, boolean isNotifyOnSuccess, boolean isNotifyOnUnstable, boolean isNotifyOnBackToNormal, boolean isIncludeCustomMessage, String customStartMessage, String customEndMessage) {
        this.webhook = webhook;
        this.buildServerUrl = buildServerUrl;
        this.channel = channel;
        this.isNotifyOnStarting = isNotifyOnStarting;
        this.isNotifyOnAborted = isNotifyOnAborted;
        this.isNotifyOnFailure = isNotifyOnFailure;
        this.isNotifyOnNotBuilt = isNotifyOnNotBuilt;
        this.isNotifyOnSuccess = isNotifyOnSuccess;
        this.isNotifyOnUnstable = isNotifyOnUnstable;
        this.isNotifyOnBackToNormal = isNotifyOnBackToNormal;
        this.isIncludeCustomMessage = isIncludeCustomMessage;
        this.customStartMessage = customStartMessage;
        this.customEndMessage = customEndMessage;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public BearyChatService newBearyChatService(AbstractBuild r, BuildListener listener) {
        String channel;
        String webhook = this.webhook;
        if (StringUtils.isEmpty((String)webhook)) {
            webhook = this.getDescriptor().getWebhook();
        }
        if (StringUtils.isEmpty((String)(channel = this.channel))) {
            channel = this.getDescriptor().getChannel();
        }
        EnvVars env = null;
        try {
            env = r.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            listener.getLogger().println("Error retrieving environment vars: " + e.getMessage());
            env = new EnvVars();
        }
        webhook = env.expand(webhook);
        channel = env.expand(channel);
        logger.info("webhook: " + webhook);
        return new StandardBearyChatService(webhook, channel);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        if (this.isNotifyOnStarting) {
            Map map = build.getProject().getPublishersList().toMap();
            for (Publisher publisher : map.values()) {
                if (!(publisher instanceof BearyChatNotifier)) continue;
                logger.info("Invoking Started...");
                new ActiveNotifier((BearyChatNotifier)publisher, listener).started(build);
            }
        }
        return super.prebuild(build, listener);
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String webhook;
        private String channel;
        private String buildServerUrl;

        public DescriptorImpl() {
            this.load();
        }

        public String getWebhook() {
            return this.webhook;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getBuildServerUrl() {
            if (StringUtils.isEmpty((String)this.buildServerUrl)) {
                JenkinsLocationConfiguration jenkinsConfig = new JenkinsLocationConfiguration();
                return jenkinsConfig.getUrl();
            }
            return this.buildServerUrl;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public BearyChatNotifier newInstance(StaplerRequest sr, JSONObject json) {
            String webhook = sr.getParameter("webhook");
            String channel = sr.getParameter("channel");
            boolean isNotifyOnStarting = "true".equals(sr.getParameter("isNotifyOnStarting"));
            boolean isNotifyOnSuccess = "true".equals(sr.getParameter("isNotifyOnSuccess"));
            boolean isNotifyOnAborted = "true".equals(sr.getParameter("isNotifyOnAborted"));
            boolean isNotifyOnNotBuilt = "true".equals(sr.getParameter("isNotifyOnNotBuilt"));
            boolean isNotifyOnUnstable = "true".equals(sr.getParameter("isNotifyOnUnstable"));
            boolean isNotifyOnFailure = "true".equals(sr.getParameter("isNotifyOnFailure"));
            boolean isNotifyOnBackToNormal = "true".equals(sr.getParameter("isNotifyOnBackToNormal"));
            boolean isIncludeCustomMessage = "on".equals(sr.getParameter("isIncludeCustomMessage"));
            String customStartMessage = sr.getParameter("customStartMessage");
            String customEndMessage = sr.getParameter("customEndMessage");
            return new BearyChatNotifier(webhook, channel, this.buildServerUrl, isNotifyOnStarting, isNotifyOnAborted, isNotifyOnFailure, isNotifyOnNotBuilt, isNotifyOnSuccess, isNotifyOnUnstable, isNotifyOnBackToNormal, isIncludeCustomMessage, customStartMessage, customEndMessage);
        }

        public boolean configure(StaplerRequest sr, JSONObject formData) throws Descriptor.FormException {
            this.webhook = sr.getParameter("webhook");
            this.channel = sr.getParameter("channel");
            this.buildServerUrl = sr.getParameter("buildServerUrl");
            if (StringUtils.isEmpty((String)this.buildServerUrl)) {
                JenkinsLocationConfiguration jenkinsConfig = new JenkinsLocationConfiguration();
                this.buildServerUrl = jenkinsConfig.getUrl();
            }
            if (this.buildServerUrl != null && !this.buildServerUrl.endsWith("/")) {
                this.buildServerUrl = this.buildServerUrl + "/";
            }
            this.save();
            return super.configure(sr, formData);
        }

        BearyChatService getBearyChatService(String webhook, String channel) {
            return new StandardBearyChatService(webhook, channel);
        }

        public String getDisplayName() {
            return "BearyChat Notifications";
        }

        public FormValidation doTestConnection(@QueryParameter(value="webhook") String webhook, @QueryParameter(value="channel") String channel, @QueryParameter(value="buildServerUrl") String buildServerUrl) throws Descriptor.FormException {
            try {
                String message;
                BearyChatService testBearyChatService;
                boolean success;
                String targetBuildServerUrl;
                String targetChannel;
                String targetWebhook = webhook;
                if (StringUtils.isEmpty((String)webhook)) {
                    targetWebhook = this.webhook;
                }
                if (StringUtils.isEmpty((String)(targetChannel = channel))) {
                    targetChannel = this.channel;
                }
                if (StringUtils.isEmpty((String)(targetBuildServerUrl = buildServerUrl))) {
                    targetBuildServerUrl = this.buildServerUrl;
                }
                return (success = (testBearyChatService = this.getBearyChatService(targetWebhook, targetChannel)).publish(message = "BearyChat Jenkins Plugin has been configured correctly. " + targetBuildServerUrl)) ? FormValidation.ok((String)"Success") : FormValidation.error((String)"Failure");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }
    }
}

