/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.azurekeyvaultplugin;

import com.azure.security.keyvault.secrets.SecretClient;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.microsoft.azure.util.AzureBaseCredentials;
import com.microsoft.azure.util.AzureCredentials;
import com.microsoft.azure.util.AzureImdsCredentials;
import com.microsoft.jenkins.keyvault.SecretClientCache;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Item;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureCredentialsProvider;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureKeyVaultUtil;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"azureKeyVault"})
public class AzureKeyVaultGlobalConfiguration
extends GlobalConfiguration {
    public static final String GENERATED_ID = "azure-keyvault-autogenerated";
    private static final Logger LOG = Logger.getLogger(AzureKeyVaultGlobalConfiguration.class.getName());
    private static final String GENERATED_DESCRIPTION = "Auto generated credential from environment";
    private String keyVaultURL;
    private String credentialID;

    public AzureKeyVaultGlobalConfiguration() {
        this.load();
    }

    public String getKeyVaultURL() {
        this.resolveKeyVaultUrlFromEnvironment().ifPresent(url -> {
            this.keyVaultURL = url;
            this.save();
        });
        return this.keyVaultURL;
    }

    @DataBoundSetter
    public void setKeyVaultURL(String keyVaultURL) {
        this.keyVaultURL = keyVaultURL;
        this.save();
        this.refresh();
    }

    private void refresh() {
        AzureCredentialsProvider azureCredentialsProvider = (AzureCredentialsProvider)((Object)ExtensionList.lookupSingleton(AzureCredentialsProvider.class));
        azureCredentialsProvider.refreshCredentials();
    }

    public String getCredentialID() {
        this.resolveCredentialIdFromEnvironment().ifPresent(id -> {
            this.credentialID = id;
            this.save();
        });
        return this.credentialID;
    }

    private Optional<String> resolveKeyVaultUrlFromEnvironment() {
        Optional<String> url = this.getPropertyByEnvOrSystemProperty("AZURE_KEYVAULT_URL", "jenkins.azure-keyvault.url");
        if (url.isPresent() && url.get().equals(this.keyVaultURL)) {
            return Optional.empty();
        }
        return url;
    }

    private Optional<String> resolveCredentialIdFromEnvironment() {
        Optional<Credentials> optionalCredentials = SystemCredentialsProvider.getInstance().getCredentials().stream().filter(credentials -> (credentials instanceof AzureCredentials || credentials instanceof AzureImdsCredentials) && ((IdCredentials)credentials).getId().equals(GENERATED_ID)).findAny();
        boolean isUami = this.getPropertyByEnvOrSystemProperty("AZURE_KEYVAULT_UAMI_ENABLED", "jenkins.azure-keyvault.uami.enabled").map(u -> "true".equals(u)).orElse(false);
        CredentialsScope scope = this.getPropertyByEnvOrSystemProperty("AZURE_KEYVAULT_SP_SCOPE", "jenkins.azure-keyvault.sp.scope").map(s -> "SYSTEM".equalsIgnoreCase((String)s) ? CredentialsScope.SYSTEM : CredentialsScope.GLOBAL).orElse(CredentialsScope.GLOBAL);
        if (isUami) {
            if (optionalCredentials.filter(c -> c instanceof AzureImdsCredentials && scope.equals((Object)c.getScope())).isPresent()) {
                return Optional.empty();
            }
            AzureImdsCredentials credentials2 = new AzureImdsCredentials(scope, GENERATED_ID, GENERATED_DESCRIPTION);
            this.storeCredential((AzureBaseCredentials)credentials2);
            return Optional.of(credentials2.getId());
        }
        String clientId = this.getPropertyByEnvOrSystemProperty("AZURE_KEYVAULT_SP_CLIENT_ID", "jenkins.azure-keyvault.sp.client_id").orElse("false");
        if (clientId.equals("false")) {
            return Optional.empty();
        }
        String clientSecret = this.getPropertyByEnvOrSystemProperty("AZURE_KEYVAULT_SP_CLIENT_SECRET", "jenkins.azure-keyvault.sp.client_secret").orElseGet(() -> this.getPropertyByFile("AZURE_KEYVAULT_SP_CLIENT_SECRET_FILE", "jenkins.azure-keyvault.sp.client_secret_file").orElseThrow(IllegalArgumentException::new));
        String subscriptionId = this.getPropertyByEnvOrSystemProperty("AZURE_KEYVAULT_SP_SUBSCRIPTION_ID", "jenkins.azure-keyvault.sp.subscription_id").orElseThrow(IllegalArgumentException::new);
        String tenantId = this.getPropertyByEnvOrSystemProperty("AZURE_KEYVAULT_SP_TENANT_ID", "jenkins.azure-keyvault.sp.tenant_id").orElseThrow(IllegalArgumentException::new);
        if (optionalCredentials.isPresent() && optionalCredentials.get() instanceof AzureCredentials && this.azureCredentialIsEqual((AzureCredentials)optionalCredentials.get(), clientId, clientSecret, subscriptionId, tenantId, scope)) {
            return Optional.empty();
        }
        AzureCredentials azureCredentials = new AzureCredentials(scope, GENERATED_ID, GENERATED_DESCRIPTION, subscriptionId, clientId, clientSecret);
        azureCredentials.setTenant(tenantId);
        this.storeCredential((AzureBaseCredentials)azureCredentials);
        return Optional.of(azureCredentials.getId());
    }

    private boolean azureCredentialIsEqual(AzureCredentials creds, String clientId, String clientSecret, String subscriptionId, String tenantId, CredentialsScope scope) {
        return StringUtils.equals((CharSequence)creds.getClientId(), (CharSequence)clientId) && StringUtils.equals((CharSequence)creds.getPlainClientSecret(), (CharSequence)clientSecret) && StringUtils.equals((CharSequence)creds.getSubscriptionId(), (CharSequence)subscriptionId) && StringUtils.equals((CharSequence)creds.getTenant(), (CharSequence)tenantId) && ObjectUtils.equals((Object)creds.getScope(), (Object)scope);
    }

    private Optional<String> getPropertyByEnvOrSystemProperty(String envVariable, String systemProperty) {
        String envResult = System.getenv(envVariable);
        if (envResult != null) {
            return Optional.of(envResult);
        }
        String systemResult = System.getProperty(systemProperty);
        if (systemResult != null) {
            return Optional.of(systemResult);
        }
        return Optional.empty();
    }

    private Optional<String> getPropertyByFile(String envVariable, String systemProperty) {
        String envResult = System.getenv(envVariable);
        if (envResult != null) {
            Path pathToSecret = Paths.get(envResult, new String[0]);
            try {
                return Optional.of(Files.readAllLines(pathToSecret).get(0));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        String systemResult = System.getProperty(systemProperty);
        if (systemResult != null) {
            Path pathToSecret = Paths.get(systemResult, new String[0]);
            try {
                return Optional.of(Files.readAllLines(pathToSecret).get(0));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return Optional.empty();
    }

    private void storeCredential(AzureBaseCredentials credentials) {
        SystemCredentialsProvider instance = SystemCredentialsProvider.getInstance();
        for (int i = 0; i < instance.getCredentials().size(); ++i) {
            IdCredentials idCredentials;
            Credentials cred = (Credentials)instance.getCredentials().get(i);
            if (!(cred instanceof IdCredentials) || !(idCredentials = (IdCredentials)cred).getId().equals(credentials.getId())) continue;
            instance.getCredentials().remove(i);
            break;
        }
        instance.getCredentials().add(credentials);
        try {
            instance.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @DataBoundSetter
    public void setCredentialID(String credentialID) {
        this.credentialID = credentialID;
        this.save();
        this.refresh();
    }

    @POST
    public FormValidation doReloadCache() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (StringUtils.isBlank((CharSequence)this.keyVaultURL)) {
            return FormValidation.error((String)"Key vault url is required");
        }
        if (StringUtils.isBlank((CharSequence)this.credentialID)) {
            return FormValidation.error((String)"Credential ID is required");
        }
        this.refresh();
        return FormValidation.ok((String)"Cache reloaded");
    }

    @POST
    public FormValidation doTestConnection(@QueryParameter(value="keyVaultURL") String keyVaultURL, @QueryParameter(value="credentialID") String credentialID) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (StringUtils.isBlank((CharSequence)keyVaultURL)) {
            return FormValidation.error((String)"Key vault url is required");
        }
        if (StringUtils.isBlank((CharSequence)credentialID)) {
            return FormValidation.error((String)"Credential ID is required");
        }
        try {
            SecretClient client = SecretClientCache.get((String)credentialID, (String)keyVaultURL);
            Long numberOfSecrets = client.listPropertiesOfSecrets().stream().count();
            return FormValidation.ok((String)String.format("Success, found %d secrets in the vault", numberOfSecrets));
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Failed testing connection", e);
            return FormValidation.error((Throwable)e, (String)e.getMessage());
        }
    }

    @POST
    public ListBoxModel doFillCredentialIDItems(@AncestorInPath Item context) {
        return AzureKeyVaultUtil.doFillCredentialIDItems(context);
    }

    public static AzureKeyVaultGlobalConfiguration get() {
        return (AzureKeyVaultGlobalConfiguration)((Object)ExtensionList.lookupSingleton(AzureKeyVaultGlobalConfiguration.class));
    }
}

