/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.awsdevicefarm;

import com.amazonaws.services.devicefarm.model.ExecutionResult;
import com.amazonaws.services.devicefarm.model.Run;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import hudson.util.ChartUtil;
import hudson.util.Graph;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.WordUtils;
import org.jenkinsci.plugins.awsdevicefarm.AWSDeviceFarmGraph;
import org.jenkinsci.plugins.awsdevicefarm.AWSDeviceFarmTestResultAction;
import org.jenkinsci.plugins.awsdevicefarm.AWSDeviceFarmUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class AWSDeviceFarmTestResult
extends TestResult {
    private static final HashMap<ExecutionResult, Result> resultMap = new HashMap();
    private static final int DefaultTrendGraphSize = 3;
    private String id = "";
    private String status = "";
    private ExecutionResult result;
    private int passCount = 0;
    private int warnCount = 0;
    private int failCount = 0;
    private int totalCount = 0;
    private int errorCount = 0;
    private int skipCount = 0;
    private int stopCount = 0;
    private int duration = 0;
    private String url = "";
    private String project = "";
    private AbstractBuild<?, ?> build;

    public AWSDeviceFarmTestResult(AbstractBuild<?, ?> build, Run run) {
        this.build = build;
        if (run != null) {
            this.id = AWSDeviceFarmUtils.getRunIdFromArn(run.getArn());
            this.status = run.getStatus();
            this.result = ExecutionResult.fromValue((String)run.getResult());
            this.passCount = run.getCounters().getPassed();
            this.warnCount = run.getCounters().getWarned();
            this.failCount = run.getCounters().getFailed();
            this.totalCount = run.getCounters().getTotal();
            this.errorCount = run.getCounters().getErrored();
            this.skipCount = run.getCounters().getSkipped();
            try {
                this.stopCount = run.getCounters().getStopped();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.url = AWSDeviceFarmUtils.getRunUrlFromArn(run.getArn());
        }
    }

    public void doGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        Calendar timestamp;
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(String.format("%s/images/headless.png", request.getContextPath()));
            return;
        }
        if (this.isCompleted().booleanValue() && request.checkIfModified(timestamp = this.getOwner().getTimestamp(), response)) {
            return;
        }
        Graph graph = AWSDeviceFarmGraph.createResultTrendGraph(this.build, this.isCompleted(), this.getPreviousResults(3));
        graph.doPng(request, response);
    }

    public void doDurationGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        Calendar timestamp;
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(String.format("%s/images/headless.png", request.getContextPath()));
            return;
        }
        if (this.isCompleted().booleanValue() && request.checkIfModified(timestamp = this.getOwner().getTimestamp(), response)) {
            return;
        }
        Graph graph = AWSDeviceFarmGraph.createDurationTrendGraph(this.build, this.isCompleted(), this.getPreviousResults(3));
        graph.doPng(request, response);
    }

    public AWSDeviceFarmTestResult getPreviousResult() {
        AWSDeviceFarmTestResultAction prev = AWSDeviceFarmUtils.previousAWSDeviceFarmBuildAction(this.build.getProject());
        if (prev == null) {
            return null;
        }
        return prev.getResult();
    }

    protected List<AWSDeviceFarmTestResult> getPreviousResults(int n) {
        List<AWSDeviceFarmTestResult> results = this.getPreviousResults();
        return results.subList(Math.max(0, results.size() - n), results.size());
    }

    protected List<AWSDeviceFarmTestResult> getPreviousResults() {
        ArrayList<AWSDeviceFarmTestResultAction> actions = AWSDeviceFarmUtils.previousAWSDeviceFarmBuilds(this.build.getProject());
        ArrayList<AWSDeviceFarmTestResult> results = new ArrayList<AWSDeviceFarmTestResult>();
        for (AWSDeviceFarmTestResultAction action : actions) {
            AWSDeviceFarmTestResult result = action.getResult();
            if (result == null) continue;
            results.add(result);
        }
        Collections.reverse(results);
        return results;
    }

    public String getReportUrl() {
        return this.url;
    }

    public String getRunId() {
        return this.id;
    }

    public String getBuildNumber() {
        return "" + this.build.getNumber();
    }

    public String getStatus() {
        return WordUtils.capitalizeFully((String)this.status);
    }

    public String getProject() {
        return this.project;
    }

    public Boolean isCompleted() {
        return this.status != null && this.status.equalsIgnoreCase("COMPLETED");
    }

    public Result getBuildResult(Boolean ignoreRunError) {
        if (ignoreRunError != null && ignoreRunError.booleanValue() && ExecutionResult.ERRORED.equals((Object)this.result)) {
            this.result = this.skipCount > 0 ? ExecutionResult.SKIPPED : (this.stopCount > 0 ? ExecutionResult.STOPPED : (this.failCount > 0 ? ExecutionResult.FAILED : (this.warnCount > 0 ? ExecutionResult.WARNED : ExecutionResult.PASSED)));
        }
        if (!ExecutionResult.ERRORED.equals((Object)this.result) && this.skipCount > 0) {
            this.result = ExecutionResult.SKIPPED;
        }
        return resultMap.get(this.result);
    }

    public TestResult findCorrespondingResult(String id) {
        if (id == null || this.getId().equalsIgnoreCase(id)) {
            return this;
        }
        ArrayList<AWSDeviceFarmTestResultAction> prevActions = AWSDeviceFarmUtils.previousAWSDeviceFarmBuilds(this.build.getProject());
        if (prevActions == null || prevActions.isEmpty()) {
            return null;
        }
        for (AWSDeviceFarmTestResultAction action : prevActions) {
            AWSDeviceFarmTestResult prevResult = action.getResult();
            if (prevResult == null || !prevResult.getId().equalsIgnoreCase(id)) continue;
            return prevResult;
        }
        return null;
    }

    public int getPassCount() {
        return this.passCount;
    }

    public int getWarnCount() {
        return this.warnCount;
    }

    public int getFailCount() {
        return this.failCount;
    }

    public int getStopCount() {
        return this.stopCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public float getDuration() {
        return this.duration;
    }

    public Boolean isEmpty() {
        return this.getTotalCount() == 0;
    }

    public TestObject getParent() {
        return null;
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.build;
    }

    public String getDisplayName() {
        return String.format("AWS Device Farm #%s", this.id);
    }

    public String getName() {
        return String.format("AWSDeviceFarm%s", this.id);
    }

    public String getSearchUrl() {
        return "aws-device-farm";
    }

    static {
        resultMap.put(ExecutionResult.PASSED, Result.SUCCESS);
        resultMap.put(ExecutionResult.WARNED, Result.UNSTABLE);
        resultMap.put(ExecutionResult.FAILED, Result.FAILURE);
        resultMap.put(ExecutionResult.SKIPPED, Result.FAILURE);
        resultMap.put(ExecutionResult.ERRORED, Result.FAILURE);
        resultMap.put(ExecutionResult.STOPPED, Result.FAILURE);
    }
}

