/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.awsdevicefarm;

import com.amazonaws.services.devicefarm.model.GetRunResult;
import com.amazonaws.services.devicefarm.model.Run;
import com.amazonaws.services.devicefarm.model.ScheduleRunResult;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.PrintStream;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.awsdevicefarm.AWSDeviceFarm;
import org.jenkinsci.plugins.awsdevicefarm.AWSDeviceFarmTestResult;
import org.jenkinsci.plugins.awsdevicefarm.AWSDeviceFarmUtils;
import org.kohsuke.stapler.StaplerProxy;

public class AWSDeviceFarmTestResultAction
extends AbstractTestResultAction<AWSDeviceFarmTestResultAction>
implements StaplerProxy {
    private static final int DefaultUpdateInterval = 30000;
    private AWSDeviceFarmTestResult result;

    public AWSDeviceFarmTestResultAction(AbstractBuild<?, ?> owner, AWSDeviceFarmTestResult result) {
        super(owner);
        this.result = result;
    }

    public AWSDeviceFarmTestResultAction(hudson.model.Run<?, ?> owner, AWSDeviceFarmTestResult result) {
        this.onAttached(owner);
        this.result = result;
    }

    @Deprecated
    public AWSDeviceFarmTestResultAction(AbstractBuild<?, ?> owner, AWSDeviceFarmTestResult result, @CheckForNull PrintStream log) {
        this(owner, result);
    }

    public Result getBuildResult(Boolean ignoreRunError) {
        return this.getResult().getBuildResult(ignoreRunError);
    }

    public void waitForRunCompletion(AWSDeviceFarm adf, ScheduleRunResult runResult) throws InterruptedException {
        this.waitForRunCompletion(adf, runResult, TaskListener.NULL);
    }

    public void waitForRunCompletion(AWSDeviceFarm adf, ScheduleRunResult runResult, TaskListener listener) throws InterruptedException {
        PrintStream log = listener.getLogger();
        while (true) {
            GetRunResult latestRunResult = adf.describeRun(runResult.getRun().getArn());
            Run run = latestRunResult.getRun();
            this.result = new AWSDeviceFarmTestResult(this.owner, run);
            this.writeToLog(log, String.format("Run %s status %s", run.getName(), run.getStatus()));
            if (this.result.isCompleted().booleanValue()) break;
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex) {
                this.writeToLog(log, String.format("Thread interrupted while waiting for the Run to complete", new Object[0]));
                throw ex;
            }
        }
    }

    public AWSDeviceFarmTestResultAction getPreviousResult() {
        AbstractBuild<?, ?> build = this.getOwner();
        if (this.owner == null) {
            return null;
        }
        return AWSDeviceFarmUtils.previousAWSDeviceFarmBuildAction(build.getProject());
    }

    public AWSDeviceFarmTestResult getResult() {
        return this.result;
    }

    public AWSDeviceFarmTestResult getTarget() {
        return this.getResult();
    }

    public int getFailCount() {
        AWSDeviceFarmTestResult result = this.getResult();
        if (result != null) {
            return this.getResult().getFailCount();
        }
        return -1;
    }

    public int getTotalCount() {
        AWSDeviceFarmTestResult result = this.getResult();
        if (result != null) {
            return this.getResult().getTotalCount();
        }
        return -1;
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public String getUrlName() {
        return "aws-device-farm";
    }

    public String getDisplayName() {
        return "AWS Device Farm";
    }

    public String getIconFileName() {
        return "/plugin/aws-device-farm/service-icon.svg";
    }

    private void writeToLog(PrintStream log, String message) {
        if (log != null) {
            log.println(String.format("[AWSDeviceFarm] %s", message));
        }
    }
}

