/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.awsdevicefarm;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.devicefarm.model.Artifact;
import com.amazonaws.services.devicefarm.model.ArtifactCategory;
import com.amazonaws.services.devicefarm.model.BillingMethod;
import com.amazonaws.services.devicefarm.model.DeviceFilter;
import com.amazonaws.services.devicefarm.model.DevicePool;
import com.amazonaws.services.devicefarm.model.DeviceSelectionConfiguration;
import com.amazonaws.services.devicefarm.model.Job;
import com.amazonaws.services.devicefarm.model.ListArtifactsResult;
import com.amazonaws.services.devicefarm.model.ListJobsResult;
import com.amazonaws.services.devicefarm.model.ListSuitesResult;
import com.amazonaws.services.devicefarm.model.ListTestsResult;
import com.amazonaws.services.devicefarm.model.Location;
import com.amazonaws.services.devicefarm.model.Project;
import com.amazonaws.services.devicefarm.model.Radios;
import com.amazonaws.services.devicefarm.model.ScheduleRunConfiguration;
import com.amazonaws.services.devicefarm.model.ScheduleRunResult;
import com.amazonaws.services.devicefarm.model.ScheduleRunTest;
import com.amazonaws.services.devicefarm.model.ServiceAccountException;
import com.amazonaws.services.devicefarm.model.Suite;
import com.amazonaws.services.devicefarm.model.Test;
import com.amazonaws.services.devicefarm.model.TestType;
import com.amazonaws.services.devicefarm.model.Upload;
import com.amazonaws.services.devicefarm.model.VPCEConfiguration;
import com.amazonaws.services.devicefarm.model.VpcConfig;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.awsdevicefarm.AWSDeviceFarm;
import org.jenkinsci.plugins.awsdevicefarm.AWSDeviceFarmException;
import org.jenkinsci.plugins.awsdevicefarm.AWSDeviceFarmProjectAction;
import org.jenkinsci.plugins.awsdevicefarm.AWSDeviceFarmTestResultAction;
import org.jenkinsci.plugins.awsdevicefarm.AWSDeviceFarmUtils;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumJavaJUnitTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumJavaTestNGTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumNodeTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumPythonTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumRubyTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumWebJavaJUnitTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumWebJavaTestNGTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumWebNodeTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumWebPythonTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumWebRubyTest;
import org.jenkinsci.plugins.awsdevicefarm.test.CalabashTest;
import org.jenkinsci.plugins.awsdevicefarm.test.InstrumentationTest;
import org.jenkinsci.plugins.awsdevicefarm.test.UIAutomationTest;
import org.jenkinsci.plugins.awsdevicefarm.test.UIAutomatorTest;
import org.jenkinsci.plugins.awsdevicefarm.test.XCTestTest;
import org.jenkinsci.plugins.awsdevicefarm.test.XCTestUITest;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class AWSDeviceFarmRecorder
extends Recorder
implements SimpleBuildStep {
    public String projectName;
    public String devicePoolName;
    public String appArtifact;
    public String runName;
    public String testToRun;
    public String testSpecName;
    public String environmentToRun;
    public Boolean storeResults;
    public String resultsPath;
    public Boolean archiveResults;
    public Boolean isRunUnmetered;
    public String eventCount;
    public String eventThrottle;
    public String seed;
    public String username;
    public String password;
    public String appiumJavaJUnitTest;
    public String appiumJavaTestNGTest;
    public String appiumPythonTest;
    public String appiumRubyTest;
    public String appiumNodeTest;
    public String calabashFeatures;
    public String calabashTags;
    public String calabashProfile;
    public String junitArtifact;
    public String junitFilter;
    public String uiautomatorArtifact;
    public String uiautomatorFilter;
    public String uiautomationArtifact;
    public String xctestArtifact;
    public String xctestFilter;
    public String xctestUiArtifact;
    public String xctestUiFilter;
    public Boolean ignoreRunError;
    public Boolean ifWebApp;
    public String appiumVersionJunit;
    public String appiumVersionPython;
    public String appiumVersionTestng;
    private static final String APPIUM_VERSION_1_9_1 = "1.9.1";
    private static final String APPIUM_VERSION_1_7_2 = "1.7.2";
    private static final String APPIUM_VERSION_1_7_1 = "1.7.1";
    private static final String APPIUM_VERSION_1_6_3 = "1.6.3";
    private static final String APPIUM_VERSION_1_6_5 = "1.6.5";
    private static final String APPIUM_VERSION_1_4_16 = "1.4.16";
    public Boolean extraData;
    public String extraDataArtifact;
    public String vpceServiceName;
    public Boolean ifVpce;
    public Boolean deviceLocation;
    public Double deviceLatitude;
    public Double deviceLongitude;
    public Boolean radioDetails;
    public Boolean ifWifi;
    public Boolean ifGPS;
    public Boolean ifNfc;
    public Boolean ifBluetooth;
    public Integer jobTimeoutMinutes;
    private static final int MIN_EXECUTION_TIMEOUT = 5;
    private static final int MAX_EXECUTION_TIMEOUT = 600;
    private static final String STANDARD_ENVIRONMENT = "StandardEnvironment";
    private static final String CUSTOM_ENVIRONMENT = "CustomEnvironment";
    public Boolean ifVideoRecording;
    public Boolean ifAppPerformanceMonitoring;
    public Boolean ifSkipAppResigning;
    public String deviceSelectionFilters;
    public Integer maxDevicesForDeviceFilters;
    Boolean deviceLocaleFlag;
    public String deviceLocale;
    private static final String DEFAULT_DEVICE_LOCALE = "en_US";

    @DataBoundConstructor
    public AWSDeviceFarmRecorder(String projectName, String devicePoolName, String testSpecName, String environmentToRun, String appArtifact, String runName, @Nonnull String testToRun, Boolean storeResults, String resultsPath, Boolean archiveResults, Boolean isRunUnmetered, String eventCount, String eventThrottle, String seed, String username, String password, String appiumJavaJUnitTest, String appiumJavaTestNGTest, String appiumPythonTest, String appiumRubyTest, String appiumNodeTest, String calabashFeatures, String calabashTags, String calabashProfile, String junitArtifact, String junitFilter, String uiautomatorArtifact, String uiautomatorFilter, String uiautomationArtifact, String xctestArtifact, String xctestFilter, String xctestUiArtifact, String xctestUiFilter, String appiumVersionJunit, String appiumVersionPython, String appiumVersionTestng, Boolean ifWebApp, Boolean extraData, String extraDataArtifact, Boolean deviceLocation, Double deviceLatitude, Double deviceLongitude, Boolean radioDetails, Boolean ifBluetooth, Boolean ifWifi, Boolean ifGPS, Boolean ifNfc, Integer jobTimeoutMinutes, Boolean ifVideoRecording, Boolean ifAppPerformanceMonitoring, Boolean ignoreRunError, Boolean ifVpce, Boolean ifSkipAppResigning, String vpceServiceName, String deviceSelectionFilters, Integer maxDevicesForDeviceFilters, Boolean deviceLocaleFlag, String deviceLocale) {
        this.projectName = projectName;
        this.devicePoolName = devicePoolName;
        this.testSpecName = testSpecName;
        this.environmentToRun = environmentToRun;
        this.appArtifact = appArtifact;
        this.runName = runName;
        this.storeResults = storeResults;
        this.resultsPath = resultsPath;
        this.archiveResults = archiveResults;
        this.isRunUnmetered = isRunUnmetered;
        this.eventCount = eventCount;
        this.eventThrottle = eventThrottle;
        this.seed = seed;
        this.username = username;
        this.password = password;
        this.appiumJavaJUnitTest = appiumJavaJUnitTest;
        this.appiumJavaTestNGTest = appiumJavaTestNGTest;
        this.appiumPythonTest = appiumPythonTest;
        this.appiumRubyTest = appiumRubyTest;
        this.appiumNodeTest = appiumNodeTest;
        this.calabashFeatures = calabashFeatures;
        this.calabashTags = calabashTags;
        this.calabashProfile = calabashProfile;
        this.junitArtifact = junitArtifact;
        this.junitFilter = junitFilter;
        this.uiautomatorArtifact = uiautomatorArtifact;
        this.uiautomatorFilter = uiautomatorFilter;
        this.uiautomationArtifact = uiautomationArtifact;
        this.xctestArtifact = xctestArtifact;
        this.xctestFilter = xctestFilter;
        this.xctestUiArtifact = xctestUiArtifact;
        this.xctestUiFilter = xctestUiFilter;
        this.ignoreRunError = ignoreRunError;
        this.appiumVersionJunit = appiumVersionJunit;
        this.appiumVersionPython = appiumVersionPython;
        this.appiumVersionTestng = appiumVersionTestng;
        this.extraData = extraData;
        this.extraDataArtifact = extraDataArtifact;
        this.vpceServiceName = vpceServiceName;
        this.deviceLocation = deviceLocation;
        this.deviceLatitude = deviceLatitude;
        this.deviceLongitude = deviceLongitude;
        this.ifVpce = ifVpce;
        this.ifSkipAppResigning = ifSkipAppResigning;
        this.radioDetails = radioDetails;
        this.ifWifi = ifWifi;
        this.ifGPS = ifGPS;
        this.ifBluetooth = ifBluetooth;
        this.ifNfc = ifNfc;
        this.jobTimeoutMinutes = jobTimeoutMinutes;
        this.ifVideoRecording = ifVideoRecording;
        this.ifAppPerformanceMonitoring = ifAppPerformanceMonitoring;
        this.ifWebApp = ifWebApp;
        this.testToRun = this.transformTestToRunForWebApp(testToRun);
        this.deviceSelectionFilters = deviceSelectionFilters;
        this.maxDevicesForDeviceFilters = maxDevicesForDeviceFilters;
        this.deviceLocaleFlag = deviceLocaleFlag;
        this.deviceLocale = deviceLocale;
        Path pluginIconPath = Paths.get(System.getenv("HOME"), "plugins", "aws-device-farm", "service-icon.svg").toAbsolutePath();
        File pluginIcon = new File(pluginIconPath.toString());
        if (!pluginIcon.exists() || pluginIcon.isDirectory()) {
            System.out.println("Downloading service icon!");
            try {
                FileUtils.copyURLToFile((URL)new URL("http://g-ecx.images-amazon.com/images/G/01/aws-device-farm/service-icon.svg"), (File)pluginIcon);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private TestType stringToTestType(String testTypeName) {
        return TestType.valueOf((String)testTypeName.toUpperCase());
    }

    public String transformTestToRunForWebApp(@Nonnull String testToRun) {
        if (testToRun != null && this.ifWebApp.booleanValue()) {
            if (testToRun.equalsIgnoreCase("APPIUM_PYTHON")) {
                return "APPIUM_WEB_PYTHON";
            }
            if (testToRun.equalsIgnoreCase("APPIUM_JAVA_JUNIT")) {
                return "APPIUM_WEB_JAVA_JUNIT";
            }
            if (testToRun.equalsIgnoreCase("APPIUM_JAVA_TESTNG")) {
                return "APPIUM_WEB_JAVA_TESTNG";
            }
            if (testToRun.equalsIgnoreCase("APPIUM_RUBY")) {
                return "APPIUM_WEB_RUBY";
            }
            if (testToRun.equalsIgnoreCase("APPIUM_NODE")) {
                return "APPIUM_WEB_NODE";
            }
        }
        return testToRun;
    }

    public String isTestType(String testTypeName) {
        return this.testToRun.equalsIgnoreCase(testTypeName = this.transformTestToRunForWebApp(testTypeName)) ? "true" : "";
    }

    public String isStandardEnvironment(String environmentToRun) {
        if (this.environmentToRun == null) {
            return "true";
        }
        return this.environmentToRun.equals(environmentToRun) ? "true" : "";
    }

    public String isCustomEnvironment(String environmentToRun) {
        if (this.environmentToRun == null) {
            return "false";
        }
        return this.environmentToRun.equals(environmentToRun) ? "true" : "";
    }

    public Boolean accountHasVPC() {
        try {
            return this.getAWSDeviceFarm().getVPCEConfigurations() != null;
        }
        catch (ServiceAccountException e) {
            System.out.println("Account does not have a VPC configuration or is not whitelisted for VPC. Note: VPC is a private device only feature");
            return false;
        }
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        boolean isValid;
        Result buildResult = build.getResult();
        if (buildResult != null && buildResult.isWorseOrEqualTo(Result.FAILURE)) {
            listener.error("Still building");
        }
        EnvVars env = build.getEnvironment(listener);
        EnvVars parameters = build.getEnvironment(listener);
        PrintStream log = listener.getLogger();
        FilePath artifactsDir = new FilePath(build.getArtifactsDir());
        boolean bl = isValid = this.validateConfiguration(log) && this.validateTestConfiguration(log);
        if (!isValid) {
            this.writeToLog(log, "Invalid configuration.");
            build.setResult(Result.FAILURE);
            return;
        }
        AWSDeviceFarm adf = this.getAWSDeviceFarm().withLogger(listener.getLogger()).withWorkspace(workspace).withArtifactsDir(artifactsDir).withEnv(env);
        try {
            String devicePoolParameter;
            String projectNameParameter = (String)parameters.get("AWSDEVICEFARM_PROJECT");
            if (projectNameParameter != null && !projectNameParameter.isEmpty()) {
                this.writeToLog(log, String.format("Using overloaded project '%s' from build parameters", projectNameParameter));
                this.projectName = projectNameParameter;
            }
            if (this.isRunUnmetered != null && this.isRunUnmetered.booleanValue()) {
                int unmeteredDeviceCount = 0;
                if (this.ifWebApp != null && this.ifWebApp.booleanValue()) {
                    unmeteredDeviceCount = adf.getUnmeteredDevicesForWeb();
                    if (unmeteredDeviceCount <= 0) {
                        throw new AWSDeviceFarmException(String.format("Your account does not have unmetered android or ios device slots. Please change your build settings to run on metered devices.", new Object[0]));
                    }
                } else {
                    String os = adf.getOs(this.appArtifact);
                    unmeteredDeviceCount = adf.getUnmeteredDevices(os);
                    if (unmeteredDeviceCount <= 0) {
                        throw new AWSDeviceFarmException(String.format("Your account does not have unmetered %s device slots. Please change your build settings to run on metered devices.", os));
                    }
                }
            }
            this.writeToLog(log, String.format("Using Project '%s'", this.projectName));
            Project project = adf.getProject(this.projectName);
            DeviceSelectionConfiguration deviceSelectionConfig = null;
            ArrayList<DeviceFilter> deviceFilterList = null;
            DeviceFilter deviceFilter = null;
            String devicePoolArn = null;
            if (this.deviceSelectionFilters != null && !this.deviceSelectionFilters.isEmpty() && this.maxDevicesForDeviceFilters != null && this.maxDevicesForDeviceFilters > 0) {
                deviceSelectionConfig = new DeviceSelectionConfiguration();
                deviceFilterList = new ArrayList<DeviceFilter>();
                String deviceSelectionStr = null;
                deviceSelectionStr = String.format("%s", env.expand(this.deviceSelectionFilters));
                Object[] deviceSelectionList = deviceSelectionStr.split(",");
                this.writeToLog(log, String.format("Using Device Selection Filters '%s'", Arrays.toString(deviceSelectionList)));
                for (Object deviceFilterString : deviceSelectionList) {
                    String[] filterElements = ((String)deviceFilterString).trim().split(" ", 3);
                    if (filterElements.length != 3) {
                        this.writeToLog(log, String.format("Invalid Device Selection Filter '%s'", deviceFilterString));
                        build.setResult(Result.FAILURE);
                        return;
                    }
                    deviceFilter = new DeviceFilter();
                    deviceFilter.setAttribute(filterElements[0]);
                    deviceFilter.setOperator(filterElements[1]);
                    ArrayList<String> testValues = new ArrayList<String>();
                    testValues.add(filterElements[2]);
                    deviceFilter.setValues(testValues);
                    deviceFilterList.add(deviceFilter);
                    this.writeToLog(log, String.format("Device Selection Filter List '%s'", deviceFilterList.toString()));
                }
                this.writeToLog(log, String.format("Updated Device Filters '%s'", deviceSelectionConfig.toString()));
                deviceSelectionConfig.setFilters(deviceFilterList);
                deviceSelectionConfig.setMaxDevices(this.maxDevicesForDeviceFilters);
            }
            if ((devicePoolParameter = (String)parameters.get("AWSDEVICEFARM_DEVICE_POOL")) != null) {
                this.writeToLog(log, String.format("Using overloaded device pool '%s' from build parameters", devicePoolParameter));
                this.devicePoolName = devicePoolParameter;
            }
            if (this.devicePoolName != null && !this.devicePoolName.isEmpty()) {
                devicePoolArn = adf.getDevicePool(project, this.devicePoolName).getArn();
                this.writeToLog(log, String.format("Using DevicePool '%s'", this.devicePoolName));
            }
            String appArn = null;
            if (this.ifWebApp != null && this.ifWebApp.booleanValue()) {
                this.writeToLog(log, "Tesing a Web App.");
            } else {
                this.writeToLog(log, String.format("Using App '%s'", env.expand(this.appArtifact)));
                Upload appUpload = adf.uploadApp(project, this.appArtifact);
                appArn = appUpload.getArn();
            }
            String deviceFarmRunName = null;
            deviceFarmRunName = StringUtils.isBlank((String)this.runName) ? String.format("%s", env.get((Object)"BUILD_TAG")) : String.format("%s", env.expand(this.runName));
            this.writeToLog(log, "Getting test to schedule.");
            ScheduleRunTest testToSchedule = this.getScheduleRunTest(env, adf, project, log);
            Boolean videoCapture = true;
            if (this.ifVideoRecording != null && !this.ifVideoRecording.booleanValue()) {
                videoCapture = false;
            }
            if (this.ifAppPerformanceMonitoring != null && !this.ifAppPerformanceMonitoring.booleanValue()) {
                testToSchedule.addParametersEntry("app_performance_monitoring", "false");
            }
            Boolean skipAppResign = false;
            if (this.ifSkipAppResigning != null && this.ifSkipAppResigning.booleanValue()) {
                skipAppResign = true;
            }
            if (this.testToRun.equalsIgnoreCase("APPIUM_JAVA_JUNIT")) {
                this.writeToLog(log, String.format("Using appium version: %s", this.appiumVersionJunit));
            } else if (this.testToRun.equalsIgnoreCase("APPIUM_WEB_JAVA_JUNIT")) {
                this.writeToLog(log, String.format("Using appium version: %s", this.appiumVersionJunit));
            } else if (this.testToRun.equalsIgnoreCase("APPIUM_JAVA_TESTNG")) {
                this.writeToLog(log, String.format("Using appium version: %s", this.appiumVersionTestng));
            } else if (this.testToRun.equalsIgnoreCase("APPIUM_WEB_JAVA_TESTNG")) {
                this.writeToLog(log, String.format("Using appium version: %s", this.appiumVersionTestng));
            } else if (this.testToRun.equalsIgnoreCase("APPIUM_PYTHON")) {
                this.writeToLog(log, String.format("Using appium version: %s", this.appiumVersionPython));
            } else if (this.testToRun.equalsIgnoreCase("APPIUM_WEB_PYTHON")) {
                this.writeToLog(log, String.format("Using appium version: %s", this.appiumVersionPython));
            }
            String extraDataArn = null;
            if (this.extraData != null && this.extraData.booleanValue()) {
                this.writeToLog(log, String.format("Using Extra Data '%s'", env.expand(this.extraDataArtifact)));
                Upload extraDataUpload = adf.uploadExtraData(project, this.extraDataArtifact);
                extraDataArn = extraDataUpload.getArn();
            }
            TestType testType = TestType.fromValue((String)testToSchedule.getType());
            this.writeToLog(log, String.format("Scheduling '%s' run '%s'", testType, deviceFarmRunName));
            ScheduleRunConfiguration configuration = this.getScheduleRunConfiguration(this.isRunUnmetered, this.deviceLocation, this.radioDetails, this.deviceLocaleFlag);
            this.writeToLog(log, String.format("Using device locale '%s'", this.deviceLocale));
            configuration.setExtraDataPackageArn(extraDataArn);
            if (this.ifVpce != null && this.ifVpce.booleanValue() && this.accountHasVPC().booleanValue()) {
                this.writeToLog(log, String.format("Using VPCE Configuartion '%s'", this.vpceServiceName));
                VPCEConfiguration vpceConfiguration = adf.getVPCEConfiguration(this.vpceServiceName);
                HashSet<String> vpceConfigurationArns = new HashSet<String>();
                vpceConfigurationArns.add(vpceConfiguration.getArn());
                configuration.setVpceConfigurationArns(vpceConfigurationArns);
            }
            ScheduleRunResult run = adf.scheduleRun(project.getArn(), deviceFarmRunName, appArn, devicePoolArn, testToSchedule, this.jobTimeoutMinutes, configuration, videoCapture, skipAppResign, deviceSelectionConfig);
            String runArn = run.getRun().getArn();
            try {
                this.writeToLog(log, String.format("View the %s run in the AWS Device Farm Console: %s", testType, AWSDeviceFarmUtils.getRunUrlFromArn(runArn)));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.writeToLog(log, String.format("Could not parse project ID and run ID from run ARN: %s", runArn));
            }
            AWSDeviceFarmTestResultAction action = new AWSDeviceFarmTestResultAction(build, null);
            build.addAction((Action)action);
            this.writeToLog(log, "Waiting for test run to complete.");
            action.waitForRunCompletion(adf, run);
            this.writeToLog(log, "Test run is complete.");
            if (this.storeResults.booleanValue()) {
                FilePath resultsRootDir = this.archiveResults == null || this.archiveResults != false ? artifactsDir : workspace;
                FilePath resultsDir = new FilePath(resultsRootDir, StringUtils.isBlank((String)this.resultsPath) ? "AWS Device Farm Results" : this.resultsPath);
                resultsDir.mkdirs();
                this.writeToLog(log, String.format("Storing AWS Device Farm results in directory %s", resultsDir));
                Map<String, FilePath> jobs = this.getJobs(adf, run, resultsDir);
                Map<String, FilePath> suites = this.getSuites(adf, run, jobs);
                Map<String, FilePath> tests = this.getTests(adf, run, suites);
                this.writeToLog(log, "Downloading AWS Device Farm results archive...");
                for (ArtifactCategory category : new ArrayList<ArtifactCategory>(Arrays.asList(ArtifactCategory.values()))) {
                    ListArtifactsResult result = adf.listArtifacts(run.getRun().getArn(), category);
                    for (Artifact artifact : result.getArtifacts()) {
                        String arn = artifact.getArn().split(":")[6];
                        String testArn = arn.substring(0, arn.lastIndexOf("/"));
                        String id = arn.substring(arn.lastIndexOf("/") + 1);
                        String extension = artifact.getExtension().replaceFirst("^\\.", "");
                        FilePath localArtifact = new FilePath(tests.get(testArn), String.format("%s-%s.%s", artifact.getName(), id, extension));
                        URL artifactUrl = new URL(artifact.getUrl());
                        localArtifact.copyFrom(artifactUrl);
                    }
                }
                this.writeToLog(log, String.format("Results archive saved in %s", resultsRootDir.getName()));
            }
            build.setResult(action.getBuildResult(this.ignoreRunError));
        }
        catch (AWSDeviceFarmException e) {
            this.writeToLog(log, e.getMessage());
            return;
        }
    }

    private Location getScheduleRunConfigurationLocation(Boolean deviceLocation) {
        Location location = new Location();
        if (deviceLocation != null && deviceLocation.booleanValue()) {
            location.setLatitude(this.deviceLatitude);
            location.setLongitude(this.deviceLongitude);
        } else {
            location.setLatitude(Double.valueOf(47.6204));
            location.setLongitude(Double.valueOf(-122.3491));
        }
        return location;
    }

    private Radios getScheduleRunConfigurationRadio(Boolean radioDetails) {
        Radios radio = new Radios();
        if (radioDetails != null && radioDetails.booleanValue()) {
            radio.setBluetooth(this.ifBluetooth);
            radio.setGps(this.ifGPS);
            radio.setNfc(this.ifNfc);
            radio.setWifi(this.ifWifi);
        } else {
            radio.setBluetooth(Boolean.valueOf(true));
            radio.setGps(Boolean.valueOf(true));
            radio.setNfc(Boolean.valueOf(true));
            radio.setWifi(Boolean.valueOf(true));
        }
        return radio;
    }

    private ScheduleRunConfiguration getScheduleRunConfiguration(Boolean isRunUnmetered, Boolean deviceLocation, Boolean radioDetails, Boolean deviceLocaleFlag) {
        ScheduleRunConfiguration configuration = new ScheduleRunConfiguration();
        if (isRunUnmetered != null && isRunUnmetered.booleanValue()) {
            configuration.setBillingMethod(BillingMethod.UNMETERED);
        } else {
            configuration.setBillingMethod(BillingMethod.METERED);
        }
        configuration.setAuxiliaryApps(new ArrayList());
        Location location = this.getScheduleRunConfigurationLocation(deviceLocation);
        configuration.setLocation(location);
        Radios radio = this.getScheduleRunConfigurationRadio(radioDetails);
        configuration.setRadios(radio);
        if (deviceLocaleFlag != null && deviceLocaleFlag.booleanValue()) {
            configuration.setLocale(this.deviceLocale);
        } else {
            configuration.setLocale(DEFAULT_DEVICE_LOCALE);
        }
        return configuration;
    }

    private Map<String, FilePath> getSuites(AWSDeviceFarm adf, ScheduleRunResult run, Map<String, FilePath> jobs) throws IOException, InterruptedException {
        HashMap<String, FilePath> suites = new HashMap<String, FilePath>();
        String runArn = run.getRun().getArn();
        Object[] components = runArn.split(":");
        components[5] = "job";
        for (Map.Entry<String, FilePath> jobEntry : jobs.entrySet()) {
            String jobArn;
            components[6] = jobArn = jobEntry.getKey();
            String fullJobArn = StringUtils.join((Object[])components, (String)":");
            ListSuitesResult result = adf.listSuites(fullJobArn);
            for (Suite suite : result.getSuites()) {
                String arn = suite.getArn().split(":")[6];
                suites.put(arn, new FilePath(jobs.get(jobArn), suite.getName()));
                ((FilePath)suites.get(arn)).mkdirs();
            }
        }
        return suites;
    }

    private Map<String, FilePath> getTests(AWSDeviceFarm adf, ScheduleRunResult run, Map<String, FilePath> suites) throws IOException, InterruptedException {
        HashMap<String, FilePath> tests = new HashMap<String, FilePath>();
        String runArn = run.getRun().getArn();
        Object[] components = runArn.split(":");
        components[5] = "suite";
        for (Map.Entry<String, FilePath> suiteEntry : suites.entrySet()) {
            String suiteArn;
            components[6] = suiteArn = suiteEntry.getKey();
            String fullsuiteArn = StringUtils.join((Object[])components, (String)":");
            ListTestsResult result = adf.listTests(fullsuiteArn);
            for (Test test : result.getTests()) {
                String arn = test.getArn().split(":")[6];
                tests.put(arn, new FilePath(suites.get(suiteArn), test.getName()));
                ((FilePath)tests.get(arn)).mkdirs();
            }
        }
        return tests;
    }

    private Map<String, FilePath> getJobs(AWSDeviceFarm adf, ScheduleRunResult run, FilePath resultsDir) throws IOException, InterruptedException {
        HashMap<String, FilePath> jobs = new HashMap<String, FilePath>();
        ListJobsResult result = adf.listJobs(run.getRun().getArn());
        for (Job job : result.getJobs()) {
            String arn = job.getArn().split(":")[6];
            String jobId = arn.substring(arn.lastIndexOf("/") + 1);
            String osVersion = null;
            if (job.getDevice() != null) {
                osVersion = job.getDevice().getOs();
            }
            jobs.put(arn, new FilePath(resultsDir, job.getName() + "-" + (osVersion != null ? osVersion : jobId)));
            ((FilePath)jobs.get(arn)).mkdirs();
        }
        return jobs;
    }

    private ScheduleRunTest getScheduleRunTest(EnvVars env, AWSDeviceFarm adf, Project project, PrintStream log) throws InterruptedException, IOException, AWSDeviceFarmException {
        ScheduleRunTest testToSchedule = null;
        TestType testType = this.stringToTestType(this.testToRun);
        switch (testType) {
            case BUILTIN_FUZZ: {
                HashMap<String, String> parameters = new HashMap<String, String>();
                if (this.eventCount != null && !this.eventCount.isEmpty()) {
                    parameters.put("event_count", this.eventCount);
                }
                if (this.eventThrottle != null && !this.eventThrottle.isEmpty()) {
                    parameters.put("throttle", this.eventThrottle);
                }
                if (this.seed != null && !this.seed.isEmpty()) {
                    parameters.put("seed", this.seed);
                }
                testToSchedule = new ScheduleRunTest().withType(testType).withParameters(parameters);
                break;
            }
            case BUILTIN_EXPLORER: {
                HashMap<String, String> parameters = new HashMap();
                if (this.username != null && !this.username.isEmpty()) {
                    parameters.put("username", this.username);
                }
                if (this.password != null && !this.password.isEmpty()) {
                    parameters.put("password", this.password);
                }
                testToSchedule = new ScheduleRunTest().withType(testType).withParameters(parameters);
                break;
            }
            case APPIUM_JAVA_JUNIT: {
                Object test = new AppiumJavaJUnitTest.Builder().withTests(env.expand(this.appiumJavaJUnitTest)).build();
                Upload upload = adf.uploadTest(project, (AppiumJavaJUnitTest)test);
                testToSchedule = new ScheduleRunTest().withType(testType).withTestPackageArn(upload.getArn());
                testToSchedule.addParametersEntry("appium_version", this.appiumVersionJunit);
                break;
            }
            case APPIUM_JAVA_TESTNG: {
                Object test = new AppiumJavaTestNGTest.Builder().withTests(env.expand(this.appiumJavaTestNGTest)).build();
                Upload upload = adf.uploadTest(project, (AppiumJavaTestNGTest)test);
                testToSchedule = new ScheduleRunTest().withType(testType).withTestPackageArn(upload.getArn());
                testToSchedule.addParametersEntry("appium_version", this.appiumVersionTestng);
                break;
            }
            case APPIUM_PYTHON: {
                Object test = new AppiumPythonTest.Builder().withTests(env.expand(this.appiumPythonTest)).build();
                Upload upload = adf.uploadTest(project, (AppiumPythonTest)test);
                testToSchedule = new ScheduleRunTest().withType(testType).withTestPackageArn(upload.getArn());
                testToSchedule.addParametersEntry("appium_version", this.appiumVersionPython);
                break;
            }
            case APPIUM_RUBY: {
                Object test = new AppiumRubyTest.Builder().withTests(env.expand(this.appiumRubyTest)).build();
                Upload upload = adf.uploadTest(project, (AppiumRubyTest)test);
                testToSchedule = new ScheduleRunTest().withType(testType).withTestPackageArn(upload.getArn());
                break;
            }
            case APPIUM_NODE: {
                Object test = new AppiumNodeTest.Builder().withTests(env.expand(this.appiumNodeTest)).build();
                Upload upload = adf.uploadTest(project, (AppiumNodeTest)test);
                testToSchedule = new ScheduleRunTest().withType(testType).withTestPackageArn(upload.getArn());
                break;
            }
            case APPIUM_WEB_JAVA_JUNIT: {
                Object test = new AppiumWebJavaJUnitTest.Builder().withTests(env.expand(this.appiumJavaJUnitTest)).build();
                Upload upload = adf.uploadTest(project, (AppiumWebJavaJUnitTest)test);
                testToSchedule = new ScheduleRunTest().withType(testType).withTestPackageArn(upload.getArn());
                testToSchedule.addParametersEntry("appium_version", this.appiumVersionJunit);
                break;
            }
            case APPIUM_WEB_JAVA_TESTNG: {
                Object test = new AppiumWebJavaTestNGTest.Builder().withTests(env.expand(this.appiumJavaTestNGTest)).build();
                Upload upload = adf.uploadTest(project, (AppiumWebJavaTestNGTest)test);
                testToSchedule = new ScheduleRunTest().withType(testType).withTestPackageArn(upload.getArn());
                testToSchedule.addParametersEntry("appium_version", this.appiumVersionTestng);
                break;
            }
            case APPIUM_WEB_PYTHON: {
                Object test = new AppiumWebPythonTest.Builder().withTests(env.expand(this.appiumPythonTest)).build();
                Upload upload = adf.uploadTest(project, (AppiumWebPythonTest)test);
                testToSchedule = new ScheduleRunTest().withType(testType).withTestPackageArn(upload.getArn());
                testToSchedule.addParametersEntry("appium_version", this.appiumVersionPython);
                break;
            }
            case APPIUM_WEB_RUBY: {
                Object test = new AppiumWebRubyTest.Builder().withTests(env.expand(this.appiumRubyTest)).build();
                Upload upload = adf.uploadTest(project, (AppiumWebRubyTest)test);
                testToSchedule = new ScheduleRunTest().withType(testType).withTestPackageArn(upload.getArn());
                break;
            }
            case APPIUM_WEB_NODE: {
                Object test = new AppiumWebNodeTest.Builder().withTests(env.expand(this.appiumNodeTest)).build();
                Upload upload = adf.uploadTest(project, (AppiumWebNodeTest)test);
                testToSchedule = new ScheduleRunTest().withType(testType).withTestPackageArn(upload.getArn());
                break;
            }
            case CALABASH: {
                Object test = new CalabashTest.Builder().withFeatures(env.expand(this.calabashFeatures)).withTags(env.expand(this.calabashTags)).withProfile(env.expand(this.calabashProfile)).build();
                Upload upload = adf.uploadTest(project, (CalabashTest)test);
                HashMap<String, String> parameters = new HashMap<String, String>();
                if (((CalabashTest)test).getTags() != null && !((CalabashTest)test).getTags().isEmpty()) {
                    parameters.put("tags", ((CalabashTest)test).getTags());
                }
                if (((CalabashTest)test).getProfile() != null && !((CalabashTest)test).getProfile().isEmpty()) {
                    parameters.put("profile", ((CalabashTest)test).getProfile());
                }
                testToSchedule = new ScheduleRunTest().withType(testType).withTestPackageArn(upload.getArn()).withParameters(parameters);
                break;
            }
            case INSTRUMENTATION: {
                Object test = new InstrumentationTest.Builder().withArtifact(env.expand(this.junitArtifact)).withFilter(env.expand(this.junitFilter)).build();
                Upload upload = adf.uploadTest(project, (InstrumentationTest)test);
                testToSchedule = new ScheduleRunTest().withType(testType).withTestPackageArn(upload.getArn()).withParameters(new HashMap()).withFilter(((InstrumentationTest)test).getFilter());
                break;
            }
            case UIAUTOMATOR: {
                Object test = new UIAutomatorTest.Builder().withTests(env.expand(this.uiautomatorArtifact)).withFilter(env.expand(this.uiautomatorFilter)).build();
                Upload upload = adf.uploadTest(project, (UIAutomatorTest)test);
                testToSchedule = new ScheduleRunTest().withType(testType).withTestPackageArn(upload.getArn()).withParameters(new HashMap()).withFilter(((UIAutomatorTest)test).getFilter());
                break;
            }
            case UIAUTOMATION: {
                Object test = new UIAutomationTest.Builder().withTests(this.uiautomationArtifact).build();
                Upload upload = adf.uploadTest(project, (UIAutomationTest)test);
                testToSchedule = new ScheduleRunTest().withType(testType).withTestPackageArn(upload.getArn());
                break;
            }
            case XCTEST: {
                Object test = new XCTestTest.Builder().withTests(this.xctestArtifact).withFilter(env.expand(this.xctestFilter)).build();
                Upload upload = adf.uploadTest(project, (XCTestTest)test);
                testToSchedule = new ScheduleRunTest().withType(testType).withFilter(((XCTestTest)test).getFilter()).withTestPackageArn(upload.getArn());
                break;
            }
            case XCTEST_UI: {
                Object test = new XCTestUITest.Builder().withTests(this.xctestUiArtifact).withFilter(env.expand(this.xctestUiFilter)).build();
                Upload upload = adf.uploadTest(project, (XCTestUITest)test);
                testToSchedule = new ScheduleRunTest().withType(testType).withFilter(((XCTestUITest)test).getFilter()).withTestPackageArn(upload.getArn());
                break;
            }
            default: {
                this.writeToLog(log, String.format("Cannot schedule unknown test type '%s'", testType));
            }
        }
        if (StringUtils.isNotBlank((String)this.environmentToRun)) {
            switch (this.environmentToRun) {
                case "StandardEnvironment": {
                    break;
                }
                case "CustomEnvironment": {
                    Upload testSpec = adf.getTestSpec(project, this.testSpecName);
                    testToSchedule.setTestSpecArn(testSpec.getArn());
                    break;
                }
            }
        }
        return testToSchedule;
    }

    private boolean validateConfiguration(@Nonnull PrintStream log) {
        String roleArn = this.getRoleArn();
        String akid = Secret.toString((Secret)this.getAkid());
        String skid = Secret.toString((Secret)this.getSkid());
        if ((roleArn == null || roleArn.isEmpty()) && (akid == null || akid.isEmpty() || skid == null || skid.isEmpty())) {
            this.writeToLog(log, "Either IAM Role ARN or AKID/SKID must be set.");
            return false;
        }
        if (this.projectName == null || this.projectName.isEmpty()) {
            this.writeToLog(log, "Project must be set.");
            return false;
        }
        if ((this.devicePoolName == null || this.devicePoolName.isEmpty()) && this.deviceSelectionFilters == null) {
            this.writeToLog(log, "Either devicePoolName or deviceSelectionFilters must be set.");
            return false;
        }
        if (this.devicePoolName != null && !this.devicePoolName.isEmpty() && this.deviceSelectionFilters != null && !this.deviceSelectionFilters.isEmpty()) {
            this.writeToLog(log, "Both devicePoolName and deviceSelectionFilters cannot be used at the same time. Please remove one of them.");
            return false;
        }
        if (this.deviceSelectionFilters != null && !this.deviceSelectionFilters.isEmpty() && this.maxDevicesForDeviceFilters == null) {
            this.writeToLog(log, "Missing field maxDevicesForDeviceFilters is mandatory when using deviceSelectionFilters.");
            return false;
        }
        if (this.deviceSelectionFilters == null && this.maxDevicesForDeviceFilters != null) {
            this.writeToLog(log, "maxDevicesForDeviceFilters can only be used with deviceSelectionFilters. Please remove it if you are using devicePoolName.");
            return false;
        }
        if (!this.ifWebApp.booleanValue() && (this.appArtifact == null || this.appArtifact.isEmpty())) {
            this.writeToLog(log, "Application Artifact must be set.");
            return false;
        }
        if (this.testToRun == null || this.stringToTestType(this.testToRun) == null) {
            this.writeToLog(log, "A test type must be set.");
            return false;
        }
        return true;
    }

    private boolean validateTestConfiguration(@Nonnull PrintStream log) {
        TestType testType = this.stringToTestType(this.testToRun);
        switch (testType) {
            case BUILTIN_FUZZ: {
                if (this.eventCount != null && !this.eventCount.isEmpty() && !this.eventCount.matches("^\\d+$")) {
                    this.writeToLog(log, "EventCount must be a number.");
                    return false;
                }
                if (this.seed == null || this.seed.isEmpty() || this.seed.matches("^\\d+$")) break;
                this.writeToLog(log, "Seed must be a number.");
                return false;
            }
            case BUILTIN_EXPLORER: {
                break;
            }
            case APPIUM_JAVA_JUNIT: {
                if (this.appiumJavaJUnitTest != null && !this.appiumJavaJUnitTest.isEmpty()) break;
                this.writeToLog(log, "Appium Java Junit test must be set.");
                return false;
            }
            case APPIUM_JAVA_TESTNG: {
                if (this.appiumJavaTestNGTest != null && !this.appiumJavaTestNGTest.isEmpty()) break;
                this.writeToLog(log, "Appium Java TestNG test must be set.");
                return false;
            }
            case APPIUM_PYTHON: {
                if (this.appiumPythonTest != null && !this.appiumPythonTest.isEmpty()) break;
                this.writeToLog(log, "Appium Python test must be set.");
                return false;
            }
            case APPIUM_RUBY: {
                if (this.appiumRubyTest != null && !this.appiumRubyTest.isEmpty()) break;
                this.writeToLog(log, "Appium Ruby test must be set.");
                return false;
            }
            case APPIUM_NODE: {
                if (this.appiumNodeTest != null && !this.appiumNodeTest.isEmpty()) break;
                this.writeToLog(log, "Appium Node test must be set.");
                return false;
            }
            case APPIUM_WEB_JAVA_JUNIT: {
                if (this.appiumJavaJUnitTest != null && !this.appiumJavaJUnitTest.isEmpty()) break;
                this.writeToLog(log, "Appium Java Junit test for the web application must be set.");
                return false;
            }
            case APPIUM_WEB_JAVA_TESTNG: {
                if (this.appiumJavaTestNGTest != null && !this.appiumJavaTestNGTest.isEmpty()) break;
                this.writeToLog(log, "Appium Java TestNG test for the web application must be set.");
                return false;
            }
            case APPIUM_WEB_PYTHON: {
                if (this.appiumPythonTest != null && !this.appiumPythonTest.isEmpty()) break;
                this.writeToLog(log, "Appium Python test for the web application must be set.");
                return false;
            }
            case APPIUM_WEB_RUBY: {
                if (this.appiumRubyTest != null && !this.appiumRubyTest.isEmpty()) break;
                this.writeToLog(log, "Appium Ruby test for the web application must be set.");
                return false;
            }
            case APPIUM_WEB_NODE: {
                if (this.appiumNodeTest != null && !this.appiumNodeTest.isEmpty()) break;
                this.writeToLog(log, "Appium Node test for the web application must be set.");
                return false;
            }
            case CALABASH: {
                if (this.calabashFeatures == null || this.calabashFeatures.isEmpty()) {
                    this.writeToLog(log, "Calabash Features must be set.");
                    return false;
                }
                if (this.calabashFeatures.endsWith(".zip")) break;
                this.writeToLog(log, "Calabash content must be of type .zip");
                return false;
            }
            case INSTRUMENTATION: {
                if (this.junitArtifact != null && !this.junitArtifact.isEmpty()) break;
                this.writeToLog(log, "JUnit tests Artifact must be set.");
                return false;
            }
            case UIAUTOMATOR: {
                if (this.uiautomatorArtifact != null && !this.uiautomatorArtifact.isEmpty()) break;
                this.writeToLog(log, "UI Automator tests artifact must be set.");
                return false;
            }
            case UIAUTOMATION: {
                if (this.uiautomationArtifact != null && !this.uiautomationArtifact.isEmpty()) break;
                this.writeToLog(log, "UI Automation tests artifact must be set.");
                return false;
            }
            case XCTEST: {
                if (this.xctestArtifact != null && !this.xctestArtifact.isEmpty()) break;
                this.writeToLog(log, "XC tests artifact must be set.");
                return false;
            }
            case XCTEST_UI: {
                if (this.xctestUiArtifact != null && !this.xctestUiArtifact.isEmpty()) break;
                this.writeToLog(log, "XCTest UI tests artifact must be set.");
                return false;
            }
            default: {
                this.writeToLog(log, "Must select a test type to run.");
                return false;
            }
        }
        if (CUSTOM_ENVIRONMENT.equals(this.environmentToRun) && StringUtils.isBlank((String)this.testSpecName)) {
            this.writeToLog(log, "A test Spec must be selected.");
            return false;
        }
        return true;
    }

    private void writeToLog(PrintStream log, String msg) {
        log.println(String.format("[AWSDeviceFarm] %s", msg));
    }

    public String getRoleArn() {
        return this.getDescriptor().roleArn;
    }

    public String getVpcString() {
        AWSDeviceFarm adf = this.getAWSDeviceFarm();
        try {
            Project proj = adf.getProject(this.projectName);
            VpcConfig vpcSettings = proj.getVpcConfig();
            return vpcSettings.getVpcId();
        }
        catch (Exception error) {
            return "";
        }
    }

    public String getSubnetString() {
        AWSDeviceFarm adf = this.getAWSDeviceFarm();
        try {
            Project proj = adf.getProject(this.projectName);
            VpcConfig vpcSettings = proj.getVpcConfig();
            return vpcSettings.getSubnetIds().toString();
        }
        catch (Exception error) {
            return "";
        }
    }

    public String getSecurityGroupString() {
        AWSDeviceFarm adf = this.getAWSDeviceFarm();
        try {
            Project proj = adf.getProject(this.projectName);
            VpcConfig vpcSettings = proj.getVpcConfig();
            return vpcSettings.getSecurityGroupIds().toString();
        }
        catch (Exception error) {
            return "";
        }
    }

    public Secret getAkid() {
        return this.getDescriptor().akid;
    }

    public Secret getSkid() {
        return this.getDescriptor().skid;
    }

    public AWSDeviceFarm getAWSDeviceFarm() {
        return this.getDescriptor().getAWSDeviceFarm();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public Collection<Action> getProjectActions(AbstractProject<?, ?> project) {
        return new ArrayList<Action>(Arrays.asList(new AWSDeviceFarmProjectAction(project)));
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    @Extension
    @Symbol(value={"devicefarm"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String roleArn;
        public Secret akid;
        public Secret skid;
        private List<String> projectsCache = new ArrayList<String>();
        private Map<String, List<String>> poolsCache = new HashMap<String, List<String>>();
        private List<String> vpceCache = new ArrayList<String>();
        private Map<String, List<String>> testSpecCache = new HashMap<String, List<String>>();

        public DescriptorImpl() {
            this.load();
        }

        protected final void setRoleArn(String roleArnValue) {
            this.roleArn = roleArnValue;
        }

        protected final void setAkid(String akidValue) {
            this.akid = Secret.fromString((String)akidValue);
        }

        protected final void setSkid(String skidValue) {
            this.skid = Secret.fromString((String)skidValue);
        }

        public AWSDeviceFarm getAWSDeviceFarm() {
            return this.getDeviceFarmInstance(this.roleArn, this.akid, this.skid);
        }

        private AWSDeviceFarm getDeviceFarmInstance(String roleArn, Secret akid, Secret skid) {
            if (roleArn == null || roleArn.isEmpty()) {
                return new AWSDeviceFarm((AWSCredentials)new BasicAWSCredentials(Secret.toString((Secret)akid), Secret.toString((Secret)skid)));
            }
            return new AWSDeviceFarm(roleArn);
        }

        public FormValidation doValidateCredentials(@QueryParameter String roleArn, @QueryParameter String akid, @QueryParameter String skid) {
            String skidDecryptedValue = skid;
            try {
                Secret eSkid = Secret.decrypt((String)skid);
                if (null != eSkid) {
                    skidDecryptedValue = eSkid.getPlainText();
                }
            }
            catch (Exception eSkid) {
                // empty catch block
            }
            try {
                if (StringUtils.isEmpty((String)roleArn) ? StringUtils.isEmpty((String)akid) || StringUtils.isEmpty((String)skidDecryptedValue) : StringUtils.isNotBlank((String)akid) || StringUtils.isNotBlank((String)skidDecryptedValue)) {
                    return FormValidation.error((String)"Either RoleArn or AKID,SKID required");
                }
                AWSDeviceFarm deviceFarm = this.getDeviceFarmInstance(roleArn, Secret.fromString((String)akid), Secret.fromString((String)skid));
                deviceFarm.getProjects();
            }
            catch (Exception e) {
                System.out.println("Error validating credentials");
                e.printStackTrace();
                return FormValidation.errorWithMarkup((String)"Invalid Credentials, please refer to troubleshooting <a href = \"https://github.com/awslabs/aws-device-farm-jenkins-plugin#invalid-credentials-error-while-validating-credentials\" target=\"_blank \">link</a> ");
            }
            return FormValidation.ok((String)"Credentials are valid");
        }

        public FormValidation doCheckProjectName(@QueryParameter String projectName) {
            if (projectName == null || projectName.isEmpty()) {
                return FormValidation.error((String)"Required!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDevicePoolName(@QueryParameter String devicePoolName) {
            if (devicePoolName == null || devicePoolName.isEmpty()) {
                return FormValidation.error((String)"Required!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAppArtifact(@QueryParameter Boolean ifWebApp, @QueryParameter String appArtifact) {
            if (!ifWebApp.booleanValue() && (appArtifact == null || appArtifact.isEmpty())) {
                return FormValidation.error((String)"Required!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAppiumJavaJUnitTest(@QueryParameter String appiumJavaJUnitTest) {
            if (appiumJavaJUnitTest == null || appiumJavaJUnitTest.isEmpty()) {
                return FormValidation.error((String)"Required!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAppiumJavaTestNGTest(@QueryParameter String appiumJavaTestNGTest) {
            if (appiumJavaTestNGTest == null || appiumJavaTestNGTest.isEmpty()) {
                return FormValidation.error((String)"Required!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAppiumPythonTest(@QueryParameter String appiumPythonTest) {
            if (appiumPythonTest == null || appiumPythonTest.isEmpty()) {
                return FormValidation.error((String)"Required!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAppiumRubyTest(@QueryParameter String appiumRubyTest) {
            if (appiumRubyTest == null || appiumRubyTest.isEmpty()) {
                return FormValidation.error((String)"Required!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAppiumNodeTest(@QueryParameter String appiumNodeTest) {
            if (appiumNodeTest == null || appiumNodeTest.isEmpty()) {
                return FormValidation.error((String)"Required!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCalabashFeatures(@QueryParameter String calabashFeatures) {
            if (calabashFeatures == null || calabashFeatures.isEmpty()) {
                return FormValidation.error((String)"Required!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckJunitArtifact(@QueryParameter String junitArtifact) {
            if (junitArtifact == null || junitArtifact.isEmpty()) {
                return FormValidation.error((String)"Required!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUiautomatorArtifact(@QueryParameter String uiautomatorArtifact) {
            if (uiautomatorArtifact == null || uiautomatorArtifact.isEmpty()) {
                return FormValidation.error((String)"Required");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckXctestArtifact(@QueryParameter String xctestArtifact) {
            if (xctestArtifact == null || xctestArtifact.isEmpty()) {
                return FormValidation.error((String)"Required");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckXctestUiArtifact(@QueryParameter String xctestUiArtifact) {
            if (xctestUiArtifact == null || xctestUiArtifact.isEmpty()) {
                return FormValidation.error((String)"Required");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIsRunUnmetered(@QueryParameter Boolean isRunUnmetered, @QueryParameter String appArtifact, @QueryParameter Boolean ifWebApp) {
            if (isRunUnmetered != null && isRunUnmetered.booleanValue()) {
                AWSDeviceFarm adf = this.getAWSDeviceFarm();
                if (ifWebApp != null && !ifWebApp.booleanValue()) {
                    String os = null;
                    try {
                        os = adf.getOs(appArtifact);
                    }
                    catch (AWSDeviceFarmException e) {
                        return FormValidation.error((String)e.getMessage());
                    }
                    if (adf.getUnmeteredDevices(os) <= 0) {
                        return FormValidation.error((String)String.format("Your account does not have unmetered %s device slots.", os));
                    }
                } else if (adf.getUnmeteredDevicesForWeb() <= 0) {
                    return FormValidation.error((String)String.format("Your account does not have unmetered Android or IOS device slots.", new Object[0]));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckJobTimeoutMinutes(@QueryParameter Integer jobTimeoutMinutes) {
            if (jobTimeoutMinutes == null) {
                return FormValidation.error((String)"Required");
            }
            if (jobTimeoutMinutes < 5 || jobTimeoutMinutes > 600) {
                return FormValidation.error((String)"The maximum execution timeout per device should not be greater than 600 or smaller than 5 minutes.");
            }
            return FormValidation.ok();
        }

        public FormValidation doRefresh() {
            String skid = Secret.toString((Secret)this.skid);
            String akid = Secret.toString((Secret)this.akid);
            if (!(this.roleArn == null || this.roleArn.isEmpty() || akid == null || akid.isEmpty() || skid == null || skid.isEmpty())) {
                return FormValidation.error((String)"AWS Device Farm IAM Role ARN *OR* AKID/SKID must be set!");
            }
            this.projectsCache.clear();
            this.poolsCache.clear();
            this.vpceCache.clear();
            this.testSpecCache.clear();
            return FormValidation.ok();
        }

        public ListBoxModel doFillProjectNameItems(@QueryParameter String currentProjectName) {
            ArrayList<ListBoxModel.Option> entries = new ArrayList<ListBoxModel.Option>();
            System.out.print("getting projects");
            List<String> projectNames = this.getAWSDeviceFarmProjects();
            System.out.print(String.format("project length = %d", projectNames.size()));
            for (String projectName : projectNames) {
                entries.add(new ListBoxModel.Option(projectName, projectName, projectName.equals(currentProjectName)));
            }
            return new ListBoxModel(entries);
        }

        public ListBoxModel doFillVpceServiceNameItems(@QueryParameter String currentVpceServiceName) {
            ArrayList<ListBoxModel.Option> entries = new ArrayList<ListBoxModel.Option>();
            try {
                System.out.print("Getting VPCE configs");
                List<String> vpceServiceNames = this.getAWSDeviceFarmVpceConfigurations();
                System.out.print(String.format("VPCE configs length = %d", vpceServiceNames.size()));
                for (String vpceServiceName : vpceServiceNames) {
                    entries.add(new ListBoxModel.Option(vpceServiceName, vpceServiceName, vpceServiceName.equals(currentVpceServiceName)));
                }
            }
            catch (ServiceAccountException e) {
                System.out.println("Account does not have a VPC configured or has not been whitelisted for VPC. Note: VPC is a private device only feature");
            }
            return new ListBoxModel(entries);
        }

        public ListBoxModel doFillDevicePoolNameItems(@QueryParameter String projectName, @QueryParameter String currentDevicePoolName) {
            ArrayList<ListBoxModel.Option> entries = new ArrayList<ListBoxModel.Option>();
            List<String> devicePoolNames = this.getAWSDeviceFarmDevicePools(projectName);
            if (devicePoolNames == null) {
                return new ListBoxModel();
            }
            for (String devicePoolName : devicePoolNames) {
                entries.add(new ListBoxModel.Option(devicePoolName, devicePoolName, devicePoolName.equals(currentDevicePoolName)));
            }
            return new ListBoxModel(entries);
        }

        public ListBoxModel doFillTestSpecNameItems(@QueryParameter String projectName, @QueryParameter String currentTestSpecName) {
            ArrayList<ListBoxModel.Option> entries = new ArrayList<ListBoxModel.Option>();
            List<String> testSpecNames = this.getAWSDeviceFarmTestSpec(projectName);
            if (testSpecNames == null) {
                return new ListBoxModel();
            }
            for (String testSpecName : testSpecNames) {
                entries.add(new ListBoxModel.Option(testSpecName, testSpecName, testSpecName.equals(currentTestSpecName)));
            }
            return new ListBoxModel(entries);
        }

        public ListBoxModel doFillAppiumVersionJunitItems(@QueryParameter String currentAppiumVersion) {
            ArrayList<ListBoxModel.Option> entries = new ArrayList<ListBoxModel.Option>();
            ArrayList<String> appiumVersions = new ArrayList<String>();
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_4_16);
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_6_3);
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_6_5);
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_7_1);
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_7_2);
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_9_1);
            for (String appiumVersion : appiumVersions) {
                entries.add(new ListBoxModel.Option(appiumVersion, appiumVersion, appiumVersion.equals(currentAppiumVersion)));
            }
            return new ListBoxModel(entries);
        }

        public ListBoxModel doFillAppiumVersionTestngItems(@QueryParameter String currentAppiumVersion) {
            ArrayList<ListBoxModel.Option> entries = new ArrayList<ListBoxModel.Option>();
            ArrayList<String> appiumVersions = new ArrayList<String>();
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_4_16);
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_6_3);
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_6_5);
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_7_1);
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_7_2);
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_9_1);
            for (String appiumVersion : appiumVersions) {
                entries.add(new ListBoxModel.Option(appiumVersion, appiumVersion, appiumVersion.equals(currentAppiumVersion)));
            }
            return new ListBoxModel(entries);
        }

        public ListBoxModel doFillAppiumVersionPythonItems(@QueryParameter String currentAppiumVersion) {
            ArrayList<ListBoxModel.Option> entries = new ArrayList<ListBoxModel.Option>();
            ArrayList<String> appiumVersions = new ArrayList<String>();
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_4_16);
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_6_3);
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_6_5);
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_7_1);
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_7_2);
            appiumVersions.add(AWSDeviceFarmRecorder.APPIUM_VERSION_1_9_1);
            for (String appiumVersion : appiumVersions) {
                entries.add(new ListBoxModel.Option(appiumVersion, appiumVersion, appiumVersion.equals(currentAppiumVersion)));
            }
            return new ListBoxModel(entries);
        }

        private synchronized List<String> getAWSDeviceFarmProjects() {
            if (this.projectsCache.isEmpty()) {
                AWSDeviceFarm adf = this.getAWSDeviceFarm();
                for (Project project : adf.getProjects()) {
                    this.projectsCache.add(project.getName());
                }
                Collections.sort(this.projectsCache, String.CASE_INSENSITIVE_ORDER);
            }
            return this.projectsCache;
        }

        private synchronized List<String> getAWSDeviceFarmVpceConfigurations() {
            if (this.vpceCache.isEmpty()) {
                AWSDeviceFarm adf = this.getAWSDeviceFarm();
                for (VPCEConfiguration vpceConfig : adf.getVPCEConfigurations()) {
                    this.vpceCache.add(vpceConfig.getVpceServiceName());
                }
                Collections.sort(this.vpceCache, String.CASE_INSENSITIVE_ORDER);
            }
            return this.vpceCache;
        }

        private synchronized List<String> getAWSDeviceFarmDevicePools(String projectName) {
            List<String> poolNames = this.poolsCache.get(projectName);
            if (poolNames == null || poolNames.isEmpty()) {
                AWSDeviceFarm adf = this.getAWSDeviceFarm();
                try {
                    List<DevicePool> pools = adf.getDevicePools(projectName);
                    poolNames = new ArrayList<String>();
                    for (DevicePool pool : pools) {
                        poolNames.add(pool.getName());
                    }
                    Collections.sort(poolNames, String.CASE_INSENSITIVE_ORDER);
                }
                catch (AWSDeviceFarmException aWSDeviceFarmException) {
                    // empty catch block
                }
                this.poolsCache.put(projectName, poolNames);
            }
            return poolNames;
        }

        private synchronized List<String> getAWSDeviceFarmTestSpec(String projectName) {
            this.testSpecCache.clear();
            List<String> testSpecNames = this.testSpecCache.get(projectName);
            if (testSpecNames == null || testSpecNames.isEmpty()) {
                AWSDeviceFarm adf = this.getAWSDeviceFarm();
                try {
                    List<Upload> testSpecFiles = adf.getTestSpecs(projectName);
                    testSpecNames = new ArrayList<String>();
                    for (Upload testSpec : testSpecFiles) {
                        testSpecNames.add(testSpec.getName());
                    }
                    Collections.sort(testSpecNames, String.CASE_INSENSITIVE_ORDER);
                }
                catch (AWSDeviceFarmException aWSDeviceFarmException) {
                    // empty catch block
                }
                this.testSpecCache.put(projectName, testSpecNames);
            }
            return testSpecNames;
        }

        @JavaScriptMethod
        public String fetchVpcIdFromProjectName(String projectName) {
            AWSDeviceFarm adf = this.getAWSDeviceFarm();
            try {
                Project proj = adf.getProject(projectName);
                VpcConfig vpcSettings = proj.getVpcConfig();
                return vpcSettings.getVpcId();
            }
            catch (Exception error) {
                return "";
            }
        }

        @JavaScriptMethod
        public String fetchSubnetIdsFromProjectName(String projectName) {
            AWSDeviceFarm adf = this.getAWSDeviceFarm();
            try {
                Project proj = adf.getProject(projectName);
                VpcConfig vpcSettings = proj.getVpcConfig();
                return vpcSettings.getSubnetIds().toString();
            }
            catch (Exception error) {
                return "";
            }
        }

        @JavaScriptMethod
        public String fetchSecurityGroupIdsFromProjectName(String projectName) {
            AWSDeviceFarm adf = this.getAWSDeviceFarm();
            try {
                Project proj = adf.getProject(projectName);
                VpcConfig vpcSettings = proj.getVpcConfig();
                return vpcSettings.getSecurityGroupIds().toString();
            }
            catch (Exception error) {
                return "";
            }
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            req.bindJSON((Object)this, json);
            this.save();
            return true;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Run Tests on AWS Device Farm";
        }
    }
}

