/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.awsdevicefarm;

import hudson.Functions;
import hudson.model.AbstractBuild;
import hudson.util.Area;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.awsdevicefarm.AWSDeviceFarmTestResult;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class AWSDeviceFarmGraph
extends Graph {
    public static final Color PassColor = new Color(826185);
    public static final Color WarnColor = new Color(15357487);
    public static final Color FailColor = new Color(12460838);
    public static final Color DurationColor = new Color(537168);
    public static final Color FrameColor = new Color(15461340);
    private final String xLabel;
    private final String yLabel;
    private final CategoryDataset dataset;
    private Color[] colors;

    public AWSDeviceFarmGraph(AbstractBuild<?, ?> owner, Boolean isCompleted, Area size, CategoryDataset dataset, String xLabel, String yLabel, Color ... colors) {
        super(isCompleted != false ? owner.getTimestamp().getTimeInMillis() : -1L, size.width, size.height);
        this.dataset = dataset;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.colors = colors;
    }

    protected JFreeChart createGraph() {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)this.yLabel, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setForegroundAlpha(0.7f);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setRangeGridlinePaint((Paint)Color.darkGray);
        ShiftedCategoryAxis domain = new ShiftedCategoryAxis(this.xLabel);
        domain.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        domain.setLowerMargin(0.0);
        domain.setUpperMargin(0.0);
        domain.setCategoryMargin(0.0);
        plot.setDomainAxis((CategoryAxis)domain);
        NumberAxis range = (NumberAxis)plot.getRangeAxis();
        range.setAutoRange(true);
        range.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        CategoryItemRenderer renderer = plot.getRenderer();
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        for (int i = 0; i < this.colors.length; ++i) {
            renderer.setSeriesPaint(i, (Paint)this.colors[i]);
        }
        return chart;
    }

    public static Graph createResultTrendGraph(AbstractBuild<?, ?> owner, Boolean isCompleted, List<AWSDeviceFarmTestResult> results) {
        ArrayList<String> rows = new ArrayList<String>();
        ArrayList<Number> vals = new ArrayList<Number>();
        ArrayList<ChartUtil.NumberOnlyBuildLabel> cols = new ArrayList<ChartUtil.NumberOnlyBuildLabel>();
        for (AWSDeviceFarmTestResult result : results) {
            AbstractBuild<?, ?> build = result.getOwner();
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            rows.add("Pass");
            cols.add(label);
            vals.add(result.getPassCount());
            rows.add("Warn");
            cols.add(label);
            vals.add(result.getWarnCount());
            rows.add("Fail");
            cols.add(label);
            vals.add(result.getFailCount());
        }
        CategoryDataset dataset = AWSDeviceFarmGraph.createDataset(vals, rows, cols);
        Color[] colors = new Color[]{PassColor, WarnColor, FailColor};
        return new AWSDeviceFarmGraph(owner, isCompleted, AWSDeviceFarmGraph.getGraphSize(), dataset, "Build #", "# of tests", colors);
    }

    public static Graph createDurationTrendGraph(AbstractBuild<?, ?> owner, Boolean isCompleted, List<AWSDeviceFarmTestResult> results) {
        DataSetBuilder builder = new DataSetBuilder();
        for (AWSDeviceFarmTestResult result : results) {
            AbstractBuild<?, ?> build = result.getOwner();
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            builder.add((Number)Float.valueOf(result.getDuration()), (Comparable)((Object)"Minutes"), (Comparable)label);
        }
        CategoryDataset dataset = builder.build();
        Color[] colors = new Color[]{DurationColor};
        return new AWSDeviceFarmGraph(owner, isCompleted, AWSDeviceFarmGraph.getGraphSize(), dataset, "Build #", "Device Minutes Used", colors);
    }

    private static CategoryDataset createDataset(List<Number> values, List<String> rows, List<ChartUtil.NumberOnlyBuildLabel> columns) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (int i = 0; i < values.size(); ++i) {
            dataset.addValue(values.get(i), (Comparable)((Object)rows.get(i)), (Comparable)columns.get(i));
        }
        return dataset;
    }

    private static Area getGraphSize() {
        Area resolution = Functions.getScreenResolution();
        if (resolution == null || resolution.width <= 800) {
            return new Area(250, 100);
        }
        return new Area(500, 200);
    }
}

