/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.awsdevicefarm;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.devicefarm.AWSDeviceFarmClient;
import com.amazonaws.services.devicefarm.AWSDeviceFarmClientBuilder;
import com.amazonaws.services.devicefarm.model.AccountSettings;
import com.amazonaws.services.devicefarm.model.ArtifactCategory;
import com.amazonaws.services.devicefarm.model.CreateUploadRequest;
import com.amazonaws.services.devicefarm.model.DevicePool;
import com.amazonaws.services.devicefarm.model.DeviceSelectionConfiguration;
import com.amazonaws.services.devicefarm.model.ExecutionConfiguration;
import com.amazonaws.services.devicefarm.model.GetAccountSettingsRequest;
import com.amazonaws.services.devicefarm.model.GetRunRequest;
import com.amazonaws.services.devicefarm.model.GetRunResult;
import com.amazonaws.services.devicefarm.model.GetUploadRequest;
import com.amazonaws.services.devicefarm.model.GetUploadResult;
import com.amazonaws.services.devicefarm.model.ListArtifactsRequest;
import com.amazonaws.services.devicefarm.model.ListArtifactsResult;
import com.amazonaws.services.devicefarm.model.ListDevicePoolsRequest;
import com.amazonaws.services.devicefarm.model.ListDevicePoolsResult;
import com.amazonaws.services.devicefarm.model.ListJobsRequest;
import com.amazonaws.services.devicefarm.model.ListJobsResult;
import com.amazonaws.services.devicefarm.model.ListProjectsRequest;
import com.amazonaws.services.devicefarm.model.ListProjectsResult;
import com.amazonaws.services.devicefarm.model.ListSuitesRequest;
import com.amazonaws.services.devicefarm.model.ListSuitesResult;
import com.amazonaws.services.devicefarm.model.ListTestsRequest;
import com.amazonaws.services.devicefarm.model.ListTestsResult;
import com.amazonaws.services.devicefarm.model.ListUploadsRequest;
import com.amazonaws.services.devicefarm.model.ListUploadsResult;
import com.amazonaws.services.devicefarm.model.ListVPCEConfigurationsRequest;
import com.amazonaws.services.devicefarm.model.ListVPCEConfigurationsResult;
import com.amazonaws.services.devicefarm.model.NotFoundException;
import com.amazonaws.services.devicefarm.model.Project;
import com.amazonaws.services.devicefarm.model.ScheduleRunConfiguration;
import com.amazonaws.services.devicefarm.model.ScheduleRunRequest;
import com.amazonaws.services.devicefarm.model.ScheduleRunResult;
import com.amazonaws.services.devicefarm.model.ScheduleRunTest;
import com.amazonaws.services.devicefarm.model.Upload;
import com.amazonaws.services.devicefarm.model.UploadStatus;
import com.amazonaws.services.devicefarm.model.VPCEConfiguration;
import hudson.EnvVars;
import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jenkinsci.plugins.awsdevicefarm.AWSDeviceFarmException;
import org.jenkinsci.plugins.awsdevicefarm.AWSDeviceFarmUploadType;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumJavaJUnitTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumJavaTestNGTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumNodeTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumPythonTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumRubyTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumWebJavaJUnitTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumWebJavaTestNGTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumWebNodeTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumWebPythonTest;
import org.jenkinsci.plugins.awsdevicefarm.test.AppiumWebRubyTest;
import org.jenkinsci.plugins.awsdevicefarm.test.CalabashTest;
import org.jenkinsci.plugins.awsdevicefarm.test.InstrumentationTest;
import org.jenkinsci.plugins.awsdevicefarm.test.UIAutomationTest;
import org.jenkinsci.plugins.awsdevicefarm.test.UIAutomatorTest;
import org.jenkinsci.plugins.awsdevicefarm.test.XCTestTest;
import org.jenkinsci.plugins.awsdevicefarm.test.XCTestUITest;

public class AWSDeviceFarm {
    private com.amazonaws.services.devicefarm.AWSDeviceFarm api;
    private PrintStream log;
    private FilePath workspace;
    private FilePath artifactsDir;
    private EnvVars env;
    private static final Integer DEFAULT_JOB_TIMEOUT_MINUTE = 60;
    private static final String APPIUM_RUBY_TEST_SPEC = "APPIUM_RUBY_TEST_SPEC";
    private static final String APPIUM_NODE_TEST_SPEC = "APPIUM_NODE_TEST_SPEC";
    private static final String APPIUM_WEB_RUBY_TEST_SPEC = "APPIUM_WEB_RUBY_TEST_SPEC";
    private static final String APPIUM_WEB_NODE_TEST_SPEC = "APPIUM_WEB_NODE_TEST_SPEC";
    private static final String CURATED = "CURATED";
    private static final String DUAL_STACK_ENDPOINT_TEMPLATE_STRING = "https://devicefarm.%s.api.aws";
    private static final int MAX_ROLE_SESSION_TIMEOUT = 3600;

    public AWSDeviceFarm(String roleArn) {
        this(null, roleArn);
    }

    public AWSDeviceFarm(AWSCredentials creds) {
        this(creds, null);
    }

    private AWSDeviceFarm(AWSCredentials creds, String roleArn) {
        Object credProvider = null;
        credProvider = roleArn != null ? new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, RandomStringUtils.randomAlphanumeric((int)8)).withRoleSessionDurationSeconds(3600).build() : new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new AWSStaticCredentialsProvider(creds)});
        ClientConfiguration clientConfiguration = new ClientConfiguration().withUserAgent("AWS Device Farm - Jenkins v1.0");
        AWSDeviceFarmClientBuilder builder = AWSDeviceFarmClientBuilder.standard();
        String endpoint = String.format(DUAL_STACK_ENDPOINT_TEMPLATE_STRING, Regions.US_WEST_2.getName());
        AwsClientBuilder.EndpointConfiguration endpointConfig = new AwsClientBuilder.EndpointConfiguration(endpoint, Regions.US_WEST_2.getName());
        builder.setClientConfiguration(clientConfiguration);
        builder.setCredentials((AWSCredentialsProvider)credProvider);
        builder.setEndpointConfiguration(endpointConfig);
        this.api = (com.amazonaws.services.devicefarm.AWSDeviceFarm)builder.build();
        ((AWSDeviceFarmClient)this.api).setServiceNameIntern("devicefarm");
    }

    public AWSDeviceFarm withLogger(PrintStream logger) {
        this.log = logger;
        return this;
    }

    public AWSDeviceFarm withWorkspace(FilePath workspace) {
        this.workspace = workspace;
        return this;
    }

    public AWSDeviceFarm withArtifactsDir(FilePath artifactsDir) {
        this.artifactsDir = artifactsDir;
        return this;
    }

    public AWSDeviceFarm withEnv(EnvVars env) {
        this.env = env;
        return this;
    }

    public List<Project> getProjects() {
        ArrayList<Project> projects = new ArrayList<Project>();
        ListProjectsResult result = this.api.listProjects(new ListProjectsRequest());
        projects.addAll(result.getProjects());
        while (result.getNextToken() != null) {
            ListProjectsRequest request = new ListProjectsRequest();
            request.setNextToken(result.getNextToken());
            result = this.api.listProjects(request);
            projects.addAll(result.getProjects());
        }
        return projects;
    }

    public Project getProject(String projectName) throws AWSDeviceFarmException {
        for (Project p : this.getProjects()) {
            if (!p.getName().equals(projectName)) continue;
            return p;
        }
        throw new AWSDeviceFarmException(String.format("Project '%s' not found.", projectName));
    }

    public List<VPCEConfiguration> getVPCEConfigurations() {
        ListVPCEConfigurationsResult result = this.api.listVPCEConfigurations(new ListVPCEConfigurationsRequest());
        if (result == null) {
            return new ArrayList<VPCEConfiguration>();
        }
        return result.getVpceConfigurations();
    }

    public VPCEConfiguration getVPCEConfiguration(String vpceServiceName) throws AWSDeviceFarmException {
        for (VPCEConfiguration v : this.getVPCEConfigurations()) {
            if (!v.getVpceServiceName().equals(vpceServiceName)) continue;
            return v;
        }
        throw new AWSDeviceFarmException(String.format("VPCE Service '%s' not found.", vpceServiceName));
    }

    public List<DevicePool> getDevicePools(String projectName) throws AWSDeviceFarmException {
        return this.getDevicePools(this.getProject(projectName));
    }

    public List<DevicePool> getDevicePools(Project project) {
        ListDevicePoolsResult poolsResult = this.api.listDevicePools(new ListDevicePoolsRequest().withArn(project.getArn()));
        List pools = poolsResult.getDevicePools();
        return pools;
    }

    public List<Upload> getTestSpecs(String projectName) throws AWSDeviceFarmException {
        return this.getTestSpecs(this.getProject(projectName));
    }

    public List<Upload> getTestSpecs(Project project) throws AWSDeviceFarmException {
        List<Upload> allUploads = this.getUploads(project);
        ArrayList<Upload> testSpecUploads = new ArrayList<Upload>();
        for (Upload upload : allUploads) {
            if (!upload.getType().contains("TEST_SPEC") || !UploadStatus.SUCCEEDED.toString().equals(upload.getStatus()) || this.isRestrictedDefaultSpec(upload).booleanValue()) continue;
            testSpecUploads.add(upload);
        }
        return testSpecUploads;
    }

    public Boolean isRestrictedDefaultSpec(Upload testSpec) {
        if (testSpec != null && (APPIUM_RUBY_TEST_SPEC.equals(testSpec.getType()) || APPIUM_NODE_TEST_SPEC.equals(testSpec.getType()) || APPIUM_WEB_RUBY_TEST_SPEC.equals(testSpec.getType()) || APPIUM_WEB_NODE_TEST_SPEC.equals(testSpec.getType())) && CURATED.equals(testSpec.getCategory())) {
            return true;
        }
        return false;
    }

    public List<Upload> getUploads(Project project) {
        ArrayList<Upload> uploads = new ArrayList<Upload>();
        ListUploadsResult result = this.api.listUploads(new ListUploadsRequest().withArn(project.getArn()));
        uploads.addAll(result.getUploads());
        while (result.getNextToken() != null) {
            ListUploadsRequest request = new ListUploadsRequest();
            request.setArn(project.getArn());
            request.setNextToken(result.getNextToken());
            result = this.api.listUploads(request);
            uploads.addAll(result.getUploads());
        }
        return uploads;
    }

    public DevicePool getDevicePool(String projectName, String devicePoolName) throws AWSDeviceFarmException {
        return this.getDevicePool(this.getProject(projectName), devicePoolName);
    }

    public DevicePool getDevicePool(Project project, String devicePoolName) throws AWSDeviceFarmException {
        List<DevicePool> pools = this.getDevicePools(project);
        for (DevicePool dp : pools) {
            if (!dp.getName().equals(devicePoolName)) continue;
            return dp;
        }
        throw new AWSDeviceFarmException(String.format("DevicePool '%s' not found.", devicePoolName));
    }

    public Upload getTestSpec(Project project, String testSpecName) throws AWSDeviceFarmException {
        List<Upload> testSpecUploads = this.getTestSpecs(project);
        for (Upload upload : testSpecUploads) {
            if (!upload.getName().equals(testSpecName)) continue;
            return upload;
        }
        throw new AWSDeviceFarmException(String.format("TestSpec '%s' not found.", testSpecName));
    }

    public Upload uploadApp(Project project, String appArtifact) throws InterruptedException, IOException, AWSDeviceFarmException {
        AWSDeviceFarmUploadType type;
        if (appArtifact.toLowerCase().endsWith("apk")) {
            type = AWSDeviceFarmUploadType.ANDROID_APP;
        } else if (appArtifact.toLowerCase().endsWith("ipa") || appArtifact.toLowerCase().endsWith("zip")) {
            type = AWSDeviceFarmUploadType.IOS_APP;
        } else {
            throw new AWSDeviceFarmException(String.format("Unknown app artifact to upload: %s", appArtifact));
        }
        return this.upload(project, appArtifact, type);
    }

    public Upload uploadExtraData(Project project, String extraDataArtifact) throws InterruptedException, IOException, AWSDeviceFarmException {
        if (!extraDataArtifact.toLowerCase().endsWith("zip")) {
            throw new AWSDeviceFarmException(String.format("Unknown extra data file artifact to upload: %s", extraDataArtifact));
        }
        AWSDeviceFarmUploadType type = AWSDeviceFarmUploadType.EXTERNAL_DATA;
        return this.upload(project, extraDataArtifact, type);
    }

    public Upload uploadTest(Project project, InstrumentationTest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getArtifact(), AWSDeviceFarmUploadType.INSTRUMENTATION);
    }

    public Upload uploadTest(Project project, CalabashTest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getFeatures(), AWSDeviceFarmUploadType.CALABASH);
    }

    public Upload uploadTest(Project project, UIAutomatorTest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getTests(), AWSDeviceFarmUploadType.UIAUTOMATOR);
    }

    public Upload uploadTest(Project project, UIAutomationTest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getTests(), AWSDeviceFarmUploadType.UIAUTOMATION);
    }

    public Upload uploadTest(Project project, XCTestTest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getTests(), AWSDeviceFarmUploadType.XCTEST);
    }

    public Upload uploadTest(Project project, XCTestUITest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getTests(), AWSDeviceFarmUploadType.XCTEST_UI);
    }

    public Upload uploadTest(Project project, AppiumJavaTestNGTest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getTests(), AWSDeviceFarmUploadType.APPIUM_JAVA_TESTNG);
    }

    public Upload uploadTest(Project project, AppiumJavaJUnitTest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getTests(), AWSDeviceFarmUploadType.APPIUM_JAVA_JUNIT);
    }

    public Upload uploadTest(Project project, AppiumPythonTest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getTests(), AWSDeviceFarmUploadType.APPIUM_PYTHON);
    }

    public Upload uploadTest(Project project, AppiumRubyTest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getTests(), AWSDeviceFarmUploadType.APPIUM_RUBY);
    }

    public Upload uploadTest(Project project, AppiumNodeTest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getTests(), AWSDeviceFarmUploadType.APPIUM_NODE);
    }

    public Upload uploadTest(Project project, AppiumWebJavaTestNGTest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getTests(), AWSDeviceFarmUploadType.APPIUM_WEB_JAVA_TESTNG);
    }

    public Upload uploadTest(Project project, AppiumWebJavaJUnitTest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getTests(), AWSDeviceFarmUploadType.APPIUM_WEB_JAVA_JUNIT);
    }

    public Upload uploadTest(Project project, AppiumWebPythonTest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getTests(), AWSDeviceFarmUploadType.APPIUM_WEB_PYTHON);
    }

    public Upload uploadTest(Project project, AppiumWebRubyTest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getTests(), AWSDeviceFarmUploadType.APPIUM_WEB_RUBY);
    }

    public Upload uploadTest(Project project, AppiumWebNodeTest test) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(project, test.getTests(), AWSDeviceFarmUploadType.APPIUM_WEB_NODE);
    }

    private Upload upload(Project project, String artifact, AWSDeviceFarmUploadType uploadType) throws InterruptedException, IOException, AWSDeviceFarmException {
        if (artifact == null || artifact.isEmpty()) {
            throw new AWSDeviceFarmException("Must have an artifact path.");
        }
        File file = this.getArtifactFile(this.env.expand(artifact));
        if (file == null || !file.exists()) {
            throw new AWSDeviceFarmException(String.format("File artifact %s not found.", artifact));
        }
        return this.upload(file, project, uploadType);
    }

    private Upload upload(File file, Project project, AWSDeviceFarmUploadType uploadType) throws InterruptedException, IOException, AWSDeviceFarmException {
        return this.upload(file, project, uploadType, true);
    }

    private Upload upload(File file, Project project, AWSDeviceFarmUploadType uploadType, Boolean synchronous) throws InterruptedException, IOException, AWSDeviceFarmException {
        CreateUploadRequest appUploadRequest = new CreateUploadRequest().withName(file.getName()).withProjectArn(project.getArn()).withContentType("application/octet-stream").withType(uploadType.toString());
        Upload upload = this.api.createUpload(appUploadRequest).getUpload();
        CloseableHttpClient httpClient = HttpClients.createSystem();
        HttpPut httpPut = new HttpPut(upload.getUrl());
        httpPut.setHeader("Content-Type", upload.getContentType());
        FileEntity entity = new FileEntity(file);
        httpPut.setEntity((HttpEntity)entity);
        this.writeToLog(String.format("Uploading %s to S3", file.getName()));
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new AWSDeviceFarmException(String.format("Upload returned non-200 responses: %d", response.getStatusLine().getStatusCode()));
        }
        if (synchronous.booleanValue()) {
            while (true) {
                GetUploadRequest describeUploadRequest;
                GetUploadResult describeUploadResult;
                String status;
                if ("SUCCEEDED".equalsIgnoreCase(status = (describeUploadResult = this.api.getUpload(describeUploadRequest = new GetUploadRequest().withArn(upload.getArn()))).getUpload().getStatus())) {
                    this.writeToLog(String.format("Upload %s succeeded", file.getName()));
                    break;
                }
                if ("FAILED".equalsIgnoreCase(status)) {
                    this.writeToLog(String.format("Error message from device farm: '%s'", describeUploadResult.getUpload().getMetadata()));
                    throw new AWSDeviceFarmException(String.format("Upload %s failed!", upload.getName()));
                }
                try {
                    this.writeToLog(String.format("Waiting for upload %s to be ready (current status: %s)", file.getName(), status));
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    this.writeToLog(String.format("Thread interrupted while waiting for the upload to complete", new Object[0]));
                    throw e;
                }
            }
        }
        return upload;
    }

    public ScheduleRunResult scheduleRun(String projectArn, String name, String appArn, String devicePoolArn, ScheduleRunTest test, Integer jobTimeoutMinutes, ScheduleRunConfiguration configuration, Boolean videoCapture, Boolean skipAppResign, DeviceSelectionConfiguration deviceSelectionConfiguration) throws AWSDeviceFarmException {
        ScheduleRunRequest request = new ScheduleRunRequest().withProjectArn(projectArn).withName(name).withTest(test);
        ExecutionConfiguration exeConfiguration = new ExecutionConfiguration();
        if (!jobTimeoutMinutes.equals(DEFAULT_JOB_TIMEOUT_MINUTE)) {
            exeConfiguration.setJobTimeoutMinutes(jobTimeoutMinutes);
        }
        exeConfiguration.setVideoCapture(videoCapture);
        exeConfiguration.setSkipAppResign(skipAppResign);
        request.withExecutionConfiguration(exeConfiguration);
        if (deviceSelectionConfiguration != null && (deviceSelectionConfiguration.getMaxDevices() == null || deviceSelectionConfiguration.getMaxDevices() == 0)) {
            throw new IllegalArgumentException("Max devices must be set when using device selection configuration.");
        }
        if (deviceSelectionConfiguration != null) {
            request.withDeviceSelectionConfiguration(deviceSelectionConfiguration);
            this.writeToLog(String.format("Setting device selection config", new Object[0]));
        } else {
            request.withDevicePoolArn(devicePoolArn);
            this.writeToLog(String.format("Setting device pool", new Object[0]));
        }
        if (configuration != null) {
            request.withConfiguration(configuration);
        }
        if (appArn != null) {
            request.withAppArn(appArn);
        }
        return this.api.scheduleRun(request);
    }

    public GetRunResult describeRun(String runArn) {
        return this.api.getRun(new GetRunRequest().withArn(runArn));
    }

    private File getArtifactFile(String pattern) throws AWSDeviceFarmException {
        if (pattern == null || pattern.isEmpty()) {
            throw new AWSDeviceFarmException("Must have a non-empty pattern.");
        }
        try {
            FilePath[] matches = this.workspace.list(pattern);
            if (matches == null || matches.length == 0) {
                throw new AWSDeviceFarmException(String.format("No Artifacts found using pattern '%s'", pattern));
            }
            if (matches.length != 1) {
                StringBuilder msg = new StringBuilder(String.format("More than one match found for pattern '%s':", pattern));
                for (FilePath fp : matches) {
                    msg.append(String.format("%n\t%s", fp.getRemote()));
                }
                throw new AWSDeviceFarmException(msg.toString());
            }
            FilePath artifact = matches[0];
            this.writeToLog(String.format("Archiving artifact '%s'", artifact.getName()));
            FilePath localArtifact = new FilePath(this.artifactsDir, artifact.getName());
            artifact.copyTo(localArtifact);
            return new File(localArtifact.getRemote());
        }
        catch (IOException e) {
            throw new AWSDeviceFarmException(String.format("Unable to find artifact %s", e.toString()));
        }
        catch (InterruptedException e) {
            throw new AWSDeviceFarmException(String.format("Unable to find artifact %s", e.toString()));
        }
    }

    public ListArtifactsResult listArtifacts(String runArn, ArtifactCategory category) {
        ListArtifactsRequest request = new ListArtifactsRequest().withArn(runArn).withType(category);
        return this.api.listArtifacts(request);
    }

    public ListJobsResult listJobs(String runArn) {
        ListJobsRequest request = new ListJobsRequest().withArn(runArn);
        return this.api.listJobs(request);
    }

    public ListSuitesResult listSuites(String jobArn) {
        ListSuitesRequest request = new ListSuitesRequest().withArn(jobArn);
        return this.api.listSuites(request);
    }

    public ListTestsResult listTests(String suiteArn) {
        ListTestsRequest request = new ListTestsRequest().withArn(suiteArn);
        return this.api.listTests(request);
    }

    public int getUnmeteredDevices(String os) {
        AccountSettings accountSettings = this.getAccountSettings();
        if (accountSettings == null) {
            return 0;
        }
        if (os.equalsIgnoreCase("ANDROID")) {
            return (Integer)this.getAccountSettings().getUnmeteredDevices().get("ANDROID");
        }
        if (os.equalsIgnoreCase("IOS")) {
            return (Integer)this.getAccountSettings().getUnmeteredDevices().get("IOS");
        }
        return 0;
    }

    public int getUnmeteredDevicesForWeb() {
        AccountSettings accountSettings = this.getAccountSettings();
        if (accountSettings == null) {
            return 0;
        }
        int androidCount = (Integer)this.getAccountSettings().getUnmeteredDevices().get("ANDROID");
        int iosCount = (Integer)this.getAccountSettings().getUnmeteredDevices().get("IOS");
        return Math.max(androidCount, iosCount);
    }

    public String getOs(String appArtifact) throws AWSDeviceFarmException {
        if (appArtifact.toLowerCase().endsWith("apk")) {
            return "Android";
        }
        if (appArtifact.toLowerCase().endsWith("ipa")) {
            return "IOS";
        }
        throw new AWSDeviceFarmException(String.format("Unknown app artifact to upload: %s", appArtifact));
    }

    public AccountSettings getAccountSettings() {
        try {
            GetAccountSettingsRequest request = new GetAccountSettingsRequest();
            return this.api.getAccountSettings(request).getAccountSettings();
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private void writeToLog(String message) {
        if (this.log != null) {
            this.log.println(String.format("[AWSDeviceFarm] %s", message));
        }
    }
}

