/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.plugins.audit_trail.AuditLogger;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ElasticSearchAuditLogger
extends AuditLogger {
    private String url;
    private String usernamePasswordCredentialsId;
    private String clientCertificateCredentialsId;
    private boolean skipCertificateValidation = false;
    transient ElasticSearchSender elasticSearchSender;
    protected static final Logger LOGGER = Logger.getLogger(ElasticSearchAuditLogger.class.getName());
    private static final FastDateFormat DATE_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssZ");

    @DataBoundConstructor
    public ElasticSearchAuditLogger(String url, boolean skipCertificateValidation) {
        this.url = url;
        this.skipCertificateValidation = skipCertificateValidation;
    }

    private Object readResolve() {
        this.configure();
        return this;
    }

    @Override
    public void log(String event) {
        if (this.elasticSearchSender == null) {
            this.configure();
            if (this.elasticSearchSender == null) {
                LOGGER.log(Level.FINER, "skip log {0}, elasticSearchSender not configured", event);
                return;
            }
        }
        LOGGER.log(Level.FINER, "Send audit message \"{0}\" to Elastic Search server {1}", new Object[]{event, this.elasticSearchSender.getUrl()});
        try {
            this.elasticSearchSender.sendMessage(event);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Audit event not sent to Elastic Search server: " + event + " - " + this.elasticSearchSender.toString(), e);
        }
    }

    public void configure() {
        if (this.url == null || this.url.length() == 0) {
            LOGGER.fine("Elastic Search Logger not configured");
            return;
        }
        String username = null;
        String password = null;
        if (!StringUtils.isBlank((String)this.usernamePasswordCredentialsId)) {
            LOGGER.fine("Username/password credentials specified: " + this.usernamePasswordCredentialsId);
            try {
                StandardUsernamePasswordCredentials usernamePasswordCredentials = this.getUsernamePasswordCredentials(this.usernamePasswordCredentialsId);
                if (usernamePasswordCredentials != null) {
                    username = usernamePasswordCredentials.getUsername();
                    password = Secret.toString((Secret)usernamePasswordCredentials.getPassword());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Unable to resolve credentials for ElasticSearchSender", e);
            }
        }
        KeyStore clientKeyStore = null;
        String clientKeyStorePassword = null;
        if (!StringUtils.isBlank((String)this.clientCertificateCredentialsId)) {
            LOGGER.fine("Client certificate specified: " + this.clientCertificateCredentialsId);
            StandardCertificateCredentials certificateCredentials = this.getCertificateCredentials(this.clientCertificateCredentialsId);
            if (certificateCredentials != null) {
                clientKeyStore = certificateCredentials.getKeyStore();
                clientKeyStorePassword = certificateCredentials.getPassword().getPlainText();
                LOGGER.fine("Client certificate keystore loaded");
            } else {
                LOGGER.log(Level.SEVERE, "Unable to find certificate credentials: " + this.clientCertificateCredentialsId + " - Not creating ElasticSearchSender");
                return;
            }
        }
        try {
            this.elasticSearchSender = new ElasticSearchSender(this.url, username, password, clientKeyStore, clientKeyStorePassword, this.skipCertificateValidation);
            LOGGER.log(Level.FINE, "ElasticSearchAuditLogger: {0}", this);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Unable to create ElasticSearchSender", ioe);
        }
        catch (GeneralSecurityException gse) {
            LOGGER.log(Level.SEVERE, "Unable to create ElasticSearchSender", gse);
        }
    }

    private StandardUsernamePasswordCredentials getUsernamePasswordCredentials(String credentialsId) {
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    private StandardCertificateCredentials getCertificateCredentials(String credentialsId) {
        return (StandardCertificateCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCertificateCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public String getUrl() {
        return this.url;
    }

    @DataBoundSetter
    public void setUrl(String url) throws URISyntaxException, MalformedURLException {
        this.url = url;
        new URL(url).toURI();
    }

    public String getUsernamePasswordCredentialsId() {
        return this.usernamePasswordCredentialsId;
    }

    @DataBoundSetter
    public void setUsernamePasswordCredentialsId(String usernamePasswordCredentialsId) {
        this.usernamePasswordCredentialsId = usernamePasswordCredentialsId;
    }

    public String getClientCertificateCredentialsId() {
        return this.clientCertificateCredentialsId;
    }

    @DataBoundSetter
    public void setClientCertificateCredentialsId(String clientCertificateCredentialsId) {
        this.clientCertificateCredentialsId = clientCertificateCredentialsId;
    }

    public boolean getSkipCertificateValidation() {
        return this.skipCertificateValidation;
    }

    @DataBoundSetter
    public void setSkipCertificateValidation(boolean skipCertificateValidation) {
        this.skipCertificateValidation = skipCertificateValidation;
    }

    public String getDisplayName() {
        return "Elastic Search Logger";
    }

    ElasticSearchSender getElasticSearchSender() {
        return this.elasticSearchSender;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ElasticSearchAuditLogger)) {
            return false;
        }
        ElasticSearchAuditLogger that = (ElasticSearchAuditLogger)o;
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        if (this.usernamePasswordCredentialsId != null ? !this.usernamePasswordCredentialsId.equals(that.usernamePasswordCredentialsId) : that.usernamePasswordCredentialsId != null) {
            return false;
        }
        if (this.clientCertificateCredentialsId != null ? !this.clientCertificateCredentialsId.equals(that.clientCertificateCredentialsId) : that.clientCertificateCredentialsId != null) {
            return false;
        }
        return this.skipCertificateValidation == that.skipCertificateValidation;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.usernamePasswordCredentialsId == null ? 0 : this.usernamePasswordCredentialsId.hashCode());
        result = 31 * result + (this.clientCertificateCredentialsId == null ? 0 : this.clientCertificateCredentialsId.hashCode());
        result = 31 * result + Boolean.hashCode(this.skipCertificateValidation);
        return result;
    }

    public String toString() {
        return "ElasticSearchAuditLogger{url='" + this.url + "', usernamePasswordCredentialsId='" + this.usernamePasswordCredentialsId + "', clientCertificateCredentialsId='" + this.clientCertificateCredentialsId + "', skipCertificateValidation='" + this.skipCertificateValidation + "'}";
    }

    static class ElasticSearchSender {
        private final CloseableHttpClient httpClient;
        private final String url;
        private final String auth;
        private final boolean skipCertificateValidation;

        public ElasticSearchSender(String url, String username, String password, KeyStore clientKeyStore, String clientKeyStorePassword, boolean skipCertificateValidation) throws IOException, GeneralSecurityException {
            this.url = url;
            this.auth = StringUtils.isNotBlank((String)username) ? Base64.encodeBase64String((byte[])(username + ":" + StringUtils.defaultString((String)password)).getBytes(StandardCharsets.UTF_8)) : null;
            this.skipCertificateValidation = skipCertificateValidation;
            this.httpClient = this.createHttpClient(clientKeyStore, clientKeyStorePassword, skipCertificateValidation);
        }

        public String getUrl() {
            return this.url;
        }

        public boolean getSkipCertificateValidation() {
            return this.skipCertificateValidation;
        }

        private CloseableHttpClient createHttpClient(KeyStore keyStore, String keyStorePassword, boolean skipCertificateValidation) throws GeneralSecurityException {
            TrustSelfSignedStrategy trustStrategy = null;
            if (skipCertificateValidation) {
                trustStrategy = TrustSelfSignedStrategy.INSTANCE;
            }
            SSLContextBuilder contextBuilder = SSLContexts.custom();
            contextBuilder.loadTrustMaterial(keyStore, (TrustStrategy)trustStrategy);
            if (keyStore != null) {
                contextBuilder.loadKeyMaterial(keyStore, keyStorePassword.toCharArray());
            }
            SSLContext sslContext = contextBuilder.build();
            HttpClientBuilder builder = HttpClients.custom();
            SSLConnectionSocketFactoryBuilder sslConnectionBuilder = SSLConnectionSocketFactoryBuilder.create().setSslContext(sslContext);
            if (skipCertificateValidation) {
                sslConnectionBuilder.setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            builder.setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionBuilder.build()).build());
            return builder.build();
        }

        public void sendMessage(String event) throws IOException {
            HttpPost post = this.getHttpPost(event);
            this.httpClient.execute((ClassicHttpRequest)post, response -> {
                int statusCode = response.getCode();
                if (statusCode >= 200 && statusCode < 300) {
                    LOGGER.log(Level.FINE, "Response: {0}", response);
                } else {
                    LOGGER.log(Level.WARNING, "Audit event not sent to Elastic Search server: " + event + " - " + String.valueOf(this), this.getErrorMessage(response));
                }
                return response;
            });
        }

        HttpPost getHttpPost(String data) {
            HttpPost postRequest = new HttpPost(this.url);
            JSONObject payload = new JSONObject();
            payload.put("message", (Object)data);
            payload.put("@timestamp", (Object)DATE_FORMATTER.format(Calendar.getInstance().getTime()));
            StringEntity input = new StringEntity(payload.toString(), ContentType.APPLICATION_JSON, StandardCharsets.UTF_8.name(), false);
            postRequest.setEntity((HttpEntity)input);
            if (this.auth != null) {
                postRequest.addHeader("Authorization", (Object)("Basic " + this.auth));
            }
            return postRequest;
        }

        private String getErrorMessage(ClassicHttpResponse response) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try (PrintStream stream = new PrintStream((OutputStream)byteStream, true, StandardCharsets.UTF_8);){
                try {
                    stream.print("HTTP error code: ");
                    stream.println(response.getCode());
                    stream.print("URL: ");
                    stream.println(this.url);
                    stream.println("RESPONSE: " + String.valueOf(response));
                    response.getEntity().writeTo((OutputStream)stream);
                }
                catch (IOException e) {
                    stream.println(ExceptionUtils.getStackTrace((Throwable)e));
                }
                stream.flush();
                String string = byteStream.toString(StandardCharsets.UTF_8);
                return string;
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AuditLogger> {
        public String getDisplayName() {
            return "Elastic Search server";
        }

        public ListBoxModel doFillUsernamePasswordCredentialsIdItems(@QueryParameter String usernamePasswordCredentialsId, @QueryParameter String url) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new StandardListBoxModel().includeCurrentValue(usernamePasswordCredentialsId);
            }
            List domainRequirements = URIRequirementBuilder.fromUri((String)url).build();
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StandardCredentials.class, domainRequirements, CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)})).includeCurrentValue(usernamePasswordCredentialsId);
        }

        public ListBoxModel doFillClientCertificateCredentialsIdItems(@QueryParameter String clientCertificateCredentialsId, @QueryParameter String url) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new StandardListBoxModel().includeCurrentValue(clientCertificateCredentialsId);
            }
            List domainRequirements = URIRequirementBuilder.fromUri((String)url).build();
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StandardCertificateCredentials.class, domainRequirements, CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardCertificateCredentials.class)})).includeCurrentValue(clientCertificateCredentialsId);
        }

        public FormValidation doCheckUrl(@QueryParameter(value="value") String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.warning((String)"URL must be set");
            }
            try {
                URL url = new URL(value);
                if (url.getUserInfo() != null) {
                    return FormValidation.error((String)"Please specify user and password not as part of the url.");
                }
                if (StringUtils.isBlank((String)url.getPath()) || url.getPath().trim().matches("^\\/+$")) {
                    return FormValidation.warning((String)"Elastic Search requires an index name and document type to be able to index the logs.  eg. https://elastic.mydomain.com/myindex/jenkinslog/");
                }
                url.toURI();
            }
            catch (MalformedURLException | URISyntaxException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok();
        }
    }
}

