/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.plugins.audit_trail.AuditLogger;
import hudson.plugins.audit_trail.AuditTrailFilter;
import hudson.plugins.audit_trail.BypassablePatternMonitor;
import hudson.plugins.audit_trail.LogFileAuditLogger;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

@Symbol(value={"audit-trail"})
@Extension
public class AuditTrailPlugin
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(AuditTrailPlugin.class.getName());
    private boolean logBuildCause = true;
    private boolean displayUserName = false;
    private boolean logCredentialsUsage = true;
    private boolean logScriptUsage = false;
    private List<AuditLogger> loggers = new ArrayList<AuditLogger>();
    private transient String log;
    private static final List<String> KNOWN_KEYWORDS = Arrays.asList("configSubmit", "doDelete", "postBuildResult", "enable", "disable", "cancelQueue", "stop", "toggleLogKeep", "doWipeOutWorkspace", "createItem", "createView", "toggleOffline", "cancelQuietDown", "quietDown", "restart", "exit", "safeExit");
    static final String DEFAULT_PATTERN = ".*/(?:" + String.join((CharSequence)"|", KNOWN_KEYWORDS) + ")/?.*";
    private String pattern = DEFAULT_PATTERN;

    public String getPattern() {
        return this.pattern;
    }

    @Deprecated
    public boolean getLogBuildCause() {
        return this.shouldLogBuildCause();
    }

    public boolean shouldLogBuildCause() {
        return this.logBuildCause;
    }

    public boolean getLogCredentialsUsage() {
        return this.shouldLogCredentialsUsage();
    }

    public boolean shouldLogCredentialsUsage() {
        return this.logCredentialsUsage;
    }

    public boolean shouldDisplayUserName() {
        return this.displayUserName;
    }

    public boolean getDisplayUserName() {
        return this.shouldDisplayUserName();
    }

    public List<AuditLogger> getLoggers() {
        return this.loggers;
    }

    public boolean getLogScriptUsage() {
        return this.logScriptUsage;
    }

    public AuditTrailPlugin() {
        this.load();
    }

    public boolean configure(StaplerRequest2 req, JSONObject formData) {
        this.loggers.forEach(AuditLogger::cleanUp);
        req.bindJSON((Object)this, formData);
        return true;
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        if (BypassablePatternMonitor.isLegacyBypassableDefaultPattern(pattern)) {
            LOGGER.warning("Found a legacy vulnerable pattern, will use the default pattern");
            this.resetPattern();
        } else {
            this.pattern = Optional.ofNullable(pattern).orElse("");
        }
        this.updateFilterPattern();
        this.save();
    }

    void resetPattern() {
        LOGGER.info("Reset the default pattern");
        this.pattern = DEFAULT_PATTERN;
    }

    static List<String> getKnownKeywords() {
        return Collections.unmodifiableList(KNOWN_KEYWORDS);
    }

    @DataBoundSetter
    public void setLogBuildCause(boolean logBuildCause) {
        this.logBuildCause = logBuildCause;
        this.save();
    }

    @DataBoundSetter
    public void setLogCredentialsUsage(boolean logCredentialsUsage) {
        this.logCredentialsUsage = logCredentialsUsage;
        this.save();
    }

    @DataBoundSetter
    public void setDisplayUserName(boolean displayUserName) {
        this.displayUserName = displayUserName;
        this.save();
    }

    @DataBoundSetter
    public void setLogScriptUsage(boolean logScriptUsage) {
        this.logScriptUsage = logScriptUsage;
        this.save();
    }

    private void updateFilterPattern() {
        try {
            AuditTrailFilter.setPattern(this.pattern);
        }
        catch (PatternSyntaxException ex) {
            ex.printStackTrace();
        }
    }

    @Deprecated
    public DescriptorExtensionList<AuditLogger, Descriptor<AuditLogger>> getLoggerDescriptors() {
        return AuditLogger.all();
    }

    @DataBoundSetter
    public void setLoggers(List<AuditLogger> loggers) {
        this.loggers = Optional.ofNullable(loggers).orElse(Collections.emptyList());
    }

    @Restricted(value={DoNotUse.class})
    @Deprecated
    public void onFinalized(Run run) {
        LOGGER.warning("AuditTrailPlugin#onFinalized does nothing anymore, please update your script");
    }

    @Restricted(value={DoNotUse.class})
    @Deprecated
    public void onFinalized(AbstractBuild build) {
        LOGGER.warning("AuditTrailPlugin#onFinalized does nothing anymore, please update your script");
    }

    private Object readResolve() {
        if (this.log != null) {
            LogFileAuditLogger logger;
            if (this.loggers == null) {
                this.loggers = new ArrayList<AuditLogger>();
            }
            if (!this.loggers.contains(logger = new LogFileAuditLogger(this.log, 1, 1, null))) {
                this.loggers.add(logger);
            }
            this.log = null;
        }
        this.updateFilterPattern();
        return this;
    }

    public FormValidation doCheckPattern(@QueryParameter String value) throws IOException, ServletException {
        try {
            Pattern.compile(value);
        }
        catch (PatternSyntaxException ex) {
            return FormValidation.errorWithMarkup((String)("Invalid <a href=\"https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html\">regular expression</a> (" + Util.escape((String)ex.getMessage()) + ")"));
        }
        return BypassablePatternMonitor.validatePatternAgainstKnownKeywords(value);
    }

    protected XmlFile getConfigFile() {
        return new XmlFile(new File(Jenkins.get().getRootDir(), "audit-trail.xml"));
    }
}

