/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.aquadockerscannerbuildstep;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import jenkins.model.Jenkins;

public class ScannerExecuter {
    public static final String PODMAN_SOCKET_SUFFIX = "/podman/podman.sock";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execute(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, String artifactName, String aquaScannerImage, String apiURL, String user, Secret password, Secret token, int timeout, String runOptions, String locationType, String localImage, String registry, boolean register, String hostedImage, boolean hideBase, boolean showNegligible, boolean checkonly, String notCompliesCmd, boolean caCertificates, String policies, Secret localToken, String customFlags, String tarFilePath, String containerRuntime, String scannerPath, String runtimeDirectory) {
        try (PrintStream print_stream = null;){
            EnvVars env = build.getEnvironment(listener);
            localImage = env.expand(localImage);
            registry = env.expand(registry);
            hostedImage = env.expand(hostedImage);
            tarFilePath = env.expand(tarFilePath);
            ArgumentListBuilder args = new ArgumentListBuilder();
            if (containerRuntime == null) {
                containerRuntime = "";
            }
            if (scannerPath == null) {
                scannerPath = "";
            }
            if (localToken == null) {
                localToken = Secret.fromString((String)"");
            }
            boolean isDocker = false;
            if (containerRuntime.isEmpty() || "docker".equals(containerRuntime)) {
                containerRuntime = "docker";
                isDocker = true;
            }
            boolean toScanImageWithPodman = !isDocker && !runtimeDirectory.isEmpty();
            args.add(containerRuntime);
            args.add("run");
            String podmanSocketString = "";
            if (!isDocker && !runtimeDirectory.isEmpty()) {
                String podmanSocket = runtimeDirectory + PODMAN_SOCKET_SUFFIX;
                podmanSocketString = podmanSocket + ":" + podmanSocket;
                args.addTokenized("-e XDG_RUNTIME_DIR=" + runtimeDirectory);
                args.add("--security-opt");
                args.addTokenized("label=disable");
            }
            String buildJobName = ((String)env.get((Object)"JOB_NAME")).trim();
            buildJobName = buildJobName.replaceAll("\\s+", "");
            String buildUrl = (String)env.get((Object)"BUILD_URL");
            String buildNumber = (String)env.get((Object)"BUILD_NUMBER");
            args.addTokenized("-e BUILD_JOB_NAME=" + buildJobName + " -e BUILD_URL=" + buildUrl + " -e BUILD_NUMBER=" + buildNumber);
            ImageLocation location = ImageLocation.valueOf(locationType.toUpperCase());
            if (Objects.equals((Object)location, (Object)ImageLocation.DOCKERARCHIVE) && !isDocker) {
                listener.getLogger().println("Podman is not supported with docker-archive");
                System.exit(1);
            }
            switch (location) {
                case HOSTED: {
                    args.addTokenized(runOptions);
                    args.add(new String[]{"--rm", "-v", "/var/run/docker.sock:/var/run/docker.sock", aquaScannerImage, "scan", "--host", apiURL, "--registry", registry, hostedImage});
                    if (!register) break;
                    args.add("--register");
                    break;
                }
                case LOCAL: {
                    if (!"".equals(scannerPath) && !isDocker) {
                        args.add(new String[]{"-v", scannerPath + ":/aquasec/scannercli:Z", "--entrypoint=/aquasec/scannercli"});
                    }
                    if (!isDocker && runtimeDirectory.isEmpty()) {
                        args.addTokenized(runOptions);
                    }
                    if (isDocker) {
                        args.add(new String[]{"--rm", "-v", "/var/run/docker.sock:/var/run/docker.sock", aquaScannerImage, "scan", "--host", apiURL, "--local", localImage});
                    } else if (!runtimeDirectory.isEmpty()) {
                        args.add(new String[]{"--rm", "-v", podmanSocketString, aquaScannerImage, "scan", "--host", apiURL, "--local", localImage});
                    } else {
                        args.add(new String[]{"--rm", "-u", "root", localImage, "scan", "--host", apiURL});
                    }
                    if (!register) break;
                    args.add(new String[]{"--registry", registry});
                    args.add("--register");
                    break;
                }
                case DOCKERARCHIVE: {
                    args.addTokenized(runOptions);
                    Path path = Paths.get(tarFilePath, new String[0]);
                    Path fileName = path.getFileName();
                    if (fileName == null) {
                        throw new AbortException("can not extract the file name \n");
                    }
                    String imgName = fileName.toString().split("\\.")[0];
                    args.add(new String[]{"--rm", "-v", tarFilePath + ":" + tarFilePath, aquaScannerImage, "scan", imgName + ":tar", "--host", apiURL, "--docker-archive", tarFilePath});
                    break;
                }
                default: {
                    int n = -1;
                    return n;
                }
            }
            if (showNegligible) {
                args.add("--show-negligible");
            }
            if (checkonly) {
                args.add("--checkonly");
            }
            if (caCertificates) {
                args.add("--no-verify");
            }
            if (policies != null && !policies.isEmpty()) {
                args.add(new String[]{"--policies", policies});
            }
            if (hideBase) {
                args.add("--hide-base");
            }
            if (toScanImageWithPodman) {
                args.addTokenized("--socket=podman");
            } else if (!isDocker && runtimeDirectory.isEmpty()) {
                args.add(new String[]{"--image-name", localImage});
                args.add(new String[]{"--fs-scan", "/"});
            }
            if (localToken != null && !Secret.toString((Secret)localToken).equals("")) {
                listener.getLogger().println("Received local token, will override global auth");
                args.add("--token");
                args.addMasked(localToken);
            } else if (!Secret.toString((Secret)token).isEmpty()) {
                listener.getLogger().println("Received global token");
                args.add("--token");
                args.addMasked(token);
            } else {
                listener.getLogger().println("Received global username password auth");
                args.add(new String[]{"--user", user, "--password"});
                args.addMasked(password);
            }
            if (customFlags != null && !customFlags.isEmpty()) {
                args.addTokenized(customFlags);
            }
            args.add("--html");
            File outFile = new File(build.getRootDir(), "out");
            Launcher.ProcStarter ps = launcher.launch();
            ps.cmds(args);
            ps.stdin(null);
            print_stream = new PrintStream(outFile, "UTF-8");
            ps.stderr((OutputStream)print_stream);
            ps.stdout((OutputStream)print_stream);
            ps.quiet(true);
            listener.getLogger().println(args.toString());
            int exitCode = ps.join();
            FilePath target = new FilePath(workspace, artifactName);
            FilePath outFilePath = new FilePath(outFile);
            outFilePath.copyTo(target);
            FilePath targetCss = new FilePath(workspace, "styles.css");
            File cssFile = Jenkins.get().getPluginManager().getWorkDir() != null ? new File(Jenkins.get().getPluginManager().getWorkDir() + "/aqua-security-scanner/css/", "styles.css") : new File((String)env.get((Object)"JENKINS_HOME") + "/plugins/aqua-security-scanner/css/", "styles.css");
            FilePath cssFilePath = new FilePath(cssFile);
            cssFilePath.copyTo(targetCss);
            String scanOutput = target.readToString();
            ScannerExecuter.cleanBuildOutput(scanOutput, target, listener);
            if (exitCode == 4 && !notCompliesCmd.trim().isEmpty()) {
                ps = launcher.launch();
                args = new ArgumentListBuilder();
                args.add(new String[]{"bash", "-c", notCompliesCmd});
                ps.cmds(args);
                ps.stdin(null);
                ps.stderr((OutputStream)listener.getLogger());
                ps.stdout((OutputStream)listener.getLogger());
                ps.join();
            }
            int n = exitCode;
            return n;
        }
    }

    private static void cleanBuildOutput(String scanOutput, FilePath target, TaskListener listener) {
        int htmlStart = scanOutput.indexOf("<!DOCTYPE html>");
        if (htmlStart == -1) {
            listener.getLogger().println(scanOutput);
        }
        listener.getLogger().println(scanOutput.substring(0, htmlStart));
        int htmlEnd = scanOutput.lastIndexOf("</html>") + 7;
        if (htmlEnd + 1 < scanOutput.length()) {
            listener.getLogger().println(scanOutput.substring(htmlEnd + 1, scanOutput.length()));
        }
        if (htmlStart < htmlEnd) {
            scanOutput = scanOutput.substring(htmlStart, htmlEnd);
        }
        try {
            target.write(scanOutput, "UTF-8");
        }
        catch (Exception e) {
            listener.getLogger().println("Failed to save HTML report.");
        }
    }

    public static enum ImageLocation {
        HOSTED,
        LOCAL,
        DOCKERARCHIVE;

    }
}

