/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.antexec;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.antexec.Messages;
import hudson.tasks.Ant;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks._ant.AntConsoleAnnotator;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class AntExec
extends Builder {
    private static final String myName = "antexec";
    protected static final String buildXml = "antexec_build.xml";
    private final String scriptSource;
    private final String extendedScriptSource;
    private final String scriptName;
    private final String properties;
    private final String antOpts;
    private final Boolean keepBuildfile;
    private final Boolean verbose;
    private final Boolean emacs;
    private final Boolean noAntcontrib;
    private final String antName;

    @DataBoundConstructor
    public AntExec(String scriptSource, String extendedScriptSource, String scriptName, String properties, String antName, String antOpts, Boolean keepBuildfile, Boolean verbose, Boolean emacs, Boolean noAntcontrib) {
        this.scriptSource = scriptSource;
        this.extendedScriptSource = extendedScriptSource;
        this.scriptName = scriptName;
        this.properties = properties;
        this.keepBuildfile = keepBuildfile;
        this.antName = antName;
        this.antOpts = antOpts;
        this.verbose = verbose;
        this.emacs = emacs;
        this.noAntcontrib = noAntcontrib;
    }

    public String getScriptSource() {
        return this.scriptSource;
    }

    public String getExtendedScriptSource() {
        return this.extendedScriptSource;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getAntOpts() {
        return this.antOpts;
    }

    public Boolean getKeepBuildfile() {
        return this.keepBuildfile;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public Boolean getEmacs() {
        return this.emacs;
    }

    public Boolean getNoAntcontrib() {
        return this.noAntcontrib;
    }

    Ant.AntInstallation getAnt() {
        for (Ant.AntInstallation i : this.getDescriptor().getInstallations()) {
            if (this.antName == null || !this.antName.equals(i.getName())) continue;
            return i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        String scriptSourceResolved = this.scriptSource;
        String extendedScriptSourceResolved = this.extendedScriptSource;
        FilePath propertyFile = null;
        if (this.properties != null && this.properties.length() > 0 && !this.properties.equals("") || !build.getBuildVariables().isEmpty()) {
            Properties myMergedProperties = new Properties();
            myMergedProperties.putAll((Map<?, ?>)build.getBuildVariables());
            byte[] bytes = this.properties.getBytes("UTF-8");
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            InputStreamReader isr = new InputStreamReader((InputStream)bais, "UTF-8");
            myMergedProperties.load(isr);
            propertyFile = AntExec.makePropertyFile(this.scriptName, build, myMergedProperties);
        }
        try {
            scriptSourceResolved = TokenMacro.expandAll(build, (TaskListener)listener, (String)this.scriptSource);
            extendedScriptSourceResolved = TokenMacro.expandAll(build, (TaskListener)listener, (String)this.extendedScriptSource);
        }
        catch (MacroEvaluationException ex) {
            Logger.getLogger(AntExec.class.getName()).log(Level.WARNING, null, ex);
        }
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        Ant.AntInstallation ai = this.getAnt();
        if (ai == null) {
            args.add(launcher.isUnix() ? "ant" : "ant.bat");
        } else {
            Node node = Computer.currentComputer().getNode();
            if (node == null) {
                throw new AbortException("Cannot get installation for node, since it is not online");
            }
            ai = ai.forNode(node, (TaskListener)listener);
            String exe = (ai = ai.forEnvironment(env)).getExecutable(launcher);
            if (exe == null) {
                throw new AbortException("Cannot find executable from the chosen Ant installation.");
            }
            args.add(exe);
        }
        FilePath buildFile = AntExec.makeBuildFile(this.scriptName, scriptSourceResolved, extendedScriptSourceResolved, build);
        args.add(new String[]{"-file", buildFile.getName()});
        if (ai != null) {
            ai.buildEnvVars(env);
        }
        if (this.antOpts != null && this.antOpts.length() > 0 && !this.antOpts.equals("")) {
            env.put("ANT_OPTS", env.expand(this.antOpts));
        }
        FilePath antLibDir = null;
        if (this.noAntcontrib == null || !this.noAntcontrib.booleanValue()) {
            FilePath ws;
            if (this.verbose != null && this.verbose.booleanValue()) {
                listener.getLogger().println(Messages.AntExec_UseAntContribTasks());
            }
            if ((ws = build.getWorkspace()) == null) {
                throw new AbortException("Cannot get Workspace for node, since it is not online");
            }
            antLibDir = new FilePath(ws, "antlib");
            if (!antLibDir.exists()) {
                FilePath antContribJar = new FilePath(antLibDir, "ant-contrib.jar");
                FilePath antContribJarOnMaster = new FilePath(Jenkins.get().getRootPath(), "plugins/antexec/META-INF/lib/ant-contrib.jar");
                antContribJar.copyFrom(antContribJarOnMaster.toURI().toURL());
            }
            args.add(new String[]{"-lib", antLibDir.getName()});
        } else if (this.verbose != null && this.verbose.booleanValue()) {
            listener.getLogger().println(Messages.AntExec_UseAntCoreTasksOnly());
        }
        if (this.verbose != null && this.verbose.booleanValue()) {
            args.add("-verbose");
        }
        if (this.emacs != null && this.emacs.booleanValue()) {
            args.add("-emacs");
        }
        if (!launcher.isUnix()) {
            args = args.toWindowsCommand();
            ArrayList<String> newArgs = new ArrayList<String>(args.toList());
            newArgs.set(newArgs.size() - 1, ((String)newArgs.get(newArgs.size() - 1)).replaceAll("(?<= )(-D[^\" ]+)= ", "$1=\"\" "));
            args = new ArgumentListBuilder(newArgs.toArray(new String[newArgs.size()]));
        }
        if (this.verbose != null && this.verbose.booleanValue()) {
            listener.getLogger().println();
            listener.getLogger().println(Messages.AntExec_DebugScriptSourceFieldBegin());
            listener.getLogger().println(scriptSourceResolved);
            listener.getLogger().println(Messages.AntExec_DebugScriptSourceFieldEnd());
            listener.getLogger().println();
            listener.getLogger().println(Messages.AntExec_DebugPropertiesFieldBegin());
            listener.getLogger().println(this.properties);
            listener.getLogger().println(Messages.AntExec_DebugPropertiesFieldEnd());
            listener.getLogger().println();
        }
        long startTime = System.currentTimeMillis();
        try {
            int r;
            AntConsoleAnnotator aca = new AntConsoleAnnotator((OutputStream)listener.getLogger(), build.getCharset());
            try {
                r = launcher.launch().cmds(args).envs((Map)env).stdout((OutputStream)aca).pwd(buildFile.getParent()).join();
            }
            finally {
                aca.forceEol();
                if (this.keepBuildfile == null || !this.keepBuildfile.booleanValue()) {
                    boolean deleteResponse2;
                    boolean deleteResponse1;
                    if (propertyFile != null && propertyFile.exists() && !(deleteResponse1 = propertyFile.delete())) {
                        listener.getLogger().println("The temporary property file coudn't be deleted");
                    }
                    if (!(deleteResponse2 = buildFile.delete())) {
                        listener.getLogger().println("The temporary Ant Build Script coudn't be deleted");
                    }
                }
            }
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            Object errorMessage = "command execution failed.";
            if (ai == null && System.currentTimeMillis() - startTime < 1000L) {
                errorMessage = this.getDescriptor().getInstallations() == null ? (String)errorMessage + " Maybe you need to configure where your Ant installations are?" : (String)errorMessage + " Maybe you need to configure the job to choose one of your Ant installations?";
            }
            e.printStackTrace(listener.fatalError((String)errorMessage));
            return false;
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    static String makeBuildFileXml(String scriptSource, String extendedScriptSource, String myScriptName) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        sb.append("<project default=\"" + myScriptName + "\" xmlns:antcontrib=\"antlib:net.sf.antcontrib\" basedir=\".\">\n\n");
        sb.append("<!-- Read additional properties -->\n");
        sb.append("<property file=\"" + myScriptName + ".properties\"/>\n\n");
        sb.append("<!-- Make environment variables accesible via ${env.VARIABLE} by default -->\n");
        sb.append("<property environment=\"env\"/>\n\n");
        sb.append("<target name=\"" + myScriptName + "\">\n");
        sb.append("<!-- Default target entered in the first textarea - begin -->\n");
        sb.append(scriptSource);
        sb.append("\n<!-- Default target entered in the first textarea -  end  -->\n");
        sb.append("</target>\n");
        if (extendedScriptSource != null && extendedScriptSource.length() > 0 && !extendedScriptSource.equals("")) {
            sb.append("<!-- Extended script source entered in the second textarea - begin -->\n");
            sb.append(extendedScriptSource);
            sb.append("\n<!-- Extended script source entered in the second textarea -  end  -->\n");
        }
        sb.append("</project>\n");
        return sb.toString();
    }

    static FilePath makeBuildFile(String scriptName, String targetSource, String extendedScriptSource, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        FilePath ws;
        String myScriptName = buildXml;
        if (scriptName != null && scriptName.length() > 0 && !scriptName.equals("")) {
            myScriptName = scriptName;
        }
        if ((ws = build.getWorkspace()) == null) {
            throw new AbortException("Cannot get Workspace for node, since it is not online");
        }
        FilePath buildFile = new FilePath(ws, myScriptName);
        buildFile.write(AntExec.makeBuildFileXml(targetSource, extendedScriptSource, myScriptName), null);
        return buildFile;
    }

    static FilePath makePropertyFile(String scriptName, AbstractBuild<?, ?> build, Properties buildProperties) throws IOException, InterruptedException {
        FilePath ws;
        String myScriptName = buildXml;
        if (scriptName != null && scriptName.length() > 0 && !scriptName.equals("")) {
            myScriptName = scriptName;
        }
        if ((ws = build.getWorkspace()) == null) {
            throw new AbortException("Cannot get Workspace for node, since it is not online");
        }
        FilePath propertyFile = new FilePath(ws, myScriptName + ".properties");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        buildProperties.store(baos, "Stored by AntExec Jenkins plugin");
        propertyFile.write(baos.toString("UTF-8"), "UTF-8");
        return propertyFile;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            super(AntExec.class);
            this.load();
        }

        public Ant.AntInstallation[] getInstallations() {
            return ((Ant.DescriptorImpl)Jenkins.get().getDescriptorByType(Ant.DescriptorImpl.class)).getInstallations();
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckScriptSource(@QueryParameter String value) throws IOException, ParserConfigurationException, SAXException {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String xmlContent = AntExec.makeBuildFileXml("", value, "test_script");
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                XMLReader reader = factory.newSAXParser().getXMLReader();
                reader.parse(new InputSource(new ByteArrayInputStream(xmlContent.getBytes("UTF-8"))));
                return FormValidation.ok();
            }
            catch (SAXException sax) {
                return FormValidation.error((String)("ERROR: " + sax.getLocalizedMessage()));
            }
        }

        private FormValidation doCheckExtendedScriptSource(@QueryParameter String value) throws IOException, ParserConfigurationException {
            String xmlContent = AntExec.makeBuildFileXml(value, "", "test_script");
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                XMLReader reader = factory.newSAXParser().getXMLReader();
                reader.parse(new InputSource(new ByteArrayInputStream(xmlContent.getBytes("UTF-8"))));
                return FormValidation.ok();
            }
            catch (SAXException sax) {
                return FormValidation.error((String)("ERROR: " + sax.getLocalizedMessage()));
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.AntExec_DisplayName();
        }
    }
}

