/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible.workflow;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.ansible.AnsibleInstallation;
import org.jenkinsci.plugins.ansible.AnsiblePlaybookBuilder;
import org.jenkinsci.plugins.ansible.ExtraVar;
import org.jenkinsci.plugins.ansible.Inventory;
import org.jenkinsci.plugins.ansible.InventoryContent;
import org.jenkinsci.plugins.ansible.InventoryPath;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class AnsiblePlaybookStep
extends AbstractStepImpl {
    private final String playbook;
    private String inventory;
    private String inventoryContent;
    private boolean dynamicInventory = false;
    private String installation;
    private String credentialsId;
    private String vaultCredentialsId;
    private String vaultTmpPath = null;
    private boolean become = false;
    private boolean checkMode = false;
    private String becomeUser = "root";
    private boolean sudo = false;
    private String sudoUser = "root";
    private String limit = null;
    private String tags = null;
    private String skippedTags = null;
    private String startAtTask = null;
    private Map extraVars = null;
    private String extras = null;
    private boolean colorized = false;
    private int forks = 0;
    private boolean disableHostKeyChecking = false;
    @Deprecated
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private transient boolean hostKeyChecking = true;

    @DataBoundConstructor
    public AnsiblePlaybookStep(String playbook) {
        this.playbook = playbook;
    }

    @DataBoundSetter
    public void setInventory(String inventory) {
        this.inventory = Util.fixEmptyAndTrim((String)inventory);
    }

    @DataBoundSetter
    public void setInventoryContent(String inventoryContent) {
        this.inventoryContent = Util.fixEmptyAndTrim((String)inventoryContent);
    }

    @DataBoundSetter
    public void setDynamicInventory(boolean dynamicInventory) {
        this.dynamicInventory = dynamicInventory;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
    }

    @DataBoundSetter
    public void setVaultCredentialsId(String vaultCredentialsId) {
        this.vaultCredentialsId = Util.fixEmptyAndTrim((String)vaultCredentialsId);
    }

    @DataBoundSetter
    public void setVaultTmpPath(String vaultTmpPath) {
        this.vaultTmpPath = vaultTmpPath;
    }

    @DataBoundSetter
    public void setBecome(boolean become) {
        this.become = become;
    }

    @DataBoundSetter
    public void setBecomeUser(String becomeUser) {
        this.becomeUser = Util.fixEmptyAndTrim((String)becomeUser);
    }

    @DataBoundSetter
    public void setCheckMode(boolean checkMode) {
        this.checkMode = checkMode;
    }

    @DataBoundSetter
    public void setSudo(boolean sudo) {
        this.sudo = sudo;
    }

    @DataBoundSetter
    public void setSudoUser(String sudoUser) {
        this.sudoUser = Util.fixEmptyAndTrim((String)sudoUser);
    }

    @DataBoundSetter
    public void setInstallation(String installation) {
        this.installation = Util.fixEmptyAndTrim((String)installation);
    }

    @DataBoundSetter
    public void setLimit(String limit) {
        this.limit = Util.fixEmptyAndTrim((String)limit);
    }

    @DataBoundSetter
    public void setTags(String tags) {
        this.tags = Util.fixEmptyAndTrim((String)tags);
    }

    @DataBoundSetter
    public void setSkippedTags(String skippedTags) {
        this.skippedTags = Util.fixEmptyAndTrim((String)skippedTags);
    }

    @DataBoundSetter
    public void setStartAtTask(String startAtTask) {
        this.startAtTask = Util.fixEmptyAndTrim((String)startAtTask);
    }

    @DataBoundSetter
    public void setExtraVars(Map extraVars) {
        this.extraVars = extraVars;
    }

    @DataBoundSetter
    public void setExtras(String extras) {
        this.extras = Util.fixEmptyAndTrim((String)extras);
    }

    @DataBoundSetter
    public void setColorized(boolean colorized) {
        this.colorized = colorized;
    }

    @DataBoundSetter
    public void setForks(int forks) {
        this.forks = forks;
    }

    @DataBoundSetter
    public void setDisableHostKeyChecking(boolean disableHostKeyChecking) {
        this.disableHostKeyChecking = disableHostKeyChecking;
    }

    @DataBoundSetter
    @Deprecated
    public void setHostKeyChecking(boolean hostKeyChecking) {
    }

    public String getInstallation() {
        return this.installation;
    }

    public String getPlaybook() {
        return this.playbook;
    }

    public String getInventory() {
        return this.inventory;
    }

    public String getInventoryContent() {
        return this.inventoryContent;
    }

    public boolean isDynamicInventory() {
        return this.dynamicInventory;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getVaultCredentialsId() {
        return this.vaultCredentialsId;
    }

    public String getVaultTmpPath() {
        return this.vaultTmpPath;
    }

    public boolean isBecome() {
        return this.become;
    }

    public String getBecomeUser() {
        return this.becomeUser;
    }

    public boolean isCheckMode() {
        return this.checkMode;
    }

    public boolean isSudo() {
        return this.sudo;
    }

    public String getSudoUser() {
        return this.sudoUser;
    }

    public String getLimit() {
        return this.limit;
    }

    public String getTags() {
        return this.tags;
    }

    public String getSkippedTags() {
        return this.skippedTags;
    }

    public String getStartAtTask() {
        return this.startAtTask;
    }

    public Map<String, Object> getExtraVars() {
        return this.extraVars;
    }

    public String getExtras() {
        return this.extras;
    }

    public boolean isDisableHostKeyChecking() {
        return this.disableHostKeyChecking;
    }

    @Deprecated
    public boolean isHostKeyChecking() {
        return true;
    }

    public int getForks() {
        return this.forks;
    }

    public boolean isColorized() {
        return this.colorized;
    }

    public static final class AnsiblePlaybookExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient AnsiblePlaybookStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars envVars;
        @StepContextParameter
        private transient Computer computer;

        private static List<ExtraVar> convertExtraVars(Map<String, Object> extraVars) {
            if (extraVars == null) {
                return null;
            }
            ArrayList<ExtraVar> extraVarList = new ArrayList<ExtraVar>();
            for (Map.Entry<String, Object> entry : extraVars.entrySet()) {
                ExtraVar var = new ExtraVar();
                var.setKey(entry.getKey());
                Object o = entry.getValue();
                if (o instanceof Map) {
                    var.setSecretValue(AnsiblePlaybookExecution.getSecretFromScalarValue(((Map)o).get("value")));
                    Object hidden = ((Map)o).get("hidden");
                    if (hidden instanceof Boolean) {
                        var.setHidden((Boolean)hidden);
                    } else {
                        var.setHidden(true);
                    }
                } else {
                    var.setSecretValue(AnsiblePlaybookExecution.getSecretFromScalarValue(o));
                    var.setHidden(true);
                }
                extraVarList.add(var);
            }
            return extraVarList;
        }

        private static Secret getSecretFromScalarValue(Object o) {
            if (o instanceof String) {
                return Secret.fromString((String)((String)o));
            }
            if (o instanceof Boolean) {
                return Secret.fromString((String)o.toString());
            }
            if (o instanceof Number) {
                return Secret.fromString((String)o.toString());
            }
            if (o instanceof Secret) {
                return (Secret)o;
            }
            return null;
        }

        protected Void run() throws Exception {
            Node node;
            Inventory inventory = null;
            if (StringUtils.isNotBlank((CharSequence)this.step.getInventory())) {
                inventory = new InventoryPath(this.step.getInventory());
            } else if (StringUtils.isNotBlank((CharSequence)this.step.getInventoryContent())) {
                inventory = new InventoryContent(this.step.getInventoryContent(), this.step.isDynamicInventory());
            }
            AnsiblePlaybookBuilder builder = new AnsiblePlaybookBuilder(this.step.getPlaybook(), inventory);
            builder.setAnsibleName(this.step.getInstallation());
            builder.setBecome(this.step.isBecome());
            builder.setBecomeUser(this.step.getBecomeUser());
            builder.setCheckMode(this.step.isCheckMode());
            builder.setSudo(this.step.isSudo());
            builder.setSudoUser(this.step.getSudoUser());
            builder.setCredentialsId(this.step.getCredentialsId(), true);
            builder.setVaultCredentialsId(this.step.getVaultCredentialsId());
            builder.setVaultTmpPath(this.step.getVaultTmpPath());
            builder.setForks(this.step.getForks());
            builder.setLimit(this.step.getLimit());
            builder.setTags(this.step.getTags());
            builder.setStartAtTask(this.step.getStartAtTask());
            builder.setSkippedTags(this.step.getSkippedTags());
            builder.setExtraVars(AnsiblePlaybookExecution.convertExtraVars(this.step.extraVars));
            builder.setAdditionalParameters(this.step.getExtras());
            builder.setDisableHostKeyChecking(this.step.isDisableHostKeyChecking());
            builder.setUnbufferedOutput(true);
            builder.setColorizedOutput(this.step.isColorized());
            if (this.computer == null || (node = this.computer.getNode()) == null) {
                throw new AbortException("The ansible playbook build step requires to be launched on a node");
            }
            builder.perform(this.run, node, this.ws, this.launcher, this.listener, this.envVars);
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(AnsiblePlaybookExecution.class);
        }

        public String getFunctionName() {
            return "ansiblePlaybook";
        }

        public String getDisplayName() {
            return "Invoke an ansible playbook";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(SSHUserPrivateKey.class), CredentialsMatchers.instanceOf(UsernamePasswordCredentials.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)item)).includeCurrentValue(credentialsId);
        }

        public ListBoxModel doFillVaultCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String vaultCredentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(vaultCredentialsId);
            }
            return result.includeEmptyValue().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(FileCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)item)).includeCurrentValue(vaultCredentialsId);
        }

        public ListBoxModel doFillInstallationItems() {
            ListBoxModel model = new ListBoxModel();
            for (AnsibleInstallation tool : AnsibleInstallation.allInstallations()) {
                model.add(tool.getName());
            }
            return model;
        }
    }
}

