/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible.workflow;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.ansible.AnsibleAdHocCommandBuilder;
import org.jenkinsci.plugins.ansible.AnsibleInstallation;
import org.jenkinsci.plugins.ansible.ExtraVar;
import org.jenkinsci.plugins.ansible.Inventory;
import org.jenkinsci.plugins.ansible.InventoryContent;
import org.jenkinsci.plugins.ansible.InventoryDoNotSpecify;
import org.jenkinsci.plugins.ansible.InventoryPath;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AnsibleAdhocStep
extends AbstractStepImpl {
    private String hosts;
    private String module;
    private String moduleArguments;
    private String inventory;
    private String inventoryContent;
    private boolean dynamicInventory = false;
    private String installation;
    private String credentialsId;
    private String vaultCredentialsId;
    private String vaultTmpPath = null;
    private boolean become = false;
    private String becomeUser = "root";
    private List<ExtraVar> extraVars = null;
    private String extras = null;
    private boolean colorized = false;
    private int forks = 0;
    private boolean hostKeyChecking = false;

    @DataBoundConstructor
    public AnsibleAdhocStep(String hosts) {
        this.hosts = hosts;
    }

    @DataBoundSetter
    public void setModule(String module) {
        this.module = Util.fixEmptyAndTrim((String)module);
    }

    @DataBoundSetter
    public void setModuleArguments(String moduleArguments) {
        this.moduleArguments = Util.fixEmptyAndTrim((String)moduleArguments);
    }

    @DataBoundSetter
    public void setInventory(String inventory) {
        this.inventory = Util.fixEmptyAndTrim((String)inventory);
    }

    @DataBoundSetter
    public void setInventoryContent(String inventoryContent) {
        this.inventoryContent = Util.fixEmptyAndTrim((String)inventoryContent);
    }

    @DataBoundSetter
    public void setDynamicInventory(boolean dynamicInventory) {
        this.dynamicInventory = dynamicInventory;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
    }

    @DataBoundSetter
    public void setVaultCredentialsId(String vaultCredentialsId) {
        this.vaultCredentialsId = Util.fixEmptyAndTrim((String)vaultCredentialsId);
    }

    @DataBoundSetter
    public void setVaultTmpPath(String vaultTmpPath) {
        this.vaultTmpPath = vaultTmpPath;
    }

    @DataBoundSetter
    public void setBecome(boolean become) {
        this.become = become;
    }

    @DataBoundSetter
    public void setBecomeUser(String becomeUser) {
        this.becomeUser = Util.fixEmptyAndTrim((String)becomeUser);
    }

    @DataBoundSetter
    public void setInstallation(String installation) {
        this.installation = Util.fixEmptyAndTrim((String)installation);
    }

    @DataBoundSetter
    public void setExtraVars(List<ExtraVar> extraVars) {
        this.extraVars = extraVars;
    }

    @DataBoundSetter
    public void setExtras(String extras) {
        this.extras = Util.fixEmptyAndTrim((String)extras);
    }

    @DataBoundSetter
    public void setColorized(boolean colorized) {
        this.colorized = colorized;
    }

    @DataBoundSetter
    public void setForks(int forks) {
        this.forks = forks;
    }

    @DataBoundSetter
    public void setHostKeyChecking(boolean hostKeyChecking) {
        this.hostKeyChecking = hostKeyChecking;
    }

    public String getInstallation() {
        return this.installation;
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getModule() {
        return this.module;
    }

    public String getModuleArguments() {
        return this.moduleArguments;
    }

    public String getInventory() {
        return this.inventory;
    }

    public String getInventoryContent() {
        return this.inventoryContent;
    }

    public boolean isDynamicInventory() {
        return this.dynamicInventory;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getVaultCredentialsId() {
        return this.vaultCredentialsId;
    }

    public String getVaultTmpPath() {
        return this.vaultTmpPath;
    }

    public boolean isBecome() {
        return this.become;
    }

    public String getBecomeUser() {
        return this.becomeUser;
    }

    public List<ExtraVar> getExtraVars() {
        return this.extraVars;
    }

    public String getExtras() {
        return this.extras;
    }

    public boolean isHostKeyChecking() {
        return this.hostKeyChecking;
    }

    public int getForks() {
        return this.forks;
    }

    public boolean isColorized() {
        return this.colorized;
    }

    public static final class AnsibleAdhocExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient AnsibleAdhocStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars envVars;
        @StepContextParameter
        private transient Computer computer;

        protected Void run() throws Exception {
            Inventory inventory = null;
            inventory = StringUtils.isNotBlank((CharSequence)this.step.getInventory()) ? new InventoryPath(this.step.getInventory()) : (StringUtils.isNotBlank((CharSequence)this.step.getInventoryContent()) ? new InventoryContent(this.step.getInventoryContent(), this.step.isDynamicInventory()) : new InventoryDoNotSpecify());
            AnsibleAdHocCommandBuilder builder = new AnsibleAdHocCommandBuilder(this.step.getHosts(), inventory, this.step.getModule(), this.step.getModuleArguments());
            builder.setAnsibleName(this.step.getInstallation());
            builder.setBecome(this.step.isBecome());
            builder.setBecomeUser(this.step.getBecomeUser());
            builder.setCredentialsId(this.step.getCredentialsId());
            builder.setVaultCredentialsId(this.step.getVaultCredentialsId());
            builder.setVaultTmpPath(this.step.getVaultTmpPath());
            builder.setForks(this.step.getForks());
            builder.setExtraVars(this.step.getExtraVars());
            builder.setAdditionalParameters(this.step.getExtras());
            builder.setHostKeyChecking(this.step.isHostKeyChecking());
            builder.setColorizedOutput(this.step.isColorized());
            builder.perform(this.run, this.ws, this.launcher, this.listener);
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(AnsibleAdhocExecution.class);
        }

        public String getFunctionName() {
            return "ansibleAdhoc";
        }

        public String getDisplayName() {
            return "Invoke an ansible adhoc command";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Project project) {
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(SSHUserPrivateKey.class), CredentialsMatchers.instanceOf(UsernamePasswordCredentials.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)project));
        }

        public ListBoxModel doFillVaultCredentialsIdItems(@AncestorInPath Project project) {
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(FileCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)project));
        }

        public ListBoxModel doFillInstallationItems() {
            ListBoxModel model = new ListBoxModel();
            for (AnsibleInstallation tool : AnsibleInstallation.allInstallations()) {
                model.add(tool.getName());
            }
            return model;
        }
    }
}

