/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.ansible.Inventory;
import org.kohsuke.stapler.DataBoundConstructor;

public class InventoryPath
extends Inventory {
    public final String path;

    @DataBoundConstructor
    public InventoryPath(String path) {
        this.path = path;
    }

    @Override
    protected Inventory.InventoryHandler getHandler() {
        return new Inventory.InventoryHandler(){

            @Override
            public void addArgument(ArgumentListBuilder args, FilePath workspace, EnvVars envVars, TaskListener listener) {
                String expandedPath = envVars.expand(InventoryPath.this.path);
                if (StringUtils.isNotEmpty((CharSequence)expandedPath)) {
                    args.add("-i").add(expandedPath);
                }
            }

            @Override
            public void tearDown(TaskListener listener) {
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends Inventory.InventoryDescriptor {
        public String getDisplayName() {
            return "File or host list";
        }
    }
}

