/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import org.jenkinsci.plugins.ansible.Inventory;
import org.jenkinsci.plugins.ansible.Utils;
import org.kohsuke.stapler.DataBoundConstructor;

public class InventoryContent
extends Inventory {
    public final String content;
    public final boolean dynamic;
    private transient FilePath inventory = null;

    @DataBoundConstructor
    public InventoryContent(String content, boolean dynamic) {
        this.content = content;
        this.dynamic = dynamic;
    }

    @Override
    protected Inventory.InventoryHandler getHandler() {
        return new Inventory.InventoryHandler(){

            @Override
            public void addArgument(ArgumentListBuilder args, FilePath workspace, EnvVars envVars, TaskListener listener) throws InterruptedException, IOException {
                InventoryContent.this.inventory = this.createInventoryFile(InventoryContent.this.inventory, workspace, envVars.expand(InventoryContent.this.content));
                args.add("-i").add((Object)InventoryContent.this.inventory);
            }

            @Override
            public void tearDown(TaskListener listener) throws InterruptedException, IOException {
                Utils.deleteTempFile(InventoryContent.this.inventory, listener);
            }

            private FilePath createInventoryFile(FilePath inventory, FilePath workspace, String content) throws IOException, InterruptedException {
                inventory = workspace.createTextTempFile("inventory", ".ini", content, false);
                inventory.chmod(InventoryContent.this.dynamic ? 320 : 256);
                return inventory;
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends Inventory.InventoryDescriptor {
        public String getDisplayName() {
            return "Inline content";
        }
    }
}

