/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import org.jenkinsci.plugins.ansible.AbstractAnsibleInvocation;
import org.jenkinsci.plugins.ansible.AnsibleInvocationException;
import org.jenkinsci.plugins.ansible.Utils;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class AnsibleVaultInvocation
extends AbstractAnsibleInvocation<AnsibleVaultInvocation> {
    private String action;
    private String content;
    private String input;
    private String output;
    private StandardCredentials newVaultCredentials;
    private FilePath newVaultPassword = null;
    private FilePath ws = null;

    protected AnsibleVaultInvocation(String exe, AbstractBuild<?, ?> build, BuildListener listener, EnvVars envVars) throws IOException, InterruptedException, AnsibleInvocationException {
        this(exe, (Run<?, ?>)build, build.getWorkspace(), (TaskListener)listener, envVars);
    }

    public AnsibleVaultInvocation(String exe, Run<?, ?> build, FilePath ws, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException, AnsibleInvocationException {
        super(exe, build, ws, listener, envVars);
        this.ws = ws;
    }

    public AnsibleVaultInvocation setAction(String action) {
        this.action = action;
        return this;
    }

    private ArgumentListBuilder appendAction(ArgumentListBuilder args) throws AbortException {
        if ("edit".equals(this.action) || "create".equals(this.action) || "view".equals(this.action)) {
            throw new AbortException(this.action + ": ansible-plugin does not support interactive vault actions such as create, edit, or view.");
        }
        args.add(this.action);
        return args;
    }

    public AnsibleVaultInvocation setContent(String content) {
        this.content = content;
        return this;
    }

    private ArgumentListBuilder appendContent(ArgumentListBuilder args) {
        if (this.content != null && !this.content.isEmpty()) {
            args.addMasked(this.content);
        }
        return args;
    }

    public AnsibleVaultInvocation setInput(String input) {
        this.input = input;
        return this;
    }

    private ArgumentListBuilder appendInput(ArgumentListBuilder args) {
        if (this.input != null && !this.input.isEmpty()) {
            args.add(this.input);
        }
        return args;
    }

    public AnsibleVaultInvocation setNewVaultCredentials(StandardCredentials newVaultCredentials) {
        this.newVaultCredentials = newVaultCredentials;
        return this;
    }

    protected ArgumentListBuilder appendNewVaultPasswordFile(ArgumentListBuilder args) throws IOException, InterruptedException {
        if (this.newVaultCredentials != null) {
            FilePath tmpPath;
            FilePath filePath = tmpPath = this.vaultTmpPath != null ? this.vaultTmpPath : this.ws;
            if (this.newVaultCredentials instanceof FileCredentials) {
                FileCredentials secretFile = (FileCredentials)this.newVaultCredentials;
                this.newVaultPassword = Utils.createVaultPasswordFile(this.newVaultPassword, tmpPath, secretFile);
                args.add("--new-vault-password-file").add(this.newVaultPassword.getRemote().replace("%", "%%"));
            } else if (this.newVaultCredentials instanceof StringCredentials) {
                StringCredentials secretText = (StringCredentials)this.newVaultCredentials;
                this.newVaultPassword = Utils.createVaultPasswordFile(this.newVaultPassword, tmpPath, secretText);
                args.add("--new-vault-password-file").add(this.newVaultPassword.getRemote().replace("%", "%%"));
            }
        }
        return args;
    }

    public AnsibleVaultInvocation setOutput(String output) {
        this.output = output;
        return this;
    }

    private ArgumentListBuilder appendOutput(ArgumentListBuilder args) {
        if (this.output != null && !this.output.isEmpty()) {
            args.add(this.output);
        }
        return args;
    }

    @Override
    protected ArgumentListBuilder buildCommandLine() throws InterruptedException, AnsibleInvocationException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        this.prependPasswordCredentials(args);
        this.appendExecutable(args);
        this.appendAction(args);
        this.appendVaultPasswordFile(args);
        this.appendNewVaultPasswordFile(args);
        this.appendOutput(args);
        this.appendContent(args);
        this.appendInput(args);
        return args;
    }
}

