/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.additionalmetrics;

import hudson.model.Run;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.scm.GenericSCMStep;

class CheckoutDuration {
    private CheckoutDuration() {
    }

    static long checkoutDurationOf(Run run) {
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance == null || instance.getPlugin("workflow-job") == null) {
            return 0L;
        }
        if (!(run instanceof WorkflowRun)) {
            return 0L;
        }
        WorkflowRun currentBuild = (WorkflowRun)run;
        FlowExecution execution = currentBuild.getExecution();
        if (execution == null) {
            return 0L;
        }
        return CheckoutDuration.countCheckoutDuration(execution);
    }

    private static long countCheckoutDuration(FlowExecution execution) {
        long totalCheckoutTime = 0L;
        FlowGraphWalker graphWalker = new FlowGraphWalker(execution);
        FlowNode nextNode = null;
        for (FlowNode node : graphWalker) {
            StepAtomNode stepNode;
            StepDescriptor descriptor;
            if (node instanceof StepAtomNode && (descriptor = (stepNode = (StepAtomNode)node).getDescriptor()) != null && descriptor.clazz.equals(GenericSCMStep.class)) {
                totalCheckoutTime += TimingAction.getStartTime((FlowNode)nextNode) - TimingAction.getStartTime((FlowNode)node);
            }
            nextNode = node;
        }
        return totalCheckoutTime;
    }
}

